/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.ant;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.wasdev.wlp.ant.AbstractTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.FileUtils;

public class UndeployTask
extends AbstractTask {
    private static final String STOP_APP_MESSAGE_CODE_REG = "CWWKZ0009I.*";
    private String fileName;
    private PatternSet pattern;
    private String timeout;
    private static final long APP_STOP_TIMEOUT_DEFAULT = 30000L;

    public void execute() {
        super.initTask();
        List<File> files = this.scanFileSets();
        long appStopTimeout = 30000L;
        if (this.timeout != null && !this.timeout.equals("")) {
            appStopTimeout = Long.valueOf(this.timeout);
        }
        for (File file : files) {
            this.log(MessageFormat.format(messages.getString("info.undeploy"), file.getName()));
            FileUtils.delete((File)file);
            String stopMessage = STOP_APP_MESSAGE_CODE_REG + this.getFileName(file.getName());
            if (this.waitForStringInLog(stopMessage, appStopTimeout, this.getLogFile()) != null) continue;
            throw new BuildException(MessageFormat.format(messages.getString("error.undeploy.fail"), file.getPath()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<File> scanFileSets() throws BuildException {
        File dropinsDir = new File(this.serverConfigDir, "dropins");
        ArrayList<File> list = new ArrayList<File>();
        if (this.fileName != null) {
            File fileUndeploy = new File(dropinsDir, this.fileName);
            if (!fileUndeploy.exists()) throw new BuildException(MessageFormat.format(messages.getString("error.undeploy.file.noexist"), fileUndeploy.getPath()));
            list.add(fileUndeploy);
            return list;
        } else {
            String[] names;
            FileSet dropins = new FileSet();
            dropins.setDir(dropinsDir);
            if (this.pattern != null) {
                dropins.appendIncludes(this.pattern.getIncludePatterns(this.getProject()));
                dropins.appendExcludes(this.pattern.getExcludePatterns(this.getProject()));
            }
            DirectoryScanner ds = dropins.getDirectoryScanner(this.getProject());
            ds.scan();
            for (String element : names = ds.getIncludedFiles()) {
                list.add(new File(ds.getBasedir(), element));
            }
        }
        return list;
    }

    public void setFile(String fileName) {
        this.fileName = fileName;
    }

    public String getFile() {
        return this.fileName;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public void addPatternset(PatternSet pattern) {
        this.pattern = pattern;
    }
}

