/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.ant.install;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wasdev.wlp.ant.install.LibertyInfo;
import net.wasdev.wlp.ant.install.Version;
import org.apache.tools.ant.BuildException;

public class InstallUtils {
    private InstallUtils() {
    }

    private static String readAsString(InputStream in, String encoding) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, encoding));
        String line = null;
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
            builder.append("\r\n");
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLicenseCode(File file, String regex) throws IOException {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            string = InstallUtils.getLicenseCode(in, "UTF-8", regex);
        }
        catch (Throwable throwable) {
            InstallUtils.close(in);
            throw throwable;
        }
        InstallUtils.close(in);
        return string;
    }

    public static String getLicenseCode(InputStream in, String encoding, String regex) throws IOException {
        String text = InstallUtils.readAsString(in, encoding);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static LibertyInfo selectVersion(Version version, List<LibertyInfo> versions) {
        ArrayList<LibertyInfo> candidates = new ArrayList<LibertyInfo>();
        for (LibertyInfo info : versions) {
            if (!version.match(info.getVersion())) continue;
            candidates.add(info);
        }
        if (candidates.size() == 0) {
            throw new BuildException("No candidates found for " + version + " version.");
        }
        if (candidates.size() == 1) {
            return (LibertyInfo)candidates.get(0);
        }
        Collections.sort(candidates, new Comparator<LibertyInfo>(){

            @Override
            public int compare(LibertyInfo obj1, LibertyInfo obj2) {
                return obj2.getVersion().compareTo(obj1.getVersion());
            }
        });
        return (LibertyInfo)candidates.get(0);
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getFile(URL url) {
        String path = url.getPath();
        int index = path.lastIndexOf(47);
        String file = index == -1 ? path : path.substring(index + 1);
        return file;
    }

    public static void createDirectory(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new BuildException("Unable to create " + dir + " directory.");
        }
    }
}

