/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.common.arquillian.objects;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.wasdev.wlp.common.arquillian.objects.LibertyManagedObject;
import net.wasdev.wlp.common.arquillian.objects.LibertyRemoteObject;
import net.wasdev.wlp.common.arquillian.util.ArquillianConfigurationException;

public class LibertyProperty {
    public static Map<LibertyPropertyI, String> getArquillianProperties(Map<String, String> arquillianProperties, Class<?> cls) throws ArquillianConfigurationException {
        HashMap<LibertyPropertyI, String> props = new HashMap<LibertyPropertyI, String>();
        if (arquillianProperties != null && !arquillianProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : arquillianProperties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || value == null) continue;
                LibertyPropertyI p = LibertyProperty.getArquillianProperty(key, cls);
                props.put(p, value);
            }
        }
        return props;
    }

    private static LibertyPropertyI getArquillianProperty(String key, Class<?> cls) throws ArquillianConfigurationException {
        try {
            if (cls == LibertyManagedObject.LibertyManagedProperty.class) {
                return LibertyManagedObject.LibertyManagedProperty.valueOf(key);
            }
            if (cls == LibertyRemoteObject.LibertyRemoteProperty.class) {
                return LibertyRemoteObject.LibertyRemoteProperty.valueOf(key);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ArquillianConfigurationException("Property \"" + key + "\" in arquillianProperties does not exist. You probably have a typo.");
        }
        throw new ArquillianConfigurationException("This should never happen.");
    }

    protected static void write(StringBuilder xml, File arquillianXml) throws IOException {
        File arquillianXmlFolder = arquillianXml.getParentFile();
        if (!arquillianXmlFolder.exists()) {
            arquillianXmlFolder.mkdirs();
        }
        FileWriter writer = new FileWriter(arquillianXml);
        writer.write(xml.toString());
        writer.close();
    }

    public static interface LibertyPropertyI {
    }
}

