/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.common.plugins.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.MatchResult;
import javax.xml.parsers.ParserConfigurationException;
import net.wasdev.wlp.common.plugins.config.XmlDocument;
import net.wasdev.wlp.common.plugins.util.OSUtil;
import net.wasdev.wlp.common.plugins.util.PluginExecutionException;
import net.wasdev.wlp.common.plugins.util.PluginScenarioException;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class InstallFeatureUtil {
    public static final String OPEN_LIBERTY_GROUP_ID = "io.openliberty.features";
    public static final String REPOSITORY_RESOLVER_ARTIFACT_ID = "repository-resolver";
    public static final String INSTALL_MAP_ARTIFACT_ID = "install-map";
    private final File installDirectory;
    private final File installJarFile;
    private final List<ProductProperties> propertiesList;
    private final String to;
    private final Set<File> downloadedJsons;
    private static final String INSTALL_MAP_PREFIX = "com.ibm.ws.install.map";
    private static final String INSTALL_MAP_SUFFIX = ".jar";
    private static final String OPEN_LIBERTY_PRODUCT_ID = "io.openliberty";
    private static final int COPY_FILE_TIMEOUT_MILLIS = 300000;
    private String openLibertyVersion;

    public InstallFeatureUtil(File installDirectory, String from, String to, Set<String> pluginListedEsas) throws PluginScenarioException, PluginExecutionException {
        this.installDirectory = installDirectory;
        this.to = to;
        this.propertiesList = this.loadProperties(new File(installDirectory, "lib/versions"));
        this.installJarFile = this.loadInstallJarFile(installDirectory);
        if (this.installJarFile == null) {
            throw new PluginScenarioException("Install map jar not found.");
        }
        this.downloadedJsons = this.downloadProductJsons();
        if (this.downloadedJsons.isEmpty()) {
            throw new PluginScenarioException("Cannot find JSONs for to the installed runtime from the Maven repository.");
        }
        if (this.hasUnsupportedParameters(from, pluginListedEsas)) {
            throw new PluginScenarioException("Cannot install features from a Maven repository when using the 'to' or 'from' parameters or when specifying ESA files.");
        }
    }

    private File loadInstallJarFile(File installDirectory) {
        File installJarOverride;
        if (this.openLibertyVersion != null && (installJarOverride = this.downloadOverrideJar(OPEN_LIBERTY_GROUP_ID, INSTALL_MAP_ARTIFACT_ID)) != null && installJarOverride.exists()) {
            return installJarOverride;
        }
        return InstallFeatureUtil.getMapBasedInstallKernelJar(new File(installDirectory, "lib"));
    }

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void debug(Throwable var1);

    public abstract void warn(String var1);

    public abstract void info(String var1);

    public abstract boolean isDebugEnabled();

    public abstract File downloadArtifact(String var1, String var2, String var3, String var4) throws PluginExecutionException;

    @SafeVarargs
    public static Set<String> combineToSet(Collection<String> ... collections) {
        HashSet<String> result = new HashSet<String>();
        for (Collection<String> collection : collections) {
            if (collection == null) continue;
            result.addAll(collection);
        }
        return result;
    }

    public Set<String> getServerFeatures(File serverDirectory) {
        Set<String> result = this.getConfigDropinsFeatures(null, serverDirectory, "defaults");
        result = this.getServerXmlFeatures(result, new File(serverDirectory, "server.xml"), null);
        return this.getConfigDropinsFeatures(result, serverDirectory, "overrides");
    }

    private Set<String> getConfigDropinsFeatures(Set<String> origResult, File serverDirectory, String folderName) {
        File configDropinsFolder;
        Set<String> result = origResult;
        try {
            configDropinsFolder = new File(new File(serverDirectory, "configDropins"), folderName).getCanonicalFile();
        }
        catch (IOException e) {
            this.warn("The " + serverDirectory + "/configDropins/" + folderName + " directory cannot be accessed. Skipping its server features.");
            this.debug(e);
            return result;
        }
        File[] configDropinsXmls = configDropinsFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        if (configDropinsXmls == null || configDropinsXmls.length == 0) {
            return result;
        }
        Comparator<File> comparator = new Comparator<File>(){

            @Override
            public int compare(File left, File right) {
                return left.getAbsolutePath().toLowerCase().compareTo(right.getAbsolutePath().toLowerCase());
            }
        };
        Collections.sort(Arrays.asList(configDropinsXmls), comparator);
        for (File xml : configDropinsXmls) {
            Set<String> features = this.getServerXmlFeatures(result, xml, null);
            if (features == null) continue;
            result = features;
        }
        return result;
    }

    private Set<String> getServerXmlFeatures(Set<String> origResult, File serverFile, List<File> parsedXmls) {
        File canonicalServerFile;
        Set<String> result = origResult;
        ArrayList<File> updatedParsedXmls = parsedXmls != null ? parsedXmls : new ArrayList<File>();
        try {
            canonicalServerFile = serverFile.getCanonicalFile();
        }
        catch (IOException e) {
            this.warn("The server file " + serverFile + " cannot be accessed. Skipping its features.");
            this.debug(e);
            return result;
        }
        updatedParsedXmls.add(canonicalServerFile);
        if (canonicalServerFile.exists()) {
            try {
                Document doc = new XmlDocument(){

                    public Document getDocument(File file) throws IOException, ParserConfigurationException, SAXException {
                        this.createDocument(file);
                        return this.doc;
                    }
                }.getDocument(canonicalServerFile);
                Element root = doc.getDocumentElement();
                NodeList nodes = root.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    if (!(nodes.item(i) instanceof Element)) continue;
                    Element child = (Element)nodes.item(i);
                    if ("featureManager".equals(child.getNodeName())) {
                        if (result == null) {
                            result = new HashSet<String>();
                        }
                        result.addAll(InstallFeatureUtil.parseFeatureManagerNode(child));
                        continue;
                    }
                    if (!"include".equals(child.getNodeName())) continue;
                    result = this.parseIncludeNode(result, canonicalServerFile, child, updatedParsedXmls);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                this.warn("The server file " + serverFile + " cannot be parsed. Skipping its features.");
                this.debug(e);
                return result;
            }
        }
        return result;
    }

    private Set<String> parseIncludeNode(Set<String> origResult, File serverFile, Element node, List<File> updatedParsedXmls) {
        Set<String> result = origResult;
        String includeFileName = node.getAttribute("location");
        if (includeFileName == null || includeFileName.trim().isEmpty()) {
            return result;
        }
        File includeFile = null;
        if (InstallFeatureUtil.isURL(includeFileName)) {
            try {
                File tempFile = File.createTempFile("serverFromURL", ".xml");
                FileUtils.copyURLToFile((URL)new URL(includeFileName), (File)tempFile, (int)300000, (int)300000);
                includeFile = tempFile;
            }
            catch (IOException e) {
                this.warn("The server file " + serverFile + " includes a URL " + includeFileName + " that cannot be accessed. Skipping the included features.");
                this.debug(e);
                return result;
            }
        } else {
            includeFile = new File(includeFileName);
        }
        try {
            includeFile = !includeFile.isAbsolute() ? new File(serverFile.getParentFile().getAbsolutePath(), includeFileName).getCanonicalFile() : includeFile.getCanonicalFile();
        }
        catch (IOException e) {
            this.warn("The server file " + serverFile + " includes a file " + includeFileName + " that cannot be accessed. Skipping the included features.");
            this.debug(e);
            return result;
        }
        if (!updatedParsedXmls.contains(includeFile)) {
            String onConflict = node.getAttribute("onConflict");
            Set<String> features = this.getServerXmlFeatures(null, includeFile, updatedParsedXmls);
            result = this.handleOnConflict(result, onConflict, features);
        }
        return result;
    }

    private Set<String> handleOnConflict(Set<String> origResult, String onConflict, Set<String> features) {
        Set<String> result = origResult;
        if ("replace".equalsIgnoreCase(onConflict)) {
            if (features != null && !features.isEmpty()) {
                result = features;
            }
        } else if ("ignore".equalsIgnoreCase(onConflict)) {
            if (result == null) {
                result = features;
            }
        } else if (features != null) {
            if (result == null) {
                result = features;
            } else {
                result.addAll(features);
            }
        }
        return result;
    }

    private static Set<String> parseFeatureManagerNode(Element node) {
        HashSet<String> result = new HashSet<String>();
        NodeList features = node.getElementsByTagName("feature");
        if (features != null) {
            for (int j = 0; j < features.getLength(); ++j) {
                String content = features.item(j).getTextContent();
                if (content == null) continue;
                if (content.contains(":")) {
                    String[] split = content.split(":", 2);
                    result.add(split[1].trim().toLowerCase());
                    continue;
                }
                result.add(content.trim().toLowerCase());
            }
        }
        return result;
    }

    private Set<File> downloadProductJsons() throws PluginExecutionException {
        HashSet<File> downloadedJsons = new HashSet<File>();
        for (ProductProperties properties : this.propertiesList) {
            File json = this.downloadJsons(properties.getId(), properties.getVersion());
            if (json == null) continue;
            downloadedJsons.add(json);
        }
        return downloadedJsons;
    }

    private File downloadJsons(String productId, String productVersion) {
        String jsonGroupId = productId + ".features";
        try {
            return this.downloadArtifact(jsonGroupId, "features", "json", productVersion);
        }
        catch (PluginExecutionException e) {
            this.debug("Cannot find json for productId " + productId + ", productVersion " + productVersion, e);
            return null;
        }
    }

    private List<ProductProperties> loadProperties(File dir) throws PluginExecutionException {
        ArrayList<ProductProperties> list = new ArrayList<ProductProperties>();
        File[] propertiesFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        if (propertiesFiles != null) {
            for (File propertiesFile : propertiesFiles) {
                Properties properties = new Properties();
                FileInputStream input = null;
                try {
                    input = new FileInputStream(propertiesFile);
                    properties.load(input);
                    String productId = properties.getProperty("com.ibm.websphere.productId");
                    String productVersion = properties.getProperty("com.ibm.websphere.productVersion");
                    if (productId == null) {
                        throw new PluginExecutionException("Cannot find the \"com.ibm.websphere.productId\" property in the file " + propertiesFile.getAbsolutePath() + ". Ensure the file is valid properties file for the Liberty product or extension.");
                    }
                    if (productVersion == null) {
                        throw new PluginExecutionException("Cannot find the \"com.ibm.websphere.productVersion\" property in the file " + propertiesFile.getAbsolutePath() + ". Ensure the file is valid properties file for the Liberty product or extension.");
                    }
                    if (productId.equals(OPEN_LIBERTY_PRODUCT_ID)) {
                        this.openLibertyVersion = productVersion;
                    }
                    list.add(new ProductProperties(productId, productVersion));
                }
                catch (IOException e) {
                    throw new PluginExecutionException("Cannot read the product properties file " + propertiesFile.getAbsolutePath(), e);
                }
                finally {
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        if (list.isEmpty()) {
            throw new PluginExecutionException("Could not find any properties file in the " + dir + " directory. Ensure the directory " + this.installDirectory + " contains a Liberty installation.");
        }
        return list;
    }

    private boolean hasUnsupportedParameters(String from, Set<String> pluginListedEsas) {
        boolean hasFrom = from != null;
        boolean hasPluginListedEsas = !pluginListedEsas.isEmpty();
        this.debug("hasFrom: " + hasFrom);
        this.debug("hasPluginListedEsas: " + hasPluginListedEsas);
        return hasFrom || hasPluginListedEsas;
    }

    private File downloadEsaArtifact(String mavenCoordinates) throws PluginExecutionException {
        String[] mavenCoordinateArray = mavenCoordinates.split(":");
        String groupId = mavenCoordinateArray[0];
        String artifactId = mavenCoordinateArray[1];
        String version = mavenCoordinateArray[2];
        return this.downloadArtifact(groupId, artifactId, "esa", version);
    }

    private List<File> downloadEsas(Collection<?> mavenCoordsList) throws PluginExecutionException {
        ArrayList<File> repoPaths = new ArrayList<File>();
        for (Object coordinate : mavenCoordsList) {
            repoPaths.add(this.downloadEsaArtifact((String)coordinate));
        }
        return repoPaths;
    }

    public static Set<String> getOpenLibertyFeatureSet(Set<File> jsons) throws PluginExecutionException {
        HashSet<String> libertyFeatures = new HashSet<String>();
        for (File file : jsons) {
            Scanner s = null;
            try {
                s = new Scanner(file);
                while (s.findWithinHorizon("io.openliberty.features:([^:]*):", 0) != null) {
                    MatchResult match = s.match();
                    if (match.groupCount() < 1) continue;
                    libertyFeatures.add(match.group(1));
                }
            }
            catch (FileNotFoundException e) {
                throw new PluginExecutionException("The JSON file is not found at " + file.getAbsolutePath(), e);
            }
            finally {
                if (s == null) continue;
                s.close();
            }
        }
        return libertyFeatures;
    }

    private boolean isOnlyOpenLibertyFeatures(List<String> featuresToInstall) throws PluginExecutionException {
        boolean result = InstallFeatureUtil.containsIgnoreCase(InstallFeatureUtil.getOpenLibertyFeatureSet(this.downloadedJsons), featuresToInstall);
        this.debug("Is installing only Open Liberty features? " + result);
        return result;
    }

    public static boolean containsIgnoreCase(Collection<String> reference, Collection<String> target) {
        return InstallFeatureUtil.toLowerCase(reference).containsAll(InstallFeatureUtil.toLowerCase(target));
    }

    private static Set<String> toLowerCase(Collection<String> strings) {
        HashSet<String> result = new HashSet<String>(strings.size());
        for (String s : strings) {
            result.add(s.toLowerCase());
        }
        return result;
    }

    public void installFeatures(boolean isAcceptLicense, List<String> featuresToInstall) throws PluginExecutionException {
        ArrayList<File> jsonRepos = new ArrayList<File>(this.downloadedJsons);
        this.debug("JSON repos: " + jsonRepos);
        this.info("Installing features: " + featuresToInstall);
        boolean acceptLicenseMapValue = this.isOnlyOpenLibertyFeatures(featuresToInstall) ? true : isAcceptLicense;
        try {
            Collection resolvedFeatures;
            Map<String, Object> mapBasedInstallKernel = this.createMapBasedInstallKernelInstance(this.installDirectory);
            mapBasedInstallKernel.put("install.local.esa", true);
            mapBasedInstallKernel.put("single.json.file", jsonRepos);
            mapBasedInstallKernel.put("features.to.resolve", featuresToInstall);
            mapBasedInstallKernel.put("license.accept", acceptLicenseMapValue);
            if (this.isDebugEnabled()) {
                mapBasedInstallKernel.put("debug", Level.FINEST);
            }
            if ((resolvedFeatures = (Collection)mapBasedInstallKernel.get("action.result")) == null) {
                this.debug("action.exception.stacktrace: " + mapBasedInstallKernel.get("action.exception.stacktrace"));
                String exceptionMessage = (String)mapBasedInstallKernel.get("action.error.message");
                throw new PluginExecutionException(exceptionMessage);
            }
            if (resolvedFeatures.isEmpty()) {
                this.debug("action.exception.stacktrace: " + mapBasedInstallKernel.get("action.exception.stacktrace"));
                String exceptionMessage = (String)mapBasedInstallKernel.get("action.error.message");
                if (exceptionMessage == null) {
                    this.debug("resolvedFeatures was empty but the install kernel did not issue any messages");
                    this.info("The features are already installed, so no action is needed.");
                    return;
                }
                if (exceptionMessage.contains("CWWKF1250I")) {
                    this.info(exceptionMessage);
                    this.info("The features are already installed, so no action is needed.");
                    return;
                }
                throw new PluginExecutionException(exceptionMessage);
            }
            List<File> artifacts = this.downloadEsas(resolvedFeatures);
            StringBuilder installedFeaturesBuilder = new StringBuilder();
            ArrayList actionReturnResult = new ArrayList();
            for (File esaFile : artifacts) {
                mapBasedInstallKernel.put("license.accept", acceptLicenseMapValue);
                mapBasedInstallKernel.put("action.install", esaFile);
                if (this.to != null) {
                    mapBasedInstallKernel.put("to.extension", this.to);
                    this.debug("Installing to extension: " + this.to);
                }
                Integer ac = (Integer)mapBasedInstallKernel.get("action.result");
                this.debug("action.result: " + ac);
                this.debug("action.error.message: " + mapBasedInstallKernel.get("action.error.message"));
                if (mapBasedInstallKernel.get("action.error.message") != null) {
                    this.debug("action.exception.stacktrace: " + mapBasedInstallKernel.get("action.exception.stacktrace"));
                    String exceptionMessage = (String)mapBasedInstallKernel.get("action.error.message");
                    this.debug(exceptionMessage);
                    throw new PluginExecutionException(exceptionMessage);
                }
                if (mapBasedInstallKernel.get("action.install.result") == null) continue;
                actionReturnResult.addAll((Collection)mapBasedInstallKernel.get("action.install.result"));
            }
            for (String installResult : actionReturnResult) {
                installedFeaturesBuilder.append(installResult).append(" ");
            }
            this.productInfoValidate();
            this.info("The following features have been installed: " + installedFeaturesBuilder.toString());
        }
        catch (PrivilegedActionException e) {
            throw new PluginExecutionException("Could not load the jar " + this.installJarFile.getAbsolutePath(), e);
        }
    }

    private Map<String, Object> createMapBasedInstallKernelInstance(File installDirectory) throws PrivilegedActionException, PluginExecutionException {
        Map<String, Object> mapBasedInstallKernel = AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, Object>>(){

            @Override
            public Map<String, Object> run() throws Exception {
                URLClassLoader loader = new URLClassLoader(new URL[]{InstallFeatureUtil.this.installJarFile.toURI().toURL()}, this.getClass().getClassLoader());
                Class<?> clazz = loader.loadClass("com.ibm.ws.install.map.InstallMap");
                return (Map)clazz.newInstance();
            }
        });
        if (mapBasedInstallKernel == null) {
            throw new PluginExecutionException("Cannot run install jar file " + this.installJarFile);
        }
        String bundle = this.getOverrideBundleDescriptor(OPEN_LIBERTY_GROUP_ID, REPOSITORY_RESOLVER_ARTIFACT_ID);
        if (bundle != null) {
            ArrayList<String> bundles = new ArrayList<String>();
            bundles.add(bundle);
            this.debug("Overriding jar using: " + bundle);
            mapBasedInstallKernel.put("override.jar.bundles", bundles);
        }
        mapBasedInstallKernel.put("runtime.install.dir", installDirectory);
        try {
            mapBasedInstallKernel.put("install.map.jar.file", this.installJarFile);
            this.debug("install.map.jar.file: " + this.installJarFile);
        }
        catch (RuntimeException e) {
            this.debug("This version of the install map does not support the key \"install.map.jar.file\"", e);
            String installJarFileSubpath = this.installJarFile.getParentFile().getName() + File.separator + this.installJarFile.getName();
            mapBasedInstallKernel.put("install.map.jar", installJarFileSubpath);
            this.debug("install.map.jar: " + installJarFileSubpath);
        }
        this.debug("install.kernel.init.code: " + mapBasedInstallKernel.get("install.kernel.init.code"));
        this.debug("install.kernel.init.error.message: " + mapBasedInstallKernel.get("install.kernel.init.error.message"));
        File usrDir = new File(installDirectory, "usr/tmp");
        mapBasedInstallKernel.put("target.user.directory", usrDir);
        return mapBasedInstallKernel;
    }

    public String getOverrideBundleDescriptor(String groupId, String artifactId) throws PluginExecutionException {
        String symbolicName;
        File overrideJar = this.downloadOverrideJar(groupId, artifactId);
        if (overrideJar != null && overrideJar.exists() && (symbolicName = InstallFeatureUtil.extractSymbolicName(overrideJar)) != null) {
            return overrideJar.getAbsolutePath() + ";" + symbolicName;
        }
        return null;
    }

    private File downloadOverrideJar(String groupId, String artifactId) {
        try {
            return this.downloadArtifact(groupId, artifactId, "jar", String.format("[%s)", this.openLibertyVersion + ", " + InstallFeatureUtil.getNextProductVersion(this.openLibertyVersion)));
        }
        catch (PluginExecutionException e) {
            this.debug("Could not find override bundle " + groupId + ":" + artifactId + " for the current Open Liberty version " + this.openLibertyVersion, e);
            return null;
        }
    }

    public static String getNextProductVersion(String version) throws PluginExecutionException {
        int nextQuarterSpecifier;
        String result = null;
        int versionSplittingIndex = version.lastIndexOf(".") + 1;
        if (versionSplittingIndex == 0) {
            throw new PluginExecutionException("Product version " + version + " is not in the expected format. It must have period separated version segments.");
        }
        String quarterVersion = version.substring(versionSplittingIndex);
        try {
            nextQuarterSpecifier = Integer.parseInt(quarterVersion) + 1;
        }
        catch (NumberFormatException e) {
            throw new PluginExecutionException("Product version " + version + " is not in the expected format. Its last segment is expected to be an integer.", e);
        }
        result = version.substring(0, versionSplittingIndex) + nextQuarterSpecifier;
        return result;
    }

    public static String extractSymbolicName(File jar) throws PluginExecutionException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            String string = jarFile.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
            return string;
        }
        catch (IOException e) {
            throw new PluginExecutionException("Could not load the jar " + jar.getAbsolutePath(), e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File getMapBasedInstallKernelJar(File dir) {
        File[] installMapJars = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(InstallFeatureUtil.INSTALL_MAP_PREFIX) && name.endsWith(InstallFeatureUtil.INSTALL_MAP_SUFFIX);
            }
        });
        File result = null;
        if (installMapJars != null) {
            for (File jar : installMapJars) {
                if (!InstallFeatureUtil.isReplacementJar(result, jar)) continue;
                result = jar;
            }
        }
        return result;
    }

    private static boolean isReplacementJar(File file1, File file2) {
        String version2;
        if (file1 == null) {
            return true;
        }
        if (file2 == null) {
            return false;
        }
        String version1 = InstallFeatureUtil.extractVersion(file1.getName());
        return InstallFeatureUtil.compare(version1, version2 = InstallFeatureUtil.extractVersion(file2.getName())) < 0;
    }

    private static String extractVersion(String fileName) {
        int endIndex;
        int startIndex = INSTALL_MAP_PREFIX.length() + 1;
        if (startIndex < (endIndex = fileName.lastIndexOf(INSTALL_MAP_SUFFIX))) {
            return fileName.substring(startIndex, endIndex);
        }
        return null;
    }

    private static int compare(String version1, String version2) {
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 == null && version2 != null) {
            return -1;
        }
        if (version1 != null && version2 == null) {
            return 1;
        }
        String[] components1 = version1.split("\\.");
        String[] components2 = version2.split("\\.");
        for (int i = 0; i < components1.length && i < components2.length; ++i) {
            int comparison;
            try {
                comparison = new Integer(components1[i]).compareTo(new Integer(components2[i]));
            }
            catch (NumberFormatException e) {
                comparison = components1[i].compareTo(components2[i]);
            }
            if (comparison == 0) continue;
            return comparison;
        }
        return components1.length - components2.length;
    }

    private void productInfoValidate() throws PluginExecutionException {
        String output = InstallFeatureUtil.productInfo(this.installDirectory, "validate");
        if (output == null) {
            throw new PluginExecutionException("Could not perform product validation. The productInfo command returned with no output");
        }
        if (output.contains("[ERROR]")) {
            throw new PluginExecutionException(output);
        }
        this.info("Product validation completed successfully.");
    }

    public static String productInfo(File installDirectory, String action) throws PluginExecutionException {
        Process pr = null;
        InputStream is = null;
        Scanner s = null;
        Thread worker = null;
        try {
            String command = OSUtil.isWindows() ? installDirectory + "\\bin\\productInfo.bat " + action : installDirectory + "/bin/productInfo " + action;
            pr = Runtime.getRuntime().exec(command);
            worker = new Worker(pr);
            worker.start();
            worker.join(300000L);
            if (((Worker)worker).exit == null) {
                throw new PluginExecutionException("productInfo command timed out");
            }
            int exitValue = pr.exitValue();
            if (exitValue != 0) {
                throw new PluginExecutionException("productInfo exited with return code " + exitValue);
            }
            is = pr.getInputStream();
            s = new Scanner(is);
            s.useDelimiter("\\A");
            if (s.hasNext()) {
                String string = s.next();
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException ex) {
            throw new PluginExecutionException("productInfo error: " + ex);
        }
        catch (InterruptedException ex) {
            worker.interrupt();
            Thread.currentThread().interrupt();
            throw new PluginExecutionException("productInfo error: " + ex);
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (pr != null) {
                pr.destroy();
            }
        }
    }

    private static boolean isURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    private static class Worker
    extends Thread {
        private final Process process;
        private Integer exit;

        private Worker(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                this.exit = this.process.waitFor();
            }
            catch (InterruptedException ignore) {
                return;
            }
        }
    }

    private class ProductProperties {
        private String id;
        private String version;

        public ProductProperties(String id, String version) {
            this.id = id;
            this.version = version;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

