/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.common.plugins.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class SpringBootUtil {
    public static final String BOOT_VERSION_ATTRIBUTE = "Spring-Boot-Version";
    public static final String BOOT_START_CLASS_ATTRIBUTE = "Start-Class";
    public static final String BOOT_JAR_EXPRESSION = "BOOT-INF/lib/spring-boot-\\d[\\.]\\d[\\.]\\d.RELEASE.jar";
    public static final String BOOT_WAR_EXPRESSION = "WEB-INF/lib/spring-boot-\\d[\\.]\\d[\\.]\\d.RELEASE.jar";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSpringBootUberJar(File artifact) {
        if (artifact == null) return false;
        if (!artifact.exists()) return false;
        if (!artifact.isFile()) {
            return false;
        }
        try (JarFile jarFile = new JarFile(artifact);){
            JarEntry entry;
            String entryName;
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) return false;
            Attributes attributes = manifest.getMainAttributes();
            if (attributes.getValue(BOOT_VERSION_ATTRIBUTE) != null && attributes.getValue(BOOT_START_CLASS_ATTRIBUTE) != null) {
                boolean bl = true;
                return bl;
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            do {
                if (!entries.hasMoreElements()) return false;
            } while ((entryName = (entry = entries.nextElement()).getName()).startsWith("org") || !entryName.matches(BOOT_JAR_EXPRESSION) && !entryName.matches(BOOT_WAR_EXPRESSION));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

