/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.wasdev.wlp.maven.plugins.XmlDocument;
import org.w3c.dom.Element;

public class ApplicationXmlDocument
extends XmlDocument {
    public static final String APP_XML_FILENAME = "install_apps_configuration_1491924271.xml";

    public ApplicationXmlDocument() {
        try {
            this.createDocument("server");
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void createApplicationElement(String appFileName, String artifactId) {
        File app = new File(appFileName);
        if ("war".equalsIgnoreCase(appFileName.substring(appFileName.lastIndexOf(".") + 1))) {
            this.createElement("webApplication", app, artifactId);
        } else if ("ear".equalsIgnoreCase(appFileName.substring(appFileName.lastIndexOf(".") + 1))) {
            this.createElement("enterpriseApplication", app, artifactId);
        } else {
            this.createElement("application", app, artifactId);
        }
    }

    public void createElement(String element, File appFile, String artifactId) {
        Element child = this.doc.createElement(element);
        child.setAttribute("id", artifactId);
        child.setAttribute("location", appFile.getName());
        child.setAttribute("name", artifactId);
        this.doc.getDocumentElement().appendChild(child);
    }

    public void writeApplicationXmlDocument(File serverDirectory) throws IOException, TransformerException {
        File applicationXml = ApplicationXmlDocument.getApplicationXmlFile(serverDirectory);
        if (!applicationXml.getParentFile().exists()) {
            applicationXml.getParentFile().mkdirs();
        }
        this.writeXMLDocument(applicationXml);
    }

    public static File getApplicationXmlFile(File serverDirectory) {
        File f = new File(serverDirectory, "configDropins/defaults/install_apps_configuration_1491924271.xml");
        return f;
    }

    public boolean hasChildElements() {
        return this.doc.getDocumentElement().getChildNodes().getLength() > 0;
    }
}

