/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.wasdev.wlp.ant.install.InstallLibertyTask;
import net.wasdev.wlp.maven.plugins.AbstractLibertySupport;
import net.wasdev.wlp.maven.plugins.Install;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class BasicSupport
extends AbstractLibertySupport {
    protected static final String START_APP_MESSAGE_REGEXP = "CWWKZ0001I.*";
    protected static final ResourceBundle messages = ResourceBundle.getBundle("net.wasdev.wlp.maven.plugins.MvnMessages");
    @Parameter(property="skip", defaultValue="false")
    protected boolean skip = false;
    @Parameter(property="refresh", defaultValue="false")
    protected boolean refresh = false;
    @Parameter(property="isInstall", defaultValue="true")
    protected boolean isInstall = true;
    @Parameter(property="assemblyInstallDirectory", defaultValue="${project.build.directory}/liberty")
    protected File assemblyInstallDirectory;
    @Parameter(property="installDirectory")
    protected File installDirectory;
    @Parameter(property="serverHome")
    private File serverHome;
    @Parameter(property="serverName", defaultValue="defaultServer")
    protected String serverName = null;
    @Parameter(property="userDirectory")
    protected File userDirectory = null;
    @Parameter(property="outputDirectory")
    protected File outputDirectory = null;
    protected File serverDirectory;
    protected InstallType installType;
    @Parameter(property="assemblyArchive")
    protected File assemblyArchive;
    @Parameter
    protected ArtifactItem assemblyArtifact;
    @Parameter
    protected Install install;
    @Parameter
    protected ArtifactItem licenseArtifact;

    @Override
    protected void init() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        super.init();
        if (this.installDirectory == null) {
            this.installDirectory = this.serverHome;
        }
        try {
            if (this.installDirectory != null) {
                this.installDirectory = this.installDirectory.getCanonicalFile();
                File file = new File(this.installDirectory, "lib/ws-launch.jar");
                if (!file.exists()) {
                    throw new MojoExecutionException(MessageFormat.format(messages.getString("error.install.dir.validate"), ""));
                }
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "pre-installed assembly", this.installDirectory));
                this.installType = InstallType.ALREADY_EXISTS;
            } else if (this.assemblyArchive != null) {
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "non-artifact based assembly archive", this.assemblyArchive));
                this.assemblyArchive = this.assemblyArchive.getCanonicalFile();
                this.installType = InstallType.FROM_FILE;
                this.installDirectory = this.checkServerHome(this.assemblyArchive);
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "installDirectory", this.installDirectory));
            } else if (this.assemblyArtifact != null) {
                Artifact artifact = this.getArtifact(this.assemblyArtifact);
                this.assemblyArchive = artifact.getFile();
                if (this.assemblyArchive == null) {
                    throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.assembly.validate"), "artifact based assembly archive", ""));
                }
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "artifact based assembly archive", this.assemblyArtifact));
                this.assemblyArchive = this.assemblyArchive.getCanonicalFile();
                this.installType = InstallType.FROM_FILE;
                this.installDirectory = this.checkServerHome(this.assemblyArchive);
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "installDirectory", this.installDirectory));
            } else {
                if (this.install == null) {
                    this.install = new Install();
                }
                this.installType = InstallType.FROM_ARCHIVE;
                this.installDirectory = new File(this.assemblyInstallDirectory, "wlp");
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "installDirectory", this.installDirectory));
            }
            if (this.serverName == null) {
                this.serverName = "defaultServer";
            }
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "serverName", this.serverName));
            if (this.userDirectory == null) {
                this.userDirectory = new File(this.installDirectory, "usr");
            }
            File serversDirectory = new File(this.userDirectory, "servers");
            this.serverDirectory = new File(serversDirectory, this.serverName);
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "serverDirectory", this.serverDirectory));
            if (this.outputDirectory == null) {
                this.outputDirectory = serversDirectory;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected void checkServerHomeExists() throws MojoExecutionException {
        if (!this.installDirectory.exists()) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.home.noexist"), this.installDirectory));
        }
    }

    protected void checkServerDirectoryExists() throws MojoExecutionException {
        if (!this.serverDirectory.exists()) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.noexist"), this.serverName));
        }
    }

    private File checkServerHome(File archive) throws IOException, MojoExecutionException {
        this.log.debug((CharSequence)MessageFormat.format(messages.getString("debug.discover.server.home"), ""));
        File dir = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> n = zipFile.entries();
            while (n.hasMoreElements()) {
                ZipEntry entry = n.nextElement();
                if (!entry.getName().endsWith("lib/ws-launch.jar")) continue;
                File file = new File(this.assemblyInstallDirectory, entry.getName());
                dir = file.getParentFile().getParentFile();
                break;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.discover.server.home.fail"), archive), (Exception)e);
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
        }
        if (dir == null) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.archive.not.contain.server"), archive));
        }
        return dir.getCanonicalFile();
    }

    protected void installServerAssembly() throws Exception {
        if (this.installType == InstallType.ALREADY_EXISTS) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
        } else {
            if (this.installType == InstallType.FROM_ARCHIVE) {
                this.installFromArchive();
            } else {
                this.installFromFile();
            }
            this.installLicense();
        }
    }

    protected void installFromFile() throws Exception {
        File installMarker = new File(this.installDirectory, ".installed");
        if (!this.refresh) {
            if (!installMarker.exists()) {
                this.refresh = true;
            } else if (this.assemblyArchive.lastModified() > installMarker.lastModified()) {
                this.log.debug((CharSequence)MessageFormat.format(messages.getString("debug.detect.assembly.archive"), ""));
                this.refresh = true;
            }
        } else {
            this.log.debug((CharSequence)MessageFormat.format(messages.getString("debug.request.refresh"), ""));
        }
        if (this.refresh && this.installDirectory.exists()) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.uninstalling.server.home"), this.installDirectory));
            FileUtils.forceDelete((File)this.installDirectory);
        }
        if (!installMarker.exists()) {
            this.log.info((CharSequence)"Installing assembly...");
            FileUtils.forceMkdir((File)this.installDirectory);
            Expand unzip = (Expand)this.ant.createTask("unzip");
            unzip.setSrc(this.assemblyArchive);
            unzip.setDest(this.assemblyInstallDirectory.getCanonicalFile());
            unzip.execute();
            Chmod chmod = (Chmod)this.ant.createTask("chmod");
            chmod.setPerm("ugo+rx");
            chmod.setDir(this.installDirectory);
            chmod.setIncludes("bin/*");
            chmod.setExcludes("bin/*.bat");
            chmod.execute();
            installMarker.delete();
            installMarker.createNewFile();
        } else {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.reuse.installed.assembly"), ""));
        }
    }

    protected void installFromArchive() throws Exception {
        InstallLibertyTask installTask = (InstallLibertyTask)this.ant.createTask("antlib:net/wasdev/wlp/ant:install-liberty");
        if (installTask == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "install-liberty"));
        }
        installTask.setBaseDir(this.assemblyInstallDirectory.getAbsolutePath());
        installTask.setLicenseCode(this.install.getLicenseCode());
        installTask.setVersion(this.install.getVersion());
        installTask.setRuntimeUrl(this.install.getRuntimeUrl());
        installTask.setVerbose(this.install.isVerbose());
        installTask.setMaxDownloadTime(this.install.getMaxDownloadTime());
        installTask.setType(this.install.getType());
        installTask.setOffline(this.settings.isOffline());
        String cacheDir = this.install.getCacheDirectory();
        if (cacheDir == null) {
            File dir = new File(this.artifactRepository.getBasedir(), "wlp-cache");
            installTask.setCacheDir(dir.getAbsolutePath());
        } else {
            installTask.setCacheDir(cacheDir);
        }
        String serverId = this.install.getServerId();
        if (serverId != null) {
            Server server = this.settings.getServer(serverId);
            if (server == null) {
                throw new MojoExecutionException("Server id not found: " + serverId);
            }
            installTask.setUsername(server.getUsername());
            installTask.setPassword(server.getPassword());
        } else {
            installTask.setUsername(this.install.getUsername());
            installTask.setPassword(this.install.getPassword());
        }
        installTask.execute();
    }

    protected String stripVersionFromName(String name, String version) {
        int versionBeginIndex = name.lastIndexOf("-" + version);
        if (versionBeginIndex != -1) {
            return name.substring(0, versionBeginIndex) + name.substring(versionBeginIndex + version.length() + 1);
        }
        return name;
    }

    protected void installLicense() throws MojoExecutionException, IOException {
        Artifact license;
        if (this.licenseArtifact != null && !this.hasSameLicense(license = this.getArtifact(this.licenseArtifact))) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.license"), this.licenseArtifact.getGroupId() + ":" + this.licenseArtifact.getArtifactId() + ":" + this.licenseArtifact.getVersion()));
            Java installLicenseTask = (Java)this.ant.createTask("java");
            installLicenseTask.setJar(license.getFile());
            Commandline.Argument args = installLicenseTask.createArg();
            args.setLine("--acceptLicense " + this.assemblyInstallDirectory.getCanonicalPath());
            installLicenseTask.setTimeout(Long.valueOf(30000L));
            installLicenseTask.setFork(true);
            int rc = installLicenseTask.executeJava();
            if (rc != 0) {
                throw new MojoExecutionException(MessageFormat.format(messages.getString("error.install.license"), this.licenseArtifact.getGroupId() + ":" + this.licenseArtifact.getArtifactId() + ":" + this.licenseArtifact.getVersion(), rc));
            }
        }
    }

    protected void deleteApplication(File parent, File artifactFile) throws IOException {
        this.deleteApplication(parent, artifactFile.getName());
        if (artifactFile.getName().endsWith(".xml")) {
            this.deleteApplication(parent, artifactFile.getName().substring(0, artifactFile.getName().length() - 4));
        } else {
            this.deleteApplication(parent, artifactFile.getName() + ".xml");
        }
    }

    protected void deleteApplication(File parent, String filename) throws IOException {
        File application = new File(parent, filename);
        if (application.isDirectory()) {
            FileUtils.deleteDirectory((File)application);
        } else {
            application.delete();
        }
    }

    private boolean hasSameLicense(Artifact license) throws MojoExecutionException, IOException {
        boolean sameLicense = false;
        if (license != null) {
            InputStream licenseInfo = this.getZipEntry(license.getFile(), "wlp/lafiles/LI_en");
            if (licenseInfo == null) {
                this.log.warn((CharSequence)MessageFormat.format(messages.getString("warn.install.license"), license.getId()));
                return sameLicense;
            }
            File lic = new File(this.assemblyInstallDirectory, "wlp/lafiles/LI_en");
            if (lic.exists()) {
                FileInputStream installedLicenseInfo = new FileInputStream(lic);
                sameLicense = IOUtil.contentEquals((InputStream)licenseInfo, (InputStream)installedLicenseInfo);
                licenseInfo.close();
                installedLicenseInfo.close();
            }
        }
        return sameLicense;
    }

    private InputStream getZipEntry(File zip, String entry) throws IOException {
        ZipEntry e;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zip));
        while ((e = zipInputStream.getNextEntry()) != null) {
            if (!e.getName().equals(entry)) continue;
            return zipInputStream;
        }
        return null;
    }

    protected static enum InstallType {
        FROM_FILE,
        ALREADY_EXISTS,
        FROM_ARCHIVE;

    }
}

