/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.wasdev.wlp.maven.plugins.ApplicationXmlDocument;
import net.wasdev.wlp.maven.plugins.applications.LooseConfigData;
import net.wasdev.wlp.maven.plugins.server.PluginConfigSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.taskdefs.Copy;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InstallAppMojoSupport
extends PluginConfigSupport {
    protected ApplicationXmlDocument applicationXml = new ApplicationXmlDocument();

    protected void installApp(Artifact artifact) throws Exception {
        if (artifact.getFile() == null || artifact.getFile().isDirectory()) {
            String warName = this.getWarFileName(this.project);
            File f = new File(this.project.getBuild().getDirectory() + "/" + warName);
            artifact.setFile(f);
        }
        if (!artifact.getFile().exists()) {
            throw new MojoExecutionException(messages.getString("error.install.app.missing"));
        }
        File destDir = new File(this.serverDirectory, this.getAppsDirectory());
        this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), artifact.getFile().getCanonicalPath()));
        Copy copyFile = (Copy)this.ant.createTask("copy");
        copyFile.setFile(artifact.getFile());
        String fileName = artifact.getFile().getName();
        if (this.stripVersion) {
            fileName = this.stripVersionFromName(fileName, artifact.getVersion());
            copyFile.setTofile(new File(destDir, fileName));
        } else {
            copyFile.setTodir(destDir);
        }
        this.validateAppConfig(fileName, artifact.getArtifactId());
        this.deleteApplication(new File(this.serverDirectory, "apps"), artifact.getFile());
        this.deleteApplication(new File(this.serverDirectory, "dropins"), artifact.getFile());
        this.deleteApplication(new File(this.serverDirectory, "apps/expanded"), artifact.getFile());
        copyFile.execute();
    }

    protected void installLooseConfigApp() throws Exception {
        String looseConfigFileName = this.getLooseConfigFileName(this.project);
        String application = looseConfigFileName.substring(0, looseConfigFileName.length() - 4);
        this.validateAppConfig(application, this.project.getArtifactId());
        File destDir = new File(this.serverDirectory, this.getAppsDirectory());
        File looseConfigFile = new File(destDir, looseConfigFileName);
        LooseConfigData config = new LooseConfigData();
        this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), looseConfigFileName));
        File dir = this.getWarSourceDirectory();
        if (dir.exists()) {
            config.addDir(dir.getCanonicalPath(), "/");
        }
        if ((dir = new File(this.project.getBuild().getOutputDirectory())).exists()) {
            config.addDir(dir.getCanonicalPath(), "/WEB-INF/classes");
        } else if (this.containsJavaSource(this.project)) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.project.not.compile"), this.project.getId()));
        }
        List<Artifact> libraries = this.getDependentLibraries();
        if (!libraries.isEmpty()) {
            List<String> eclipseModules = this.getEclipseDependentMods();
            if (eclipseModules.isEmpty()) {
                this.addLibraries(libraries, config);
            } else {
                for (Artifact library : libraries) {
                    if (library.getFile() == null || !eclipseModules.contains(this.getFileName(library.getFile()))) {
                        this.addLibraryFromM2(library, config);
                        continue;
                    }
                    File classDir = new File(this.project.getBasedir() + "/../" + library.getArtifactId() + "/target/classes");
                    this.log.debug((CharSequence)("sibling module target class directory pathname: " + classDir.getCanonicalPath()));
                    if (classDir.exists()) {
                        config.addArchive(classDir.getCanonicalPath(), "/WEB-INF/lib/" + this.getFileName(library.getFile()));
                        continue;
                    }
                    this.addLibraryFromM2(library, config);
                }
            }
        }
        this.deleteApplication(new File(this.serverDirectory, "apps"), looseConfigFile);
        this.deleteApplication(new File(this.serverDirectory, "dropins"), looseConfigFile);
        config.toXmlFile(looseConfigFile);
    }

    private boolean containsJavaSource(MavenProject proj) {
        List srcDirs = proj.getCompileSourceRoots();
        for (String dir : srcDirs) {
            File javaSourceDir = new File(dir);
            if (!javaSourceDir.exists() || !javaSourceDir.isDirectory() || !this.containsJavaSource(javaSourceDir)) continue;
            return true;
        }
        return false;
    }

    private boolean containsJavaSource(File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile() && file.getName().toLowerCase().endsWith(".java")) {
                return true;
            }
            if (!file.isDirectory()) continue;
            return this.containsJavaSource(file);
        }
        return false;
    }

    private String getLooseConfigFileName(MavenProject project) {
        return this.getWarFileName(project) + ".xml";
    }

    private String getWarFileName(MavenProject project) {
        String name = project.getBuild().getFinalName() + "." + project.getPackaging();
        if (project.getPackaging().equals("liberty-assembly")) {
            name = project.getBuild().getFinalName() + ".war";
        }
        if (this.stripVersion) {
            name = this.stripVersionFromName(name, project.getVersion());
        }
        return name;
    }

    private void addLibraries(List<Artifact> libraries, LooseConfigData config) throws Exception {
        for (Artifact library : libraries) {
            if (library.getFile() != null) {
                File f = new File(library.getFile().getParentFile(), "classes");
                if (f.exists()) {
                    config.addArchive(f.getCanonicalPath(), "/WEB-INF/lib/" + this.getFileName(library.getFile()));
                    continue;
                }
                this.addLibraryFromM2(library, config);
                continue;
            }
            this.addLibraryFromM2(library, config);
        }
    }

    private String getFileName(File f) throws IOException {
        String name = f.getCanonicalPath().substring(f.getCanonicalPath().lastIndexOf(File.separator) + 1);
        return name;
    }

    private void addLibraryFromM2(Artifact library, LooseConfigData config) throws Exception {
        if (library.getFile() == null) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.app.dependency.not.found"), library.getId()));
        }
        config.addFile(library.getFile().getCanonicalPath(), "/WEB-INF/lib/" + library.getFile().getName());
    }

    private List<String> getEclipseDependentMods() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        ArrayList<String> modules = new ArrayList<String>();
        File f = new File(this.project.getBasedir(), ".settings/org.eclipse.wst.common.component");
        if (f.exists()) {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setIgnoringComments(true);
            builderFactory.setCoalescing(true);
            builderFactory.setIgnoringElementContentWhitespace(true);
            builderFactory.setValidating(false);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document doc = builder.parse(f);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "/project-modules/wb-module/dependent-module";
            NodeList nodes = (NodeList)xPath.compile(expression).evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                modules.add(nodes.item(i).getAttributes().getNamedItem("archiveName").getNodeValue());
            }
        }
        return modules;
    }

    private List<Artifact> getDependentLibraries() {
        ArrayList<Artifact> libraries = new ArrayList<Artifact>();
        List artifacts = this.project.getCompileArtifacts();
        for (Artifact artifact : artifacts) {
            if (!artifact.getScope().equals("compile") || artifact.isOptional()) continue;
            libraries.add(artifact);
        }
        return libraries;
    }

    private void validateAppConfig(String fileName, String artifactId) throws Exception {
        String appsDir = this.getAppsDirectory();
        if (appsDir.equalsIgnoreCase("apps") && !this.isAppConfiguredInSourceServerXml(fileName)) {
            this.applicationXml.createApplicationElement(fileName, artifactId);
        } else if (appsDir.equalsIgnoreCase("dropins") && this.isAppConfiguredInSourceServerXml(fileName)) {
            throw new MojoExecutionException(messages.getString("error.install.app.dropins.directory"));
        }
    }
}

