/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import java.text.MessageFormat;
import java.util.Set;
import net.wasdev.wlp.maven.plugins.ApplicationXmlDocument;
import net.wasdev.wlp.maven.plugins.applications.InstallAppMojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;

@Mojo(name="install-apps", requiresDependencyResolution=ResolutionScope.COMPILE)
public class InstallAppsMojo
extends InstallAppMojoSupport {
    protected void doExecute() throws Exception {
        if (this.skip) {
            return;
        }
        this.checkServerHomeExists();
        this.checkServerDirectoryExists();
        this.copyConfigFiles();
        this.exportParametersToXml();
        boolean installDependencies = false;
        boolean installProject = false;
        switch (this.installAppPackages) {
            case "all": {
                installDependencies = true;
                installProject = true;
                break;
            }
            case "dependencies": {
                installDependencies = true;
                break;
            }
            case "project": {
                installProject = true;
                break;
            }
            default: {
                return;
            }
        }
        if (installDependencies) {
            this.installDependencies();
        }
        if (installProject) {
            this.installProject();
        }
        if (this.applicationXml.hasChildElements()) {
            this.log.warn((CharSequence)messages.getString("warn.install.app.add.configuration"));
            this.applicationXml.writeApplicationXmlDocument(this.serverDirectory);
        } else if (ApplicationXmlDocument.getApplicationXmlFile(this.serverDirectory).exists()) {
            ApplicationXmlDocument.getApplicationXmlFile(this.serverDirectory).delete();
        }
    }

    private void installDependencies() throws Exception {
        Set artifacts = this.project.getDependencyArtifacts();
        for (Artifact dep : artifacts) {
            if (!this.isSupportedType(dep.getType()) || this.assemblyArtifact != null && this.matches(dep, this.assemblyArtifact) || !dep.getScope().equals("compile")) continue;
            this.installApp(dep);
        }
    }

    private void installProject() throws Exception {
        if (this.isSupportedType(this.project.getPackaging())) {
            if (this.looseApplication) {
                switch (this.project.getPackaging()) {
                    case "war": {
                        this.installLooseConfigApp();
                        break;
                    }
                    case "liberty-assembly": {
                        File dir = this.getWarSourceDirectory();
                        if (dir.exists()) {
                            this.installLooseConfigApp();
                            break;
                        }
                        this.log.debug((CharSequence)"liberty-assembly project does not have source code for web project.");
                        break;
                    }
                    default: {
                        this.log.info((CharSequence)MessageFormat.format(messages.getString("info.loose.application.not.supported"), this.project.getPackaging()));
                        this.installApp(this.project.getArtifact());
                        break;
                    }
                }
            } else {
                this.installApp(this.project.getArtifact());
            }
        } else {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.application.not.supported"), this.project.getId()));
        }
    }

    private boolean matches(Artifact dep, ArtifactItem assemblyArtifact) {
        return dep.getGroupId().equals(assemblyArtifact.getGroupId()) && dep.getArtifactId().equals(assemblyArtifact.getArtifactId()) && dep.getType().equals(assemblyArtifact.getType());
    }

    private boolean isSupportedType(String type) {
        switch (type) {
            case "ear": 
            case "war": 
            case "eba": 
            case "esa": 
            case "liberty-assembly": {
                return true;
            }
        }
        return false;
    }
}

