/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.server;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import net.wasdev.wlp.maven.plugins.ApplicationXmlDocument;
import net.wasdev.wlp.maven.plugins.PluginConfigXmlDocument;
import net.wasdev.wlp.maven.plugins.ServerConfigDocument;
import net.wasdev.wlp.maven.plugins.server.StartDebugMojoSupport;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.plexus.build.incremental.BuildContext;

public class PluginConfigSupport
extends StartDebugMojoSupport {
    @Parameter(property="appsDirectory")
    protected String appsDirectory;
    @Parameter(property="stripVersion", defaultValue="false")
    protected boolean stripVersion;
    @Parameter(property="looseApplication", defaultValue="false")
    protected boolean looseApplication;
    @Parameter(property="installAppPackages", defaultValue="dependencies")
    protected String installAppPackages;
    @Component
    private BuildContext buildContext;
    protected final String PLUGIN_CONFIG_XML = "liberty-plugin-config.xml";

    @Override
    protected void installServerAssembly() throws Exception {
        File f = this.exportParametersToXml();
        super.installServerAssembly();
        this.buildContext.refresh(f);
        this.buildContext.refresh(this.installDirectory);
    }

    protected File exportParametersToXml() throws Exception {
        PluginConfigXmlDocument configDocument = PluginConfigXmlDocument.newInstance("liberty-plugin-config");
        List profiles = this.project.getActiveProfiles();
        configDocument.createActiveBuildProfilesElement("activeBuildProfiles", profiles);
        configDocument.createElement("installDirectory", this.installDirectory);
        configDocument.createElement("serverDirectory", this.serverDirectory);
        configDocument.createElement("userDirectory", this.userDirectory);
        configDocument.createElement("serverOutputDirectory", new File(this.outputDirectory, this.serverName));
        configDocument.createElement("serverName", this.serverName);
        configDocument.createElement("configDirectory", this.configDirectory);
        if (this.getFileFromConfigDirectory("server.xml", this.configFile) != null) {
            configDocument.createElement("configFile", this.getFileFromConfigDirectory("server.xml", this.configFile));
        }
        if (this.bootstrapProperties != null && this.getFileFromConfigDirectory("bootstrap.properties") == null) {
            configDocument.createElement("bootstrapProperties", this.bootstrapProperties);
        } else {
            configDocument.createElement("bootstrapPropertiesFile", this.getFileFromConfigDirectory("bootstrap.properties", this.bootstrapPropertiesFile));
        }
        if (this.jvmOptions != null && this.getFileFromConfigDirectory("jvm.options") == null) {
            configDocument.createElement("jvmOptions", this.jvmOptions);
        } else {
            configDocument.createElement("jvmOptionsFile", this.getFileFromConfigDirectory("jvm.options", this.jvmOptionsFile));
        }
        if (this.getFileFromConfigDirectory("server.env", this.serverEnv) != null) {
            configDocument.createElement("serverEnv", this.getFileFromConfigDirectory("server.env", this.serverEnv));
        }
        configDocument.createElement("appsDirectory", this.getAppsDirectory());
        configDocument.createElement("looseApplication", this.looseApplication);
        configDocument.createElement("stripVersion", this.stripVersion);
        configDocument.createElement("installAppPackages", this.installAppPackages);
        configDocument.createElement("applicationFilename", this.getApplicationFilename());
        configDocument.createElement("assemblyArtifact", this.assemblyArtifact);
        configDocument.createElement("assemblyArchive", this.assemblyArchive);
        configDocument.createElement("assemblyInstallDirectory", this.assemblyInstallDirectory);
        configDocument.createElement("refresh", this.refresh);
        configDocument.createElement("install", this.install);
        configDocument.createElement("installAppsConfigDropins", ApplicationXmlDocument.getApplicationXmlFile(this.serverDirectory));
        File f = new File(this.project.getBuild().getDirectory() + File.separator + "liberty-plugin-config.xml");
        configDocument.writeXMLDocument(f);
        return f;
    }

    protected File getFileFromConfigDirectory(String file, File def) {
        File f = new File(this.configDirectory, file);
        if (this.configDirectory != null && f.exists()) {
            return f;
        }
        if (def != null && def.exists()) {
            return def;
        }
        return null;
    }

    protected File getFileFromConfigDirectory(String file) {
        return this.getFileFromConfigDirectory(file, null);
    }

    protected String getApplicationFilename() {
        int versionBeginIndex;
        if (this.installAppPackages.equalsIgnoreCase("dependencies")) {
            return null;
        }
        String name = this.project.getBuild().getFinalName();
        if (this.stripVersion && (versionBeginIndex = this.project.getBuild().getFinalName().lastIndexOf("-" + this.project.getVersion())) != -1) {
            name = this.project.getBuild().getFinalName().substring(0, versionBeginIndex);
        }
        switch (this.project.getPackaging()) {
            case "ear": 
            case "war": 
            case "eba": 
            case "esa": {
                name = name + "." + this.project.getPackaging();
                if (!this.looseApplication) break;
                name = name + ".xml";
                break;
            }
            case "liberty-assembly": {
                File dir = this.getWarSourceDirectory();
                if (!dir.exists()) break;
                name = name + ".war";
                if (!this.looseApplication) break;
                name = name + ".xml";
                break;
            }
            default: {
                this.log.debug((CharSequence)("The project artifact cannot be installed to a Liberty server because " + this.project.getPackaging() + " is not a supported packaging type."));
                name = null;
            }
        }
        return name;
    }

    @Override
    protected String stripVersionFromName(String name, String version) {
        int versionBeginIndex = name.lastIndexOf("-" + version);
        if (versionBeginIndex != -1) {
            return name.substring(0, versionBeginIndex) + name.substring(versionBeginIndex + version.length() + 1);
        }
        return name;
    }

    protected boolean isAppConfiguredInSourceServerXml(String fileName) {
        boolean bConfigured = false;
        File serverXML = this.getFileFromConfigDirectory("server.xml", this.configFile);
        if (serverXML != null && serverXML.exists()) {
            try {
                ServerConfigDocument scd = ServerConfigDocument.getInstance(serverXML, this.configDirectory, this.bootstrapPropertiesFile, this.bootstrapProperties, this.serverEnv);
                if (scd != null && scd.getLocations().contains(fileName)) {
                    this.log.debug((CharSequence)("Application configuration is found in server.xml : " + fileName));
                    bConfigured = true;
                }
            }
            catch (Exception e) {
                this.log.warn((CharSequence)e.getLocalizedMessage());
                this.log.debug((Throwable)e);
            }
        }
        return bConfigured;
    }

    protected boolean isAnyAppConfiguredInSourceServerXml() {
        boolean bConfigured = false;
        File serverXML = this.getFileFromConfigDirectory("server.xml", this.configFile);
        if (serverXML != null && serverXML.exists()) {
            try {
                ServerConfigDocument scd = ServerConfigDocument.getInstance(serverXML, this.configDirectory, this.bootstrapPropertiesFile, this.bootstrapProperties, this.serverEnv);
                if (scd != null && scd.getLocations().size() > 0) {
                    this.log.debug((CharSequence)"Application configuration is found in server.xml.");
                    bConfigured = true;
                }
            }
            catch (Exception e) {
                this.log.warn((CharSequence)e.getLocalizedMessage());
                this.log.debug((Throwable)e);
            }
        }
        return bConfigured;
    }

    protected String getAppsDirectory() {
        if (this.appsDirectory != null && !this.appsDirectory.isEmpty()) {
            if ("dropins".equals(this.appsDirectory) || "apps".equals(this.appsDirectory)) {
                return this.appsDirectory;
            }
            this.log.warn((CharSequence)MessageFormat.format(messages.getString("warn.invalid.app.directory"), this.appsDirectory));
        }
        this.appsDirectory = "dropins";
        File srcServerXML = this.getFileFromConfigDirectory("server.xml", this.configFile);
        if (srcServerXML != null && srcServerXML.exists() && this.isAnyAppConfiguredInSourceServerXml()) {
            this.appsDirectory = "apps";
        }
        this.log.info((CharSequence)MessageFormat.format(messages.getString("info.default.app.directory"), this.appsDirectory));
        return this.appsDirectory;
    }

    protected File getWarSourceDirectory() {
        String dir = this.getPluginConfiguration("org.apache.maven.plugins", "maven-war-plugin", "warSourceDirectory");
        if (dir != null) {
            return new File(dir);
        }
        return new File(this.project.getBasedir() + "/src/main/webapp");
    }

    private String getPluginConfiguration(String pluginGroupId, String pluginArtifactId, String key) {
        Xpp3Dom val;
        Xpp3Dom dom = this.project.getGoalConfiguration(pluginGroupId, pluginArtifactId, null, null);
        if (dom != null && (val = dom.getChild(key)) != null) {
            return val.getValue();
        }
        return null;
    }
}

