/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ServerConfigDocument {
    private static ServerConfigDocument instance;
    private static DocumentBuilder docBuilder;
    private static File configDirectory;
    private static File serverFile;
    private static Set<String> locations;
    private static Properties props;

    public Set<String> getLocations() {
        return locations;
    }

    public static Properties getProperties() {
        return props;
    }

    private static File getServerFile() {
        return serverFile;
    }

    public ServerConfigDocument(File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile) {
        ServerConfigDocument.initializeAppsLocation(serverXML, configDir, bootstrapFile, bootstrapProp, serverEnvFile);
    }

    private static DocumentBuilder getDocumentBuilder() throws Exception {
        if (docBuilder == null) {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setCoalescing(true);
            docBuilderFactory.setIgnoringElementContentWhitespace(true);
            docBuilderFactory.setValidating(false);
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        return docBuilder;
    }

    public static ServerConfigDocument getInstance(File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile) throws IOException {
        if (instance == null || !serverXML.getCanonicalPath().equals(ServerConfigDocument.getServerFile().getCanonicalPath())) {
            instance = new ServerConfigDocument(serverXML, configDir, bootstrapFile, bootstrapProp, serverEnvFile);
        }
        return instance;
    }

    private static void initializeAppsLocation(File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile) {
        try {
            Properties fProps;
            serverFile = serverXML;
            configDirectory = configDir;
            locations = new HashSet<String>();
            props = new Properties();
            Document doc = ServerConfigDocument.parseDocument(new FileInputStream(serverFile));
            File cfgDirFile = ServerConfigDocument.getFileFromConfigDirectory("server.env");
            if (cfgDirFile != null) {
                fProps = ServerConfigDocument.parseProperties(new FileInputStream(cfgDirFile));
                props.putAll((Map<?, ?>)fProps);
            } else if (serverEnvFile.exists()) {
                fProps = ServerConfigDocument.parseProperties(new FileInputStream(serverEnvFile));
                props.putAll((Map<?, ?>)fProps);
            }
            cfgDirFile = ServerConfigDocument.getFileFromConfigDirectory("bootstrap.properties");
            if (cfgDirFile != null) {
                fProps = ServerConfigDocument.parseProperties(new FileInputStream(cfgDirFile));
                props.putAll((Map<?, ?>)fProps);
            } else if (bootstrapProp != null && !bootstrapProp.isEmpty()) {
                while (bootstrapProp.values().remove(null)) {
                }
                props.putAll(bootstrapProp);
            } else if (bootstrapFile.exists()) {
                fProps = ServerConfigDocument.parseProperties(new FileInputStream(bootstrapFile));
                props.putAll((Map<?, ?>)fProps);
            }
            ServerConfigDocument.parseIncludeVariables(doc);
            ServerConfigDocument.parseConfigDropinsDirVariables("defaults");
            ServerConfigDocument.parseVariables(doc);
            ServerConfigDocument.parseConfigDropinsDirVariables("overrides");
            ServerConfigDocument.parseApplication(doc, "/server/application");
            ServerConfigDocument.parseApplication(doc, "/server/webApplication");
            ServerConfigDocument.parseApplication(doc, "/server/enterpriseApplication");
            ServerConfigDocument.parseInclude(doc);
            ServerConfigDocument.parseConfigDropinsDir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void parseApplication(Document doc, String expression) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String resolved;
            String nodeValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
            if (nodeValue.isEmpty() || locations.contains(resolved = ServerConfigDocument.getResolvedVariable(nodeValue))) continue;
            locations.add(resolved);
        }
    }

    private static void parseInclude(Document doc) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.compile("/server/include").evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Document docIncl;
            String nodeValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
            if (nodeValue.isEmpty() || (docIncl = ServerConfigDocument.getIncludeDoc(nodeValue)) == null) continue;
            ServerConfigDocument.parseApplication(docIncl, "/server/application");
            ServerConfigDocument.parseApplication(docIncl, "/server/webApplication");
            ServerConfigDocument.parseApplication(docIncl, "/server/enterpriseApplication");
            ServerConfigDocument.parseInclude(docIncl);
        }
    }

    private static void parseConfigDropinsDir() throws Exception {
        File configDropins = null;
        if (configDirectory != null && configDirectory.exists()) {
            configDropins = new File(configDirectory, "configDropins");
        }
        if (configDropins == null || !configDropins.exists()) {
            configDropins = new File(ServerConfigDocument.getServerFile().getParent(), "configDropins");
        }
        if (configDropins != null && configDropins.exists()) {
            File defaults;
            File overrides = new File(configDropins, "overrides");
            if (overrides.exists()) {
                File[] cfgFiles = overrides.listFiles();
                for (int i = 0; i < cfgFiles.length; ++i) {
                    if (!cfgFiles[i].isFile()) continue;
                    ServerConfigDocument.parseDropinsFiles(cfgFiles[i]);
                }
            }
            if ((defaults = new File(configDropins, "defaults")).exists()) {
                File[] cfgFiles = defaults.listFiles();
                for (int i = 0; i < cfgFiles.length; ++i) {
                    if (!cfgFiles[i].isFile()) continue;
                    ServerConfigDocument.parseDropinsFiles(cfgFiles[i]);
                }
            }
        }
    }

    private static void parseDropinsFiles(File file) throws Exception {
        Document doc = ServerConfigDocument.parseDocument(new FileInputStream(file));
        ServerConfigDocument.parseApplication(doc, "/server/application");
        ServerConfigDocument.parseApplication(doc, "/server/webApplication");
        ServerConfigDocument.parseApplication(doc, "/server/enterpriseApplication");
        ServerConfigDocument.parseInclude(doc);
    }

    private static Document getIncludeDoc(String loc) throws Exception {
        Document doc = null;
        File locFile = null;
        if (loc.startsWith("http:") || loc.startsWith("https:")) {
            if (ServerConfigDocument.isValidURL(loc)) {
                URL url = new URL(loc);
                URLConnection connection = url.openConnection();
                doc = ServerConfigDocument.parseDocument(connection.getInputStream());
            }
        } else if (loc.startsWith("file:")) {
            if (ServerConfigDocument.isValidURL(loc) && (locFile = new File(loc)).exists()) {
                FileInputStream inputStream = new FileInputStream(locFile.getCanonicalPath());
                doc = ServerConfigDocument.parseDocument(inputStream);
            }
        } else if (!loc.startsWith("ftp:")) {
            locFile = new File(loc);
            if (locFile.isAbsolute()) {
                FileInputStream inputStream = new FileInputStream(locFile.getCanonicalPath());
                doc = ServerConfigDocument.parseDocument(inputStream);
            } else {
                if (configDirectory != null && configDirectory.exists()) {
                    locFile = new File(configDirectory, loc);
                }
                if (locFile == null || !locFile.exists()) {
                    locFile = new File(ServerConfigDocument.getServerFile().getParentFile(), loc);
                }
                if (locFile != null && locFile.exists()) {
                    FileInputStream inputStream = new FileInputStream(locFile.getCanonicalPath());
                    doc = ServerConfigDocument.parseDocument(inputStream);
                }
            }
        }
        return doc;
    }

    private static Document parseDocument(InputStream ins) throws Exception {
        Document doc = null;
        try {
            doc = ServerConfigDocument.getDocumentBuilder().parse(ins);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (ins != null) {
                ins.close();
            }
        }
        return doc;
    }

    private static Properties parseProperties(InputStream ins) throws Exception {
        Properties props = null;
        try {
            props = new Properties();
            props.load(ins);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (ins != null) {
                ins.close();
            }
        }
        return props;
    }

    private static boolean isValidURL(String url) {
        try {
            URL testURL = new URL(url);
            testURL.toURI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String getResolvedVariable(String nodeValue) {
        String VARIABLE_NAME_PATTERN = "\\$\\{(.*?)\\}";
        String resolved = nodeValue;
        Pattern varNamePattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher varNameMatcher = varNamePattern.matcher(nodeValue);
        while (varNameMatcher.find()) {
            String variable = ServerConfigDocument.getProperties().getProperty(varNameMatcher.group(1));
            if (variable == null || variable.isEmpty()) continue;
            resolved = resolved.replaceAll("\\$\\{" + varNameMatcher.group(1) + "\\}", variable);
        }
        return resolved;
    }

    private static void parseVariables(Document doc) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.compile("/server/variable").evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String varName = nodeList.item(i).getAttributes().getNamedItem("name").getNodeValue();
            String varValue = nodeList.item(i).getAttributes().getNamedItem("value").getNodeValue();
            if (varName.isEmpty() || varValue.isEmpty()) continue;
            props.put(varName, varValue);
        }
    }

    private static void parseIncludeVariables(Document doc) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.compile("/server/include").evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Document docIncl;
            String nodeValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
            if (nodeValue.isEmpty() || (docIncl = ServerConfigDocument.getIncludeDoc(nodeValue)) == null) continue;
            ServerConfigDocument.parseVariables(docIncl);
            ServerConfigDocument.parseIncludeVariables(docIncl);
        }
    }

    private static void parseConfigDropinsDirVariables(String inDir) throws Exception {
        File dir;
        File configDropins = null;
        if (configDirectory != null && configDirectory.exists()) {
            configDropins = new File(configDirectory, "configDropins");
        }
        if (configDropins == null || !configDropins.exists()) {
            configDropins = new File(ServerConfigDocument.getServerFile().getParent(), "configDropins");
        }
        if (configDropins != null && configDropins.exists() && (dir = new File(configDropins, inDir)).exists()) {
            File[] cfgFiles = dir.listFiles();
            for (int i = 0; i < cfgFiles.length; ++i) {
                if (!cfgFiles[i].isFile()) continue;
                ServerConfigDocument.parseDropinsFilesVariables(cfgFiles[i]);
            }
        }
    }

    private static void parseDropinsFilesVariables(File file) throws Exception {
        Document doc = ServerConfigDocument.parseDocument(new FileInputStream(file));
        ServerConfigDocument.parseVariables(doc);
        ServerConfigDocument.parseIncludeVariables(doc);
    }

    private static File getFileFromConfigDirectory(String file, File def) {
        File f = new File(configDirectory, file);
        if (configDirectory != null && f.exists()) {
            return f;
        }
        if (def != null && def.exists()) {
            return def;
        }
        return null;
    }

    private static File getFileFromConfigDirectory(String file) {
        return ServerConfigDocument.getFileFromConfigDirectory(file, null);
    }
}

