/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import java.io.FileOutputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.wasdev.wlp.maven.plugins.applications.LooseConfigData;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.w3c.dom.Element;

public class LooseApplication {
    private File defaultMF = null;
    protected MavenProject project;
    protected LooseConfigData config;

    public LooseApplication(MavenProject project, LooseConfigData config) {
        this.project = project;
        this.config = config;
    }

    public LooseConfigData getConfig() {
        return this.config;
    }

    public Element getDocumentRoot() {
        return this.config.getDocumentRoot();
    }

    public Element addArchive(Element parent, String target) {
        return this.config.addArchive(parent, target);
    }

    public void addOutputDir(Element parent, MavenProject proj, String target) {
        this.config.addDir(parent, proj.getBuild().getOutputDirectory(), target);
    }

    public void addManifestFile(Element parent, MavenProject proj, String pluginId) throws Exception {
        this.config.addFile(parent, this.getManifestFile(proj, "org.apache.maven.plugins", pluginId), "/META-INF/MANIFEST.MF");
    }

    public void addManifestFile(MavenProject proj, String pluginId) throws Exception {
        this.config.addFile(this.getManifestFile(proj, "org.apache.maven.plugins", pluginId), "/META-INF/MANIFEST.MF");
    }

    public String getPluginConfiguration(MavenProject proj, String pluginGroupId, String pluginArtifactId, String key) {
        Xpp3Dom val;
        Xpp3Dom dom = proj.getGoalConfiguration(pluginGroupId, pluginArtifactId, null, null);
        if (dom != null && (val = dom.getChild(key)) != null) {
            return val.getValue();
        }
        return null;
    }

    public String getManifestFile(MavenProject proj, String pluginGroupId, String pluginArtifactId) throws Exception {
        Xpp3Dom val;
        Xpp3Dom archive;
        Xpp3Dom dom = proj.getGoalConfiguration(pluginGroupId, pluginArtifactId, null, null);
        if (dom != null && (archive = dom.getChild("archive")) != null && (val = archive.getChild("manifestFile")) != null) {
            return proj.getBasedir().getAbsolutePath() + "/" + val.getValue();
        }
        return this.getDefaultManifest().getCanonicalPath();
    }

    public File getDefaultManifest() throws Exception {
        if (this.defaultMF == null) {
            this.defaultMF = new File(this.project.getBuild().getDirectory() + "/liberty-maven/resources/META-INF/MANIFEST.MF");
            this.defaultMF.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(this.defaultMF);
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.write(fos);
            fos.close();
        }
        return this.defaultMF;
    }
}

