/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import java.util.List;
import net.wasdev.wlp.maven.plugins.applications.LooseApplication;
import net.wasdev.wlp.maven.plugins.applications.LooseConfigData;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.w3c.dom.Element;

public class LooseEarApplication
extends LooseApplication {
    public LooseEarApplication(MavenProject project, LooseConfigData config) {
        super(project, config);
    }

    public void addSourceDir() throws Exception {
        File sourceDir = new File(this.project.getBasedir(), "src/main/application");
        String path = this.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "earSourceDirectory");
        if (path != null) {
            sourceDir = new File(this.project.getBasedir(), path);
        }
        this.config.addDir(sourceDir.getCanonicalPath(), "/");
    }

    public void addApplicationXmlFile() throws Exception {
        File applicationXmlFile = null;
        String path = this.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "applicationXml");
        if (path != null && !path.isEmpty()) {
            applicationXmlFile = new File(this.project.getBasedir(), path);
            this.config.addFile(applicationXmlFile.getCanonicalPath(), "/META-INF/application.xml");
        } else if (this.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "generateApplicationXml") == null || this.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "generateApplicationXml").equals("true")) {
            applicationXmlFile = new File(this.project.getBuild().getDirectory() + "/application.xml");
            this.config.addFile(applicationXmlFile.getCanonicalPath(), "/META-INF/application.xml");
        }
    }

    public Element addJarModule(MavenProject proj) throws Exception {
        return this.addModule(proj, "maven-jar-plugin");
    }

    public Element addEjbModule(MavenProject proj) throws Exception {
        return this.addModule(proj, "maven-ejb-plugin");
    }

    public Element addModule(MavenProject proj, String pluginId) throws Exception {
        Element moduleArchive = this.config.addArchive(this.getModuleUri(proj));
        this.config.addDir(moduleArchive, proj.getBuild().getOutputDirectory(), "/");
        this.addManifestFile(moduleArchive, proj, pluginId);
        return moduleArchive;
    }

    public Element addWarModule(MavenProject proj, String warSourceDir) throws Exception {
        Element warArchive = this.config.addArchive(this.getModuleUri(proj));
        this.config.addDir(warArchive, warSourceDir, "/");
        this.config.addDir(warArchive, proj.getBuild().getOutputDirectory(), "/WEB-INF/classes");
        this.addWarManifestFile(warArchive, proj);
        return warArchive;
    }

    public Element addRarModule(MavenProject proj) throws Exception {
        Element rarArchive = this.config.addArchive(this.getModuleUri(proj));
        this.config.addDir(rarArchive, this.getRarSourceDirectory(proj), "/");
        String path = this.getPluginConfiguration(proj, "org.apache.maven.plugins", "maven-rar-plugin", "raXmlFile");
        if (path != null && !path.isEmpty()) {
            File raXmlFile = new File(proj.getBasedir(), path);
            this.config.addFile(rarArchive, raXmlFile.getCanonicalPath(), "/META-INF/ra.xml");
        }
        this.addManifestFile(rarArchive, proj, "maven-rar-plugin");
        return rarArchive;
    }

    public String getRarSourceDirectory(MavenProject proj) throws Exception {
        String dir = this.getPluginConfiguration(proj, "org.apache.maven.plugins", "maven-rar-plugin", "rarSourceDirectory");
        if (dir != null) {
            return new File(proj.getBasedir(), dir).getCanonicalPath();
        }
        return new File(proj.getBasedir(), "src/main/rar").getCanonicalPath();
    }

    public String getModuleUri(MavenProject proj) throws Exception {
        Xpp3Dom[] modules;
        Xpp3Dom val;
        Xpp3Dom dom;
        String defaultUri = "/" + this.getModuleName(proj.getGroupId(), proj.getArtifactId(), proj.getVersion(), proj.getPackaging());
        if (("jar".equals(proj.getPackaging()) || "bundle".equals(proj.getPackaging())) && this.getEarDefaultLibBundleDir() != null) {
            defaultUri = "/" + this.getEarDefaultLibBundleDir() + defaultUri;
        }
        if ((dom = this.project.getGoalConfiguration("org.apache.maven.plugins", "maven-ear-plugin", null, null)) != null && (val = dom.getChild("modules")) != null && (modules = val.getChildren()) != null) {
            for (int i = 0; i < modules.length; ++i) {
                if (!proj.getGroupId().equals(this.getConfigValue(modules[i].getChild("groupId"))) || !proj.getArtifactId().equals(this.getConfigValue(modules[i].getChild("artifactId")))) continue;
                String uri = this.getConfigValue(modules[i].getChild("uri"));
                if (uri != null) {
                    return uri;
                }
                String bundleDir = this.getConfigValue(modules[i].getChild("bundleDir"));
                String bundleFileName = this.getConfigValue(modules[i].getChild("bundleFileName"));
                bundleDir = bundleDir == null ? ("jar".equals(proj.getPackaging()) && this.getEarDefaultLibBundleDir() != null ? "/" + this.getEarDefaultLibBundleDir() : "/") : "/" + bundleDir;
                if (bundleFileName != null) {
                    return bundleDir + "/" + bundleFileName;
                }
                return bundleDir + "/" + this.getModuleName(proj.getGroupId(), proj.getArtifactId(), proj.getVersion(), proj.getPackaging());
            }
        }
        return defaultUri;
    }

    public String getConfigValue(Xpp3Dom element) {
        if (element != null) {
            return element.getValue();
        }
        return null;
    }

    public void addModuleFromM2(MavenProject dependencyProject, Artifact artifact) throws Exception {
        String artifactName = this.getModuleUri(dependencyProject);
        this.config.addFile(artifact.getFile().getAbsolutePath(), artifactName);
    }

    public String getModuleName(String groupId, String artifactId, String version, String packaging) {
        String moduleName;
        String fileExtension = packaging;
        if ("ejb".equals(fileExtension) || "app-client".equals(fileExtension) || "bundle".equals(fileExtension)) {
            fileExtension = "jar";
        }
        switch (this.getEarFileNameMapping()) {
            case "no-version": {
                moduleName = artifactId + "." + fileExtension;
                break;
            }
            case "no-version-for-ejb": {
                if ("ejb".equals(packaging)) {
                    moduleName = artifactId + "." + fileExtension;
                    break;
                }
                moduleName = artifactId + "-" + version + "." + fileExtension;
                break;
            }
            case "full": {
                moduleName = groupId + "-" + artifactId + "-" + version + "." + fileExtension;
                break;
            }
            default: {
                moduleName = artifactId + "-" + version + "." + fileExtension;
            }
        }
        return moduleName;
    }

    public String getEarFileNameMapping() {
        String fileNameMapping = this.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "fileNameMapping");
        if (fileNameMapping == null || fileNameMapping.isEmpty()) {
            fileNameMapping = "standard";
        }
        return fileNameMapping;
    }

    public String getEarDefaultLibBundleDir() {
        return this.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "defaultLibBundleDir");
    }

    public Boolean isEarSkinnyWars() {
        String skinnyWars = this.getPluginConfiguration(this.project, "org.apache.maven.plugins", "maven-ear-plugin", "skinnyWars");
        if (skinnyWars != null && "true".equals(skinnyWars)) {
            return true;
        }
        return false;
    }

    public void addWarManifestFile(Element parent, MavenProject proj) throws Exception {
        File newMf = new File(this.project.getBuild().getDirectory() + "/temp/" + this.getModuleUri(proj) + "/META-INF");
        if (this.isEarSkinnyWars().booleanValue() && newMf.exists()) {
            this.config.addDir(parent, newMf.getCanonicalPath(), "/META-INF");
        } else {
            this.config.addFile(parent, this.getManifestFile(proj, "org.apache.maven.plugins", "maven-war-plugin"), "/META-INF/MANIFEST.MF");
        }
    }

    public boolean isEarCompileDependency(Dependency dependency) {
        List deps = this.project.getDependencies();
        for (Dependency dep : deps) {
            if (!"compile".equals(dep.getScope()) || !"jar".equals(dep.getType()) || !dependency.getGroupId().equals(dep.getGroupId()) || !dependency.getArtifactId().equals(dep.getArtifactId()) || !dependency.getVersion().equals(dep.getVersion())) continue;
            return true;
        }
        return false;
    }
}

