/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.extensions.arquillian;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import net.wasdev.wlp.common.arquillian.objects.LibertyManagedObject;
import net.wasdev.wlp.common.arquillian.objects.LibertyProperty;
import net.wasdev.wlp.common.arquillian.objects.LibertyRemoteObject;
import net.wasdev.wlp.common.arquillian.util.ArquillianConfigurationException;
import net.wasdev.wlp.common.arquillian.util.HttpPortUtil;
import net.wasdev.wlp.maven.plugins.BasicSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.xml.sax.SAXException;

@Mojo(name="configure-arquillian", requiresDependencyResolution=ResolutionScope.TEST)
public class ConfigureArquillianMojo
extends BasicSupport {
    @Parameter
    private Map<String, String> arquillianProperties;
    private TypeProperty type = TypeProperty.NOTFOUND;
    @Parameter(property="skipIfArquillianXmlExists", defaultValue="false")
    protected boolean skipIfArquillianXmlExists = false;

    @Override
    protected void init() throws MojoExecutionException, MojoFailureException {
        super.init();
    }

    public void doExecute() throws MojoExecutionException, MojoFailureException {
        File arquillianXml = new File(this.project.getBuild().getDirectory(), "test-classes/arquillian.xml");
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            if (artifact.getArtifactId().equals("arquillian-wlp-remote-8.5")) {
                this.type = TypeProperty.REMOTE;
                break;
            }
            if (!artifact.getArtifactId().equals("arquillian-wlp-managed-8.5")) continue;
            this.type = TypeProperty.MANAGED;
            break;
        }
        if (this.type == TypeProperty.NOTFOUND) {
            this.log.warn((CharSequence)"Arquillian Liberty Managed and Remote dependencies were not found. Defaulting to use the Liberty Managed container.");
            this.type = TypeProperty.MANAGED;
        }
        if (this.skipIfArquillianXmlExists && arquillianXml.exists()) {
            this.log.info((CharSequence)"Skipping configure-arquillian goal because arquillian.xml already exists in \"target/test-classes\".");
            return;
        }
        switch (this.type) {
            case MANAGED: {
                this.configureArquillianManaged(arquillianXml);
                break;
            }
            case REMOTE: {
                this.configureArquillianRemote(arquillianXml);
                break;
            }
            default: {
                throw new MojoExecutionException("This should never happen.");
            }
        }
    }

    private void configureArquillianManaged(File arquillianXml) throws MojoExecutionException {
        try {
            LibertyManagedObject arquillianManaged = new LibertyManagedObject(this.installDirectory.getCanonicalPath(), this.serverName, this.getHttpPort(), LibertyProperty.getArquillianProperties(this.arquillianProperties, LibertyManagedObject.LibertyManagedProperty.class));
            arquillianManaged.build(arquillianXml);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error configuring Arquillian.", e);
        }
    }

    private void configureArquillianRemote(File arquillianXml) throws MojoExecutionException {
        try {
            LibertyRemoteObject arquillianRemote = new LibertyRemoteObject(LibertyProperty.getArquillianProperties(this.arquillianProperties, LibertyRemoteObject.LibertyRemoteProperty.class));
            arquillianRemote.build(arquillianXml);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error configuring Arquillian.", e);
        }
    }

    private int getHttpPort() throws FileNotFoundException, XPathExpressionException, IOException, ParserConfigurationException, SAXException, ArquillianConfigurationException {
        File serverXML = new File(this.serverDirectory + "/server.xml");
        File bootstrapProperties = new File(this.serverDirectory + "/bootstrap.properties");
        return HttpPortUtil.getHttpPort((File)serverXML, (File)bootstrapProperties);
    }

    private static enum TypeProperty {
        MANAGED,
        REMOTE,
        NOTFOUND;

    }
}

