/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerConfigDocument {
    private static ServerConfigDocument instance;
    private static Log log;
    private static DocumentBuilder docBuilder;
    private static File configDirectory;
    private static File serverXMLFile;
    private static Set<String> locations;
    private static Properties props;
    private static final XPathExpression XPATH_SERVER_APPLICATION;
    private static final XPathExpression XPATH_SERVER_WEB_APPLICATION;
    private static final XPathExpression XPATH_SERVER_ENTERPRISE_APPLICATION;
    private static final XPathExpression XPATH_SERVER_INCLUDE;
    private static final XPathExpression XPATH_SERVER_VARIABLE;

    public Set<String> getLocations() {
        return locations;
    }

    public static Properties getProperties() {
        return props;
    }

    private static File getServerXML() {
        return serverXMLFile;
    }

    public ServerConfigDocument(Log log, File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile) {
        ServerConfigDocument.initializeAppsLocation(log, serverXML, configDir, bootstrapFile, bootstrapProp, serverEnvFile);
    }

    private static DocumentBuilder getDocumentBuilder() {
        if (docBuilder == null) {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setCoalescing(true);
            docBuilderFactory.setIgnoringElementContentWhitespace(true);
            docBuilderFactory.setValidating(false);
            try {
                docBuilder = docBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return docBuilder;
    }

    public static void markInstanceStale() {
        instance = null;
    }

    public static ServerConfigDocument getInstance(Log log, File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile) throws IOException {
        if (instance == null || !serverXML.getCanonicalPath().equals(ServerConfigDocument.getServerXML().getCanonicalPath())) {
            instance = new ServerConfigDocument(log, serverXML, configDir, bootstrapFile, bootstrapProp, serverEnvFile);
        }
        return instance;
    }

    private static void initializeAppsLocation(Log log, File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile) {
        try {
            Properties fProps;
            ServerConfigDocument.log = log;
            serverXMLFile = serverXML;
            configDirectory = configDir;
            locations = new HashSet<String>();
            props = new Properties();
            Document doc = ServerConfigDocument.parseDocument(new FileInputStream(serverXMLFile));
            File cfgDirFile = ServerConfigDocument.getFileFromConfigDirectory("server.env");
            if (cfgDirFile != null) {
                fProps = ServerConfigDocument.parseProperties(new FileInputStream(cfgDirFile));
                props.putAll((Map<?, ?>)fProps);
            } else if (serverEnvFile.exists()) {
                fProps = ServerConfigDocument.parseProperties(new FileInputStream(serverEnvFile));
                props.putAll((Map<?, ?>)fProps);
            }
            cfgDirFile = ServerConfigDocument.getFileFromConfigDirectory("bootstrap.properties");
            if (cfgDirFile != null) {
                fProps = ServerConfigDocument.parseProperties(new FileInputStream(cfgDirFile));
                props.putAll((Map<?, ?>)fProps);
            } else if (bootstrapProp != null && !bootstrapProp.isEmpty()) {
                while (bootstrapProp.values().remove(null)) {
                }
                props.putAll(bootstrapProp);
            } else if (bootstrapFile.exists()) {
                fProps = ServerConfigDocument.parseProperties(new FileInputStream(bootstrapFile));
                props.putAll((Map<?, ?>)fProps);
            }
            ServerConfigDocument.parseIncludeVariables(doc);
            ServerConfigDocument.parseConfigDropinsDirVariables("defaults");
            ServerConfigDocument.parseVariables(doc);
            ServerConfigDocument.parseConfigDropinsDirVariables("overrides");
            ServerConfigDocument.parseApplication(doc, XPATH_SERVER_APPLICATION);
            ServerConfigDocument.parseApplication(doc, XPATH_SERVER_WEB_APPLICATION);
            ServerConfigDocument.parseApplication(doc, XPATH_SERVER_ENTERPRISE_APPLICATION);
            ServerConfigDocument.parseInclude(doc);
            ServerConfigDocument.parseConfigDropinsDir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void parseApplication(Document doc, XPathExpression expression) throws XPathExpressionException {
        NodeList nodeList = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String resolved;
            String nodeValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
            if (nodeValue.isEmpty() || locations.contains(resolved = ServerConfigDocument.getResolvedVariable(nodeValue))) continue;
            locations.add(resolved);
        }
    }

    private static void parseInclude(Document doc) throws XPathExpressionException, IOException, SAXException {
        NodeList nodeList = (NodeList)XPATH_SERVER_INCLUDE.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Document docIncl;
            String nodeValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
            if (nodeValue.isEmpty() || (docIncl = ServerConfigDocument.getIncludeDoc(nodeValue)) == null) continue;
            ServerConfigDocument.parseApplication(docIncl, XPATH_SERVER_APPLICATION);
            ServerConfigDocument.parseApplication(docIncl, XPATH_SERVER_WEB_APPLICATION);
            ServerConfigDocument.parseApplication(docIncl, XPATH_SERVER_ENTERPRISE_APPLICATION);
            ServerConfigDocument.parseInclude(docIncl);
        }
    }

    private static void parseConfigDropinsDir() throws XPathExpressionException, IOException, SAXException {
        File configDropins = ServerConfigDocument.getConfigDropinsDir();
        if (configDropins != null && configDropins.exists()) {
            File defaults;
            File overrides = new File(configDropins, "overrides");
            if (overrides.exists()) {
                ServerConfigDocument.parseDropinsFiles(overrides.listFiles());
            }
            if ((defaults = new File(configDropins, "defaults")).exists()) {
                ServerConfigDocument.parseDropinsFiles(defaults.listFiles());
            }
        }
    }

    private static void parseDropinsFiles(File[] files) throws XPathExpressionException, IOException, SAXException {
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            ServerConfigDocument.parseDropinsFile(files[i]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document parseDropinsXMLFile(File file) throws FileNotFoundException, IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Document document = ServerConfigDocument.parseDocument(is);
            return document;
        }
        catch (SAXException ex) {
            log.info((CharSequence)("Skipping parsing " + file.getAbsolutePath() + " because it was not recognized as XML."));
            return null;
        }
    }

    private static void parseDropinsFile(File file) throws IOException, XPathExpressionException, SAXException {
        Document doc = ServerConfigDocument.parseDropinsXMLFile(file);
        if (doc != null) {
            ServerConfigDocument.parseApplication(doc, XPATH_SERVER_APPLICATION);
            ServerConfigDocument.parseApplication(doc, XPATH_SERVER_WEB_APPLICATION);
            ServerConfigDocument.parseApplication(doc, XPATH_SERVER_ENTERPRISE_APPLICATION);
            ServerConfigDocument.parseInclude(doc);
        }
    }

    private static Document getIncludeDoc(String loc) throws IOException, SAXException {
        Document doc = null;
        File locFile = null;
        if (loc.startsWith("http:") || loc.startsWith("https:")) {
            if (ServerConfigDocument.isValidURL(loc)) {
                URL url = new URL(loc);
                URLConnection connection = url.openConnection();
                doc = ServerConfigDocument.parseDocument(connection.getInputStream());
            }
        } else if (loc.startsWith("file:")) {
            if (ServerConfigDocument.isValidURL(loc) && (locFile = new File(loc)).exists()) {
                FileInputStream inputStream = new FileInputStream(locFile.getCanonicalPath());
                doc = ServerConfigDocument.parseDocument(inputStream);
            }
        } else if (!loc.startsWith("ftp:")) {
            locFile = new File(loc);
            if (locFile.isAbsolute()) {
                FileInputStream inputStream = new FileInputStream(locFile.getCanonicalPath());
                doc = ServerConfigDocument.parseDocument(inputStream);
            } else {
                if (configDirectory != null && configDirectory.exists()) {
                    locFile = new File(configDirectory, loc);
                }
                if (locFile == null || !locFile.exists()) {
                    locFile = new File(ServerConfigDocument.getServerXML().getParentFile(), loc);
                }
                if (locFile != null && locFile.exists()) {
                    FileInputStream inputStream = new FileInputStream(locFile.getCanonicalPath());
                    doc = ServerConfigDocument.parseDocument(inputStream);
                }
            }
        }
        return doc;
    }

    private static Document parseDocument(InputStream in) throws SAXException, IOException {
        try (InputStream ins = in;){
            Document document = ServerConfigDocument.getDocumentBuilder().parse(ins);
            return document;
        }
    }

    private static Properties parseProperties(InputStream ins) throws Exception {
        Properties props = null;
        try {
            props = new Properties();
            props.load(ins);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (ins != null) {
                ins.close();
            }
        }
        return props;
    }

    private static boolean isValidURL(String url) {
        try {
            URL testURL = new URL(url);
            testURL.toURI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String getResolvedVariable(String nodeValue) {
        String VARIABLE_NAME_PATTERN = "\\$\\{(.*?)\\}";
        String resolved = nodeValue;
        Pattern varNamePattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher varNameMatcher = varNamePattern.matcher(nodeValue);
        while (varNameMatcher.find()) {
            String variable = ServerConfigDocument.getProperties().getProperty(varNameMatcher.group(1));
            if (variable == null || variable.isEmpty()) continue;
            resolved = resolved.replaceAll("\\$\\{" + varNameMatcher.group(1) + "\\}", variable);
        }
        return resolved;
    }

    private static void parseVariables(Document doc) throws XPathExpressionException {
        NodeList nodeList = (NodeList)XPATH_SERVER_VARIABLE.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String varName = nodeList.item(i).getAttributes().getNamedItem("name").getNodeValue();
            String varValue = nodeList.item(i).getAttributes().getNamedItem("value").getNodeValue();
            if (varName.isEmpty() || varValue.isEmpty()) continue;
            props.put(varName, varValue);
        }
    }

    private static void parseIncludeVariables(Document doc) throws XPathExpressionException, IOException, SAXException {
        NodeList nodeList = (NodeList)XPATH_SERVER_INCLUDE.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Document docIncl;
            String nodeValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
            if (nodeValue.isEmpty() || (docIncl = ServerConfigDocument.getIncludeDoc(nodeValue)) == null) continue;
            ServerConfigDocument.parseVariables(docIncl);
            ServerConfigDocument.parseIncludeVariables(docIncl);
        }
    }

    private static File getConfigDropinsDir() {
        File configDropins = null;
        if (configDropins == null || !configDropins.exists()) {
            configDropins = new File(ServerConfigDocument.getServerXML().getParent(), "configDropins");
        }
        return configDropins;
    }

    private static void parseConfigDropinsDirVariables(String inDir) throws XPathExpressionException, SAXException, IOException {
        File dir;
        File configDropins = ServerConfigDocument.getConfigDropinsDir();
        if (configDropins != null && configDropins.exists() && (dir = new File(configDropins, inDir)).exists()) {
            File[] cfgFiles = dir.listFiles();
            for (int i = 0; i < cfgFiles.length; ++i) {
                if (!cfgFiles[i].isFile()) continue;
                ServerConfigDocument.parseDropinsFilesVariables(cfgFiles[i]);
            }
        }
    }

    private static void parseDropinsFilesVariables(File file) throws SAXException, IOException, XPathExpressionException {
        Document doc = ServerConfigDocument.parseDropinsXMLFile(file);
        if (doc != null) {
            ServerConfigDocument.parseVariables(doc);
            ServerConfigDocument.parseIncludeVariables(doc);
        }
    }

    private static File getFileFromConfigDirectory(String file, File def) {
        File f = new File(configDirectory, file);
        if (configDirectory != null && f.exists()) {
            return f;
        }
        if (def != null && def.exists()) {
            return def;
        }
        return null;
    }

    private static File getFileFromConfigDirectory(String file) {
        return ServerConfigDocument.getFileFromConfigDirectory(file, null);
    }

    static {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPATH_SERVER_APPLICATION = xPath.compile("/server/application");
            XPATH_SERVER_WEB_APPLICATION = xPath.compile("/server/webApplication");
            XPATH_SERVER_ENTERPRISE_APPLICATION = xPath.compile("/server/enterpriseApplication");
            XPATH_SERVER_INCLUDE = xPath.compile("/server/include");
            XPATH_SERVER_VARIABLE = xPath.compile("/server/variable");
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException(ex);
        }
    }
}

