/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.server;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.wasdev.wlp.ant.ServerTask;
import net.wasdev.wlp.common.plugins.util.DevUtil;
import net.wasdev.wlp.common.plugins.util.PluginExecutionException;
import net.wasdev.wlp.common.plugins.util.PluginScenarioException;
import net.wasdev.wlp.common.plugins.util.ServerFeatureUtil;
import net.wasdev.wlp.maven.plugins.server.StartDebugMojoSupport;
import net.wasdev.wlp.maven.plugins.utils.MavenProjectUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.XMLUnit;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="dev", requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class DevMojo
extends StartDebugMojoSupport {
    private static final String TEST_RUN_ID_PROPERTY_NAME = "liberty.dev.test.run.id";
    @Parameter(property="hotTests", defaultValue="false")
    private boolean hotTests;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="skipUTs", defaultValue="false")
    private boolean skipUTs;
    @Parameter(property="skipITs", defaultValue="false")
    private boolean skipITs;
    @Parameter(property="liberty.debug.port", defaultValue="7777")
    private int libertyDebugPort;
    private int runId = 0;
    private ServerTask serverTask = null;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(property="verifyTimeout", defaultValue="30")
    private int verifyTimeout = 30;
    @Parameter(property="appUpdateTimeout", defaultValue="5")
    private int appUpdateTimeout = 5;
    @Parameter(property="serverStartTimeout", defaultValue="30")
    private int serverStartTimeout = 30;
    @Parameter(property="applications")
    private String applications;
    @Parameter(property="clean", defaultValue="false")
    protected boolean clean;
    @Parameter(readonly=true, required=true, defaultValue=" ${project.build.sourceDirectory}")
    private String sourceDirectoryString;
    private File sourceDirectory;
    @Parameter(readonly=true, required=true, defaultValue=" ${project.build.testSourceDirectory}")
    private String testSourceDirectoryString;
    private File testSourceDirectory;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.testOutputDirectory}")
    private File testOutputDirectory;
    private static ServerFeature serverFeatureUtil;

    protected void doExecute() throws Exception {
        if (this.skip) {
            return;
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1, true));
        this.log.info((CharSequence)"Running maven-compiler-plugin:compile");
        this.runMojo("org.apache.maven.plugins:maven-compiler-plugin", "compile", null, null);
        this.log.info((CharSequence)"Running maven-compiler-plugin:resources");
        this.runMojo("org.apache.maven.plugins:maven-resources-plugin", "resources", null, null);
        this.log.info((CharSequence)"Running maven-compiler-plugin:testCompile");
        this.runMojo("org.apache.maven.plugins:maven-compiler-plugin", "testCompile", null, null);
        this.log.info((CharSequence)"Running maven-compiler-plugin:testResources");
        this.runMojo("org.apache.maven.plugins:maven-resources-plugin", "testResources", null, null);
        this.sourceDirectory = new File(this.sourceDirectoryString.trim());
        this.testSourceDirectory = new File(this.testSourceDirectoryString.trim());
        ArrayList<File> javaFiles = new ArrayList<File>();
        this.listFiles(this.sourceDirectory, javaFiles, ".java");
        ArrayList<File> javaTestFiles = new ArrayList<File>();
        this.listFiles(this.testSourceDirectory, javaTestFiles, ".java");
        this.log.debug((CharSequence)("Source directory: " + this.sourceDirectory));
        this.log.debug((CharSequence)("Output directory: " + this.outputDirectory));
        this.log.debug((CharSequence)("Test Source directory: " + this.testSourceDirectory));
        this.log.debug((CharSequence)("Test Output directory: " + this.testOutputDirectory));
        this.log.info((CharSequence)"Running goal: create-server");
        this.runMojo("net.wasdev.wlp.maven.plugins:liberty-maven-plugin", "create-server", this.serverName, null);
        this.log.info((CharSequence)"Running goal: install-feature");
        this.runMojo("net.wasdev.wlp.maven.plugins:liberty-maven-plugin", "install-feature", this.serverName, null);
        this.log.info((CharSequence)"Running goal: install-apps");
        this.runMojo("net.wasdev.wlp.maven.plugins:liberty-maven-plugin", "install-apps", this.serverName, null);
        ArrayList<File> resourceDirs = new ArrayList<File>();
        if (this.outputDirectory.exists()) {
            List resources = this.project.getResources();
            for (Resource resource : resources) {
                File resourceFile = new File(resource.getDirectory());
                if (!resourceFile.exists()) continue;
                resourceDirs.add(resourceFile);
            }
        }
        if (resourceDirs.isEmpty()) {
            File defaultResourceDir = new File(this.project.getBasedir() + "/src/main/resources");
            this.log.debug((CharSequence)("No resource directory detected, using default directory: " + defaultResourceDir));
            resourceDirs.add(defaultResourceDir);
        }
        DevMojoUtil util = new DevMojoUtil(this.serverDirectory, this.sourceDirectory, this.testSourceDirectory, this.configDirectory, resourceDirs);
        util.addShutdownHook(executor);
        util.enableServerDebug(this.libertyDebugPort);
        util.startServer(this.serverStartTimeout, this.verifyTimeout);
        List<String> artifactPaths = util.getArtifacts();
        if (this.hotTests && this.testSourceDirectory.exists()) {
            util.runTestThread(false, executor, -1, false, false);
        } else {
            util.runHotkeyReaderThread(executor);
        }
        File pom = this.project.getFile();
        util.watchFiles(pom, this.outputDirectory, this.testOutputDirectory, executor, artifactPaths, this.configFile);
    }

    private void addArtifacts(DependencyNode root, List<File> artifacts) {
        if (root.getArtifact() != null) {
            artifacts.add(root.getArtifact().getFile());
        }
        for (DependencyNode node : root.getChildren()) {
            this.addArtifacts(node, artifacts);
        }
    }

    private List<Artifact> getNewDependencies(List<Dependency> dependencies, List<Dependency> existingDependencies) throws MojoExecutionException {
        ArrayList<Artifact> updatedArtifacts = new ArrayList<Artifact>();
        for (Dependency dep : dependencies) {
            boolean newDependency = true;
            for (Dependency existingDep : existingDependencies) {
                if (!dep.getArtifactId().equals(existingDep.getArtifactId())) continue;
                newDependency = false;
                break;
            }
            if (!newDependency) continue;
            this.log.debug((CharSequence)("New dependency found: " + dep.getArtifactId()));
            Artifact artifact = this.getArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getType(), dep.getVersion());
            updatedArtifacts.add(artifact);
        }
        return updatedArtifacts;
    }

    private void runTestMojo(String groupId, String artifactId, String phase) throws MojoExecutionException {
        Plugin plugin = this.project.getPlugin(groupId + ":" + artifactId);
        if (plugin == null) {
            plugin = MojoExecutor.plugin((String)MojoExecutor.groupId((String)groupId), (String)MojoExecutor.artifactId((String)artifactId), (String)MojoExecutor.version((String)"RELEASE"));
        }
        Xpp3Dom config = null;
        List buildPlugins = this.project.getBuildPlugins();
        for (Plugin p : buildPlugins) {
            String executionId;
            String[] defaultExecutionIds;
            if (!p.equals((Object)plugin)) continue;
            config = (Xpp3Dom)p.getConfiguration();
            PluginExecution pluginExecution = null;
            Map peMap = p.getExecutionsAsMap();
            String[] stringArray = defaultExecutionIds = new String[]{"default-" + phase, phase, "default"};
            int n = stringArray.length;
            for (int i = 0; i < n && (pluginExecution = (PluginExecution)peMap.get(executionId = stringArray[i])) == null; ++i) {
            }
            if (pluginExecution == null) break;
            Xpp3Dom executionConfig = (Xpp3Dom)pluginExecution.getConfiguration();
            config = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)executionConfig, (Xpp3Dom)config);
            break;
        }
        if (config == null) {
            this.log.debug((CharSequence)("Could not find " + artifactId + " configuration for " + phase + " phase. Creating new configuration."));
            config = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]);
        }
        if (phase.equals("test")) {
            this.injectTestId(config);
        } else if (phase.equals("integration-test")) {
            this.injectTestId(config);
            File summaryFile = null;
            Xpp3Dom summaryFileElement = config.getChild("summaryFile");
            summaryFile = summaryFileElement != null ? new File(summaryFileElement.getValue()) : new File(this.project.getBuild().getDirectory() + "/failsafe-reports/failsafe-summary.xml");
            try {
                this.log.debug((CharSequence)("Looking for summary file at " + summaryFile.getCanonicalPath()));
            }
            catch (IOException e) {
                this.log.debug((CharSequence)("Unable to resolve summary file " + e.getMessage()));
            }
            if (summaryFile.exists()) {
                boolean deleteResult = summaryFile.delete();
                this.log.debug((CharSequence)("Summary file deleted? " + deleteResult));
            } else {
                this.log.debug((CharSequence)"Summary file doesn't exist");
            }
        }
        this.log.debug((CharSequence)(artifactId + " configuration for " + phase + " phase: " + config));
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)phase), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session.clone(), (BuildPluginManager)this.pluginManager));
    }

    private void injectTestId(Xpp3Dom config) {
        Xpp3Dom properties = config.getChild("properties");
        if (properties == null || properties.getChild(TEST_RUN_ID_PROPERTY_NAME) == null) {
            MojoExecutor.Element e = MojoExecutor.element((String)MojoExecutor.name((String)"properties"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)TEST_RUN_ID_PROPERTY_NAME), (String)String.valueOf(this.runId++))});
            config.addChild(e.toDom());
        } else {
            properties.getChild(TEST_RUN_ID_PROPERTY_NAME).setValue(String.valueOf(this.runId++));
        }
    }

    private MojoExecutor.Element[] getPluginConfigurationElements(String goal, String testServerName, List<String> dependencies) {
        ArrayList<MojoExecutor.Element> elements = new ArrayList<MojoExecutor.Element>();
        try {
            if (testServerName != null) {
                elements.add(MojoExecutor.element((String)MojoExecutor.name((String)"serverName"), (String)testServerName));
                elements.add(MojoExecutor.element((String)MojoExecutor.name((String)"configDirectory"), (String)this.configDirectory.getCanonicalPath()));
                if (goal.equals("install-feature") && dependencies != null) {
                    MojoExecutor.Element[] featureElems = new MojoExecutor.Element[dependencies.size()];
                    for (int i = 0; i < featureElems.length; ++i) {
                        featureElems[i] = MojoExecutor.element((String)MojoExecutor.name((String)"feature"), (String)dependencies.get(i));
                    }
                    elements.add(MojoExecutor.element((String)MojoExecutor.name((String)"features"), (MojoExecutor.Element[])featureElems));
                } else if (goal.equals("install-apps")) {
                    String appsDirectory = MavenProjectUtil.getPluginExecutionConfiguration(this.project, "net.wasdev.wlp.maven.plugins", "liberty-maven-plugin", "install-apps", "appsDirectory");
                    if (appsDirectory != null) {
                        elements.add(MojoExecutor.element((String)MojoExecutor.name((String)"appsDirectory"), (String)appsDirectory));
                    }
                    elements.add(MojoExecutor.element((String)MojoExecutor.name((String)"looseApplication"), (String)"true"));
                    elements.add(MojoExecutor.element((String)MojoExecutor.name((String)"stripVersion"), (String)"true"));
                    elements.add(MojoExecutor.element((String)MojoExecutor.name((String)"installAppPackages"), (String)"project"));
                    elements.add(MojoExecutor.element((String)MojoExecutor.name((String)"configFile"), (String)this.configFile.getCanonicalPath()));
                } else if (goal.equals("create-server")) {
                    elements.add(MojoExecutor.element((String)MojoExecutor.name((String)"configFile"), (String)this.configFile.getCanonicalPath()));
                    if (this.assemblyArtifact != null) {
                        MojoExecutor.Element[] featureElems = new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)this.assemblyArtifact.getGroupId()), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)this.assemblyArtifact.getArtifactId()), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)this.assemblyArtifact.getVersion()), MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)this.assemblyArtifact.getType())};
                        elements.add(MojoExecutor.element((String)MojoExecutor.name((String)"assemblyArtifact"), (MojoExecutor.Element[])featureElems));
                    }
                }
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Unable to resolve canonical paths " + e.getMessage()));
        }
        return elements.toArray(new MojoExecutor.Element[elements.size()]);
    }

    private void runMojo(String plugin, String goal, String serverName, List<String> dependencies) throws MojoExecutionException {
        Plugin mavenPlugin = this.project.getPlugin(plugin);
        this.log.info((CharSequence)("plugin version: " + mavenPlugin.getVersion()));
        MojoExecutor.executeMojo((Plugin)mavenPlugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])this.getPluginConfigurationElements(goal, serverName, dependencies)), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MavenProject loadProject(File pomFile) throws IOException, XmlPullParserException {
        MavenProject ret = null;
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        if (pomFile != null && pomFile.exists()) {
            try (InputStreamReader reader = null;){
                reader = new FileReader(pomFile);
                Model model = mavenReader.read((Reader)reader);
                model.setPomFile(pomFile);
                ret = new MavenProject(model);
            }
        }
        return ret;
    }

    private void listFiles(File directory, List<File> files, String suffix) {
        File[] fList;
        if (directory != null && (fList = directory.listFiles()) != null) {
            for (File file : fList) {
                if (file.isFile() && (suffix == null || file.getName().toLowerCase().endsWith("." + suffix))) {
                    files.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.listFiles(file, files, suffix);
            }
        }
    }

    private ServerFeature getServerFeatureUtil() {
        if (serverFeatureUtil == null) {
            serverFeatureUtil = new ServerFeature();
        }
        return serverFeatureUtil;
    }

    private class ServerFeature
    extends ServerFeatureUtil {
        private ServerFeature() {
        }

        public void debug(String msg) {
            DevMojo.this.log.debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable e) {
            DevMojo.this.log.debug((CharSequence)msg, e);
        }

        public void debug(Throwable e) {
            DevMojo.this.log.debug(e);
        }

        public void warn(String msg) {
            DevMojo.this.log.warn((CharSequence)msg);
        }

        public void info(String msg) {
            DevMojo.this.log.info((CharSequence)msg);
        }
    }

    private class DevMojoUtil
    extends DevUtil {
        List<Dependency> existingDependencies;
        String existingPom;
        Set<String> existingFeatures;

        public DevMojoUtil(File serverDirectory, File sourceDirectory, File testSourceDirectory, File configDirectory, List<File> resourceDirs) throws IOException {
            super(serverDirectory, sourceDirectory, testSourceDirectory, configDirectory, resourceDirs, DevMojo.this.hotTests, DevMojo.this.skipTests, DevMojo.this.skipUTs, DevMojo.this.skipITs, DevMojo.this.project.getArtifactId(), DevMojo.this.appUpdateTimeout);
            this.existingDependencies = DevMojo.this.project.getDependencies();
            File pom = DevMojo.this.project.getFile();
            this.existingPom = this.readFile(pom);
            ServerFeature servUtil = DevMojo.this.getServerFeatureUtil();
            this.existingFeatures = servUtil.getServerFeatures(serverDirectory);
        }

        public void debug(String msg) {
            DevMojo.this.log.debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable e) {
            DevMojo.this.log.debug((CharSequence)msg, e);
        }

        public void debug(Throwable e) {
            DevMojo.this.log.debug(e);
        }

        public void warn(String msg) {
            DevMojo.this.log.warn((CharSequence)msg);
        }

        public void info(String msg) {
            DevMojo.this.log.info((CharSequence)msg);
        }

        public void error(String msg) {
            DevMojo.this.log.error((CharSequence)msg);
        }

        public void error(String msg, Throwable e) {
            DevMojo.this.log.error((CharSequence)msg, e);
        }

        public boolean isDebugEnabled() {
            return DevMojo.this.log.isDebugEnabled();
        }

        public void stopServer() {
            try {
                ServerTask serverTask = DevMojo.this.initializeJava();
                serverTask.setOperation("stop");
                serverTask.execute();
            }
            catch (Exception e) {
                DevMojo.this.log.debug((CharSequence)"Error stopping server", (Throwable)e);
            }
        }

        public ServerTask getDebugServerTask() throws IOException {
            if (DevMojo.this.serverTask != null) {
                return DevMojo.this.serverTask;
            }
            DevMojo.this.serverTask = DevMojo.this.initializeJava();
            DevMojo.this.copyConfigFiles();
            DevMojo.this.serverTask.setClean(DevMojo.this.clean);
            DevMojo.this.serverTask.setOperation("debug");
            return DevMojo.this.serverTask;
        }

        public List<String> getArtifacts() {
            ArrayList<String> artifactPaths = new ArrayList<String>();
            Set artifacts = DevMojo.this.project.getArtifacts();
            for (Artifact artifact : artifacts) {
                try {
                    artifactPaths.add(artifact.getFile().getCanonicalPath());
                }
                catch (IOException e) {
                    DevMojo.this.log.error((CharSequence)("Unable to resolve project artifact " + e.getMessage()));
                }
            }
            return artifactPaths;
        }

        public boolean recompileBuildFile(File buildFile, List<String> artifactPaths, ThreadPoolExecutor executor) {
            block9: {
                try {
                    String modifiedPom = this.readFile(buildFile);
                    XMLUnit.setIgnoreWhitespace((boolean)true);
                    XMLUnit.setIgnoreAttributeOrder((boolean)true);
                    XMLUnit.setIgnoreComments((boolean)true);
                    DetailedDiff diff = new DetailedDiff(XMLUnit.compareXML((String)this.existingPom, (String)modifiedPom));
                    List allDifferences = diff.getAllDifferences();
                    DevMojo.this.log.debug((CharSequence)("Number of differences in the pom: " + allDifferences.size()));
                    if (allDifferences.isEmpty()) break block9;
                    DevMojo.this.log.info((CharSequence)"Pom has been modified");
                    MavenProject updatedProject = DevMojo.loadProject(buildFile);
                    List dependencies = updatedProject.getDependencies();
                    DevMojo.this.log.debug((CharSequence)("Dependencies size: " + dependencies.size()));
                    DevMojo.this.log.debug((CharSequence)("Existing dependencies size: " + this.existingDependencies.size()));
                    ArrayList<String> dependencyIds = new ArrayList<String>();
                    List updatedArtifacts = DevMojo.this.getNewDependencies(dependencies, this.existingDependencies);
                    if (!updatedArtifacts.isEmpty()) {
                        for (Artifact artifact : updatedArtifacts) {
                            if ("esa".equals(artifact.getType())) {
                                dependencyIds.add(artifact.getArtifactId());
                            }
                            DefaultArtifact aetherArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getVersion());
                            org.eclipse.aether.graph.Dependency dependency = new org.eclipse.aether.graph.Dependency((org.eclipse.aether.artifact.Artifact)aetherArtifact, null, Boolean.valueOf(true));
                            CollectRequest collectRequest = new CollectRequest();
                            collectRequest.setRoot(dependency);
                            collectRequest.setRepositories(DevMojo.this.repositories);
                            ArrayList<String> addToClassPath = new ArrayList<String>();
                            DependencyRequest depRequest = new DependencyRequest(collectRequest, null);
                            try {
                                DependencyResult dependencyResult = DevMojo.this.repositorySystem.resolveDependencies(DevMojo.this.repoSession, depRequest);
                                DependencyNode root = dependencyResult.getRoot();
                                ArrayList artifactsList = new ArrayList();
                                DevMojo.this.addArtifacts(root, artifactsList);
                                for (File a : artifactsList) {
                                    DevMojo.this.log.debug((CharSequence)("Artifact: " + a));
                                    if (!a.getCanonicalPath().endsWith(".jar")) continue;
                                    addToClassPath.add(a.getCanonicalPath());
                                }
                            }
                            catch (DependencyResolutionException e) {
                                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                            }
                            artifactPaths.addAll(addToClassPath);
                        }
                        if (!dependencyIds.isEmpty()) {
                            DevMojo.this.runMojo("net.wasdev.wlp.maven.plugins:liberty-maven-plugin", "install-feature", DevMojo.this.serverName, dependencyIds);
                            dependencyIds.clear();
                        }
                        this.existingDependencies = dependencies;
                        this.existingPom = modifiedPom;
                        return true;
                    }
                    DevMojo.this.log.info((CharSequence)"Unhandled change detected in pom.xml. Restart liberty:dev mode for it to take effect.");
                }
                catch (Exception e) {
                    DevMojo.this.log.debug((CharSequence)"Could not recompile pom.xml", (Throwable)e);
                }
            }
            return false;
        }

        public void checkConfigFile(File configFile, File serverDir) {
            try {
                ServerFeature servUtil = DevMojo.this.getServerFeatureUtil();
                Set features = servUtil.getServerFeatures(serverDir);
                features.removeAll(this.existingFeatures);
                if (!features.isEmpty()) {
                    ArrayList configFeatures = new ArrayList(features);
                    DevMojo.this.log.info((CharSequence)"Configuration features have been added");
                    DevMojo.this.runMojo("net.wasdev.wlp.maven.plugins:liberty-maven-plugin", "install-feature", DevMojo.this.serverName, configFeatures);
                    this.existingFeatures.addAll(features);
                }
            }
            catch (MojoExecutionException e) {
                DevMojo.this.log.error((CharSequence)"Failed to install features from configuration file", (Throwable)e);
            }
        }

        public boolean compile(File dir) {
            try {
                if (dir.equals(DevMojo.this.sourceDirectory)) {
                    DevMojo.this.log.info((CharSequence)"Running maven-compiler-plugin:compile");
                    DevMojo.this.runMojo("org.apache.maven.plugins:maven-compiler-plugin", "compile", null, null);
                    DevMojo.this.log.info((CharSequence)"Running maven-compiler-plugin:resources");
                    DevMojo.this.runMojo("org.apache.maven.plugins:maven-resources-plugin", "resources", null, null);
                }
                if (dir.equals(DevMojo.this.testSourceDirectory)) {
                    DevMojo.this.log.info((CharSequence)"Running maven-compiler-plugin:testCompile");
                    DevMojo.this.runMojo("org.apache.maven.plugins:maven-compiler-plugin", "testCompile", null, null);
                    DevMojo.this.log.info((CharSequence)"Running maven-compiler-plugin:testResources");
                    DevMojo.this.runMojo("org.apache.maven.plugins:maven-resources-plugin", "testResources", null, null);
                }
                return true;
            }
            catch (MojoExecutionException e) {
                DevMojo.this.log.error((CharSequence)"Unable to compile", (Throwable)e);
                return false;
            }
        }

        public void runUnitTests() throws PluginExecutionException, PluginScenarioException {
            try {
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-surefire-plugin", "test");
            }
            catch (MojoExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof MojoFailureException) {
                    throw new PluginScenarioException("Unit tests failed: " + cause.getLocalizedMessage(), (Throwable)e);
                }
                throw new PluginExecutionException("Failed to run unit tests", (Throwable)e);
            }
        }

        public void runIntegrationTests() throws PluginExecutionException, PluginScenarioException {
            try {
                DevMojo.this.runMojo("org.apache.maven.plugins:maven-war-plugin", "war", null, null);
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-failsafe-plugin", "integration-test");
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-failsafe-plugin", "verify");
            }
            catch (MojoExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof MojoFailureException) {
                    throw new PluginScenarioException("Integration tests failed: " + cause.getLocalizedMessage(), (Throwable)e);
                }
                throw new PluginExecutionException("Failed to run integration tests", (Throwable)e);
            }
        }
    }
}

