/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import net.wasdev.wlp.ant.ServerTask;
import net.wasdev.wlp.maven.plugins.BasicSupport;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;

public class StartDebugMojoSupport
extends BasicSupport {
    private static final String HEADER = "# Generated by liberty-maven-plugin";
    @Parameter(property="configFile", defaultValue="${basedir}/src/test/resources/server.xml")
    protected File configFile;
    @Parameter(property="bootstrapPropertiesFile", defaultValue="${basedir}/src/test/resources/bootstrap.properties")
    protected File bootstrapPropertiesFile;
    @Parameter
    protected Map<String, String> bootstrapProperties;
    @Parameter(property="jvmOptionsFile", defaultValue="${basedir}/src/test/resources/jvm.options")
    protected File jvmOptionsFile;
    @Parameter
    protected List<String> jvmOptions;

    protected ServerTask initializeJava() {
        ServerTask serverTask = (ServerTask)this.ant.createTask("antlib:net/wasdev/wlp/ant:server");
        if (serverTask == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "server"));
        }
        serverTask.setInstallDir(this.installDirectory);
        serverTask.setServerName(this.serverName);
        serverTask.setUserDir(this.userDirectory);
        serverTask.setOutputDir(this.outputDirectory);
        return serverTask;
    }

    protected void copyConfigFiles() throws IOException {
        Copy copy;
        Copy copy2;
        String serverXMLPath = null;
        String jvmOptionsPath = null;
        String bootStrapPropertiesPath = null;
        String serverEnvPath = null;
        if (this.configDirectory != null && this.configDirectory.exists()) {
            File configDirServerEnv;
            File configDirBootstrapFile;
            File configDirJvmOptionsFile;
            Copy copydir = (Copy)this.ant.createTask("copy");
            FileSet fileset = new FileSet();
            fileset.setDir(this.configDirectory);
            copydir.addFileset(fileset);
            copydir.setTodir(this.serverDirectory);
            copydir.setOverwrite(true);
            copydir.execute();
            File configDirServerXML = new File(this.configDirectory, "server.xml");
            if (configDirServerXML.exists()) {
                serverXMLPath = configDirServerXML.getCanonicalPath();
            }
            if ((configDirJvmOptionsFile = new File(this.configDirectory, "jvm.options")).exists()) {
                jvmOptionsPath = configDirJvmOptionsFile.getCanonicalPath();
            }
            if ((configDirBootstrapFile = new File(this.configDirectory, "bootstrap.properties")).exists()) {
                bootStrapPropertiesPath = configDirBootstrapFile.getCanonicalPath();
            }
            if ((configDirServerEnv = new File(this.configDirectory, "server.env")).exists()) {
                serverEnvPath = configDirServerEnv.getCanonicalPath();
            }
        }
        if ((serverXMLPath == null || serverXMLPath.isEmpty()) && this.configFile != null && this.configFile.exists()) {
            copy2 = (Copy)this.ant.createTask("copy");
            copy2.setFile(this.configFile);
            copy2.setTofile(new File(this.serverDirectory, "server.xml"));
            copy2.setOverwrite(true);
            copy2.execute();
            serverXMLPath = this.configFile.getCanonicalPath();
        }
        if (jvmOptionsPath == null || jvmOptionsPath.isEmpty()) {
            File optionsFile = new File(this.serverDirectory, "jvm.options");
            if (this.jvmOptions != null) {
                this.writeJvmOptions(optionsFile, this.jvmOptions);
                jvmOptionsPath = "inlined configuration";
            } else if (this.jvmOptionsFile != null && this.jvmOptionsFile.exists()) {
                copy = (Copy)this.ant.createTask("copy");
                copy.setFile(this.jvmOptionsFile);
                copy.setTofile(optionsFile);
                copy.setOverwrite(true);
                copy.execute();
                jvmOptionsPath = this.jvmOptionsFile.getCanonicalPath();
            }
        }
        if (bootStrapPropertiesPath == null || bootStrapPropertiesPath.isEmpty()) {
            File bootstrapFile = new File(this.serverDirectory, "bootstrap.properties");
            if (this.bootstrapProperties != null) {
                this.writeBootstrapProperties(bootstrapFile, this.bootstrapProperties);
                bootStrapPropertiesPath = "inlined configuration";
            } else if (this.bootstrapPropertiesFile != null && this.bootstrapPropertiesFile.exists()) {
                copy = (Copy)this.ant.createTask("copy");
                copy.setFile(this.bootstrapPropertiesFile);
                copy.setTofile(bootstrapFile);
                copy.setOverwrite(true);
                copy.execute();
                bootStrapPropertiesPath = this.bootstrapPropertiesFile.getCanonicalPath();
            }
        }
        if ((serverEnvPath == null || serverEnvPath.isEmpty()) && this.serverEnv != null && this.serverEnv.exists()) {
            copy2 = (Copy)this.ant.createTask("copy");
            copy2.setFile(this.serverEnv);
            copy2.setTofile(new File(this.serverDirectory, "server.env"));
            copy2.setOverwrite(true);
            copy2.execute();
            serverEnvPath = this.serverEnv.getCanonicalPath();
        }
        if (serverXMLPath != null && !serverXMLPath.isEmpty()) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "server.xml", serverXMLPath));
        }
        if (jvmOptionsPath != null && !jvmOptionsPath.isEmpty()) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "jvm.options", jvmOptionsPath));
        }
        if (bootStrapPropertiesPath != null && !bootStrapPropertiesPath.isEmpty()) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "bootstrap.properties", bootStrapPropertiesPath));
        }
        if (serverEnvPath != null && !serverEnvPath.isEmpty()) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "server.env", serverEnvPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBootstrapProperties(File file, Map<String, String> properties) throws IOException {
        this.makeParentDirectory(file);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(file, "UTF-8");
            writer.println(HEADER);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                writer.print(entry.getKey());
                writer.print("=");
                writer.println(entry.getValue() != null ? entry.getValue().replace("\\", "/") : "");
                if (entry.getValue() != null) continue;
                this.log.error((CharSequence)("The value of the bootstrap property " + entry.getKey() + " is null. Verify if the needed POM properties are set correctly."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJvmOptions(File file, List<String> options) throws IOException {
        this.makeParentDirectory(file);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(file, "UTF-8");
            writer.println(HEADER);
            for (String option : options) {
                writer.println(option);
            }
        }
    }

    private void makeParentDirectory(File file) {
        File parentDir = file.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
    }
}

