/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.mavenreport;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="report")
public class SonarReportMojo
extends AbstractMavenReport {
    @Parameter(property="sonar.host.url", defaultValue="http://localhost:9000", alias="sonar.host.url", required=true)
    private String sonarHostURL;
    @Parameter(property="branch", alias="branch", required=false)
    private String branch;

    protected String getSonarHostURL() {
        return this.sonarHostURL;
    }

    protected void setSonarHostURL(String sonarHostURL) {
        this.sonarHostURL = sonarHostURL;
    }

    protected String getBranch() {
        return this.branch;
    }

    protected void setBranch(String branch) {
        this.branch = branch;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        Sink sink = this.getSink();
        sink.head();
        sink.title();
        sink.text(this.getHeader(locale));
        sink.title_();
        sink.head_();
        sink.body();
        sink.sectionTitle1();
        sink.text(this.getHeader(locale));
        sink.sectionTitle1_();
        String url = this.getProjectUrl();
        sink.text("Redirecting to ");
        sink.link(url);
        sink.text(url);
        sink.link_();
        sink.rawText("<script type='text/javascript'> window.location='" + url + "'</script>");
        sink.body_();
        sink.flush();
        sink.close();
    }

    public String getOutputName() {
        if (this.hasTriggerAlternative(Locale.getDefault())) {
            return this.getBundle(Locale.getDefault()).getString("report.sonar.html.alternative");
        }
        return this.getBundle(Locale.getDefault()).getString("report.sonar.html");
    }

    public String getName(Locale locale) {
        if (this.hasTriggerAlternative(locale)) {
            return this.getBundle(locale).getString("report.sonar.name.alternative");
        }
        return this.getBundle(locale).getString("report.sonar.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.sonar.description");
    }

    public String getHeader(Locale locale) {
        if (this.hasTriggerAlternative(locale)) {
            return this.getBundle(locale).getString("report.sonar.header.alternative");
        }
        return this.getBundle(locale).getString("report.sonar.header");
    }

    public boolean hasTriggerAlternative(Locale locale) {
        return this.getProjectUrl().contains(this.getBundle(locale).getString("report.sonar.alternative.trigger"));
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("sonar-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private String getProjectUrl() {
        StringBuilder sb = new StringBuilder(this.getSonarUrl()).append("/dashboard/index/").append(this.getProject().getGroupId()).append(":").append(this.getProject().getArtifactId());
        if (this.branch != null) {
            sb.append(":").append(this.branch);
        }
        return sb.toString();
    }

    private String getSonarUrl() {
        if (this.sonarHostURL.endsWith("/")) {
            return this.sonarHostURL.substring(0, this.sonarHostURL.length() - 1);
        }
        return this.sonarHostURL;
    }
}

