/*
 * Decompiled with CFR 0.152.
 */
package nl.geodienstencentrum.maven.plugin.sass.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.StringWriter;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;

public class SCSSLintReportGenerator {
    private final Sink sink;
    private final String description;
    private final File xmlFile;
    private final Log log;

    public SCSSLintReportGenerator(Sink sink, String description, File xmlFile, Log log) {
        this.sink = sink;
        this.description = description;
        this.xmlFile = xmlFile;
        this.log = log;
    }

    public void generateReport() {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.description);
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.rawText(this.translateXML());
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    private String translateXML() {
        String translated = null;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Templates template = factory.newTemplates(new StreamSource(this.getClass().getClassLoader().getResourceAsStream("scss-report.xsl")));
            Transformer xformer = template.newTransformer();
            this.log.info((CharSequence)("Transforming scss-lint xml results file: " + this.xmlFile.getAbsolutePath()));
            StreamSource source = new StreamSource(new FileInputStream(this.xmlFile));
            StringWriter outWriter = new StringWriter();
            StreamResult result = new StreamResult(outWriter);
            xformer.transform(source, result);
            translated = outWriter.toString();
        }
        catch (FileNotFoundException | TransformerConfigurationException e) {
            this.log.error((CharSequence)("Error during xml conversion of " + this.xmlFile), (Throwable)e);
        }
        catch (TransformerException e) {
            SourceLocator locator = e.getLocator();
            int col = locator.getColumnNumber();
            int line = locator.getLineNumber();
            this.log.error((CharSequence)("Error during xml transformation of " + this.xmlFile + "line: " + line + ", col: " + col), (Throwable)e);
        }
        this.log.debug((CharSequence)("Transformed scss-lint xml:\n" + translated));
        return translated;
    }
}

