/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.windowsdot;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sourceforge.plantuml.brotli.BrotliInputStream;

public final class WindowsDotArchive {
    private static WindowsDotArchive singleton = null;
    private Boolean isThereArchive;
    private File exe;

    private WindowsDotArchive() {
    }

    public static final synchronized WindowsDotArchive getInstance() {
        if (singleton == null) {
            singleton = new WindowsDotArchive();
        }
        return singleton;
    }

    public static final String readString(InputStream is) throws IOException {
        int len = WindowsDotArchive.readByte(is);
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append((char)WindowsDotArchive.readByte(is));
        }
        return sb.toString();
    }

    public static final int readNumber(InputStream is) throws IOException {
        int result = WindowsDotArchive.readByte(is);
        result = result * 256 + WindowsDotArchive.readByte(is);
        result = result * 256 + WindowsDotArchive.readByte(is);
        return result;
    }

    private static int readByte(InputStream is) throws IOException {
        return is.read();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extract(File dir) throws IOException {
        InputStream raw = WindowsDotArchive.class.getResourceAsStream("graphviz.dat");
        try (BrotliInputStream is = new BrotliInputStream(raw);){
            while (true) {
                BufferedOutputStream fos;
                block24: {
                    String name;
                    if ((name = WindowsDotArchive.readString(is)).length() == 0) {
                        return;
                    }
                    int size = WindowsDotArchive.readNumber(is);
                    fos = new BufferedOutputStream(new FileOutputStream(new File(dir, name)));
                    Throwable throwable = null;
                    try {
                        for (int i = 0; i < size; ++i) {
                            ((OutputStream)fos).write(is.read());
                        }
                        if (fos == null) continue;
                        if (throwable == null) break block24;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    ((OutputStream)fos).close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            ((OutputStream)fos).close();
                            throw throwable3;
                        }
                    }
                    try {
                        ((OutputStream)fos).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                ((OutputStream)fos).close();
            }
        }
    }

    public synchronized boolean isThereArchive() {
        if (this.isThereArchive == null) {
            try (InputStream raw = WindowsDotArchive.class.getResourceAsStream("graphviz.dat");){
                this.isThereArchive = raw != null;
            }
            catch (Exception e) {
                this.isThereArchive = false;
            }
        }
        return this.isThereArchive;
    }

    public synchronized File getWindowsExeLite() {
        if (!this.isThereArchive()) {
            return null;
        }
        if (this.exe == null) {
            try {
                File tmp = new File(System.getProperty("java.io.tmpdir"), "_graphviz");
                tmp.mkdirs();
                WindowsDotArchive.extract(tmp);
                this.exe = new File(tmp, "dot.exe");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.exe;
    }
}

