/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.html;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.concurrent.Callable;
import nl.talsmasoftware.umldoclet.html.DiagramFile;
import nl.talsmasoftware.umldoclet.html.HtmlFile;
import nl.talsmasoftware.umldoclet.util.FileUtils;

final class Postprocessor
implements Callable<Boolean> {
    private final HtmlFile htmlFile;
    private final DiagramFile umlDiagram;
    private final String relativePath;
    private final String diagramFileName;

    Postprocessor(HtmlFile htmlFile, DiagramFile umlDiagram) {
        this.htmlFile = htmlFile;
        this.umlDiagram = umlDiagram;
        this.relativePath = FileUtils.relativePath(htmlFile.path.toFile(), umlDiagram.diagramFile);
        this.diagramFileName = FileUtils.fileNameOf(this.relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws IOException {
        HtmlFile htmlFile = this.htmlFile;
        synchronized (htmlFile) {
            File tempFile = this.htmlFile.createNewTempFile();
            List<String> html = this.htmlFile.readLines();
            boolean alreadyContainsDiagram = false;
            Inserter inserter = this.umlDiagram.newInserter(this.relativePath);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tempFile)), this.htmlFile.config.htmlCharset());){
                boolean written = false;
                for (String line : html) {
                    if (line.contains(this.diagramFileName)) {
                        alreadyContainsDiagram = true;
                        break;
                    }
                    if (written) {
                        writer.write(System.lineSeparator());
                    }
                    writer.write(inserter.process(line));
                    written = true;
                }
            }
            boolean result = false;
            if (!alreadyContainsDiagram && inserter.inserted) {
                this.htmlFile.replaceBy(tempFile);
                result = true;
            } else if (!tempFile.delete()) {
                throw new IllegalStateException("Could not delete " + tempFile + " after postprocessing!");
            }
            return result;
        }
    }

    static abstract class Inserter {
        protected boolean inserted = false;
        protected String relativePath;

        protected Inserter(String relativePath) {
            this.relativePath = relativePath;
        }

        abstract String process(String var1);
    }
}

