/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.StringTokenizer;

public class TikzFontDistortion {
    private final double magnify;
    private final double distortion;

    private TikzFontDistortion(double magnify, double distortion) {
        this.magnify = magnify;
        this.distortion = distortion;
    }

    public String toString() {
        return this.magnify + ";" + this.distortion;
    }

    public static TikzFontDistortion fromValue(String value) {
        if (value == null) {
            return TikzFontDistortion.getDefault();
        }
        StringTokenizer st = new StringTokenizer(value, ";");
        if (!st.hasMoreElements()) {
            return TikzFontDistortion.getDefault();
        }
        String v1 = st.nextToken();
        if (!st.hasMoreElements()) {
            return TikzFontDistortion.getDefault();
        }
        String v2 = st.nextToken();
        if (v1.matches("[\\d.]+") && v2.matches("[-\\d.]+")) {
            return new TikzFontDistortion(Double.parseDouble(v1), Double.parseDouble(v2));
        }
        return TikzFontDistortion.getDefault();
    }

    public static TikzFontDistortion getDefault() {
        return new TikzFontDistortion(1.2, 4.0);
    }

    public final double getMagnify() {
        return this.magnify;
    }

    public final double getDistortion() {
        return this.distortion;
    }
}

