/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileSwitchWithDiamonds;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileSwitchWithManyLinks
extends FtileSwitchWithDiamonds {
    private final Rainbow arrowColor;
    private final double margin = 10.0;

    public FtileSwitchWithManyLinks(List<Ftile> tiles, List<Branch> branches, Swimlane in, Ftile diamond1, Ftile diamond2, StringBounder stringBounder, Rainbow arrowColor) {
        super(tiles, branches, in, diamond1, diamond2, stringBounder);
        this.arrowColor = arrowColor;
    }

    @Override
    protected double getYdelta1a(StringBounder stringBounder) {
        double max = 10.0;
        for (Branch branch : this.branches) {
            max = Math.max(max, branch.getTextBlockPositive().calculateDimension(stringBounder).getHeight());
        }
        if (this.mode == FtileSwitchWithDiamonds.Mode.BIG_DIAMOND) {
            double diamondHeight = this.diamond1.calculateDimension(stringBounder).getHeight();
            max += diamondHeight / 2.0;
        }
        return max + 10.0;
    }

    public Ftile addLinks(StringBounder stringBounder) {
        ArrayList<Connection> conns = new ArrayList<Connection>();
        this.addIngoingArrows(conns);
        this.addOutgoingArrows(stringBounder, conns);
        return FtileUtils.addConnection((Ftile)this, conns);
    }

    private void addIngoingArrows(List<Connection> conns) {
        conns.add(new ConnectionHorizontalThenVertical((Ftile)this.tiles.get(0), (Branch)this.branches.get(0)));
        conns.add(new ConnectionHorizontalThenVertical((Ftile)this.tiles.get(this.tiles.size() - 1), (Branch)this.branches.get(this.tiles.size() - 1)));
        for (int i = 1; i < this.tiles.size() - 1; ++i) {
            Ftile tile = (Ftile)this.tiles.get(i);
            conns.add(new ConnectionVerticalTop(tile, (Branch)this.branches.get(i)));
        }
    }

    private void addOutgoingArrows(StringBounder stringBounder, List<Connection> conns) {
        int firstOutgoingArrow = this.getFirstOutgoingArrow(stringBounder);
        int lastOutgoingArrow = this.getLastOutgoingArrow(stringBounder);
        if (firstOutgoingArrow < this.tiles.size()) {
            conns.add(new ConnectionVerticalThenHorizontal((Ftile)this.tiles.get(firstOutgoingArrow), ((Branch)this.branches.get(firstOutgoingArrow)).getTextBlockSpecial()));
        }
        if (lastOutgoingArrow > 0) {
            conns.add(new ConnectionVerticalThenHorizontal((Ftile)this.tiles.get(lastOutgoingArrow), ((Branch)this.branches.get(lastOutgoingArrow)).getTextBlockSpecial()));
        }
        for (int i = firstOutgoingArrow + 1; i < lastOutgoingArrow; ++i) {
            Ftile tile = (Ftile)this.tiles.get(i);
            if (!tile.calculateDimension(stringBounder).hasPointOut()) continue;
            conns.add(new ConnectionVerticalBottom(tile, ((Branch)this.branches.get(i)).getTextBlockSpecial()));
        }
    }

    private int getFirstOutgoingArrow(StringBounder stringBounder) {
        for (int i = 0; i < this.tiles.size() - 1; ++i) {
            Ftile tile = (Ftile)this.tiles.get(i);
            if (!tile.calculateDimension(stringBounder).hasPointOut()) continue;
            return i;
        }
        return this.tiles.size();
    }

    private int getLastOutgoingArrow(StringBounder stringBounder) {
        for (int i = this.tiles.size() - 1; i >= 0; --i) {
            Ftile tile = (Ftile)this.tiles.get(i);
            if (!tile.calculateDimension(stringBounder).hasPointOut()) continue;
            return i;
        }
        return -1;
    }

    class ConnectionHorizontalThenVertical
    extends AbstractConnection {
        private final Branch branch;

        public ConnectionHorizontalThenVertical(Ftile tile, Branch branch) {
            super(FtileSwitchWithManyLinks.this.diamond1, tile);
            this.branch = branch;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            Snake snake = Snake.create(FtileSwitchWithManyLinks.this.skinParam(), FtileSwitchWithManyLinks.this.arrowColor, FtileSwitchWithManyLinks.this.skinParam().arrows().asToDown()).withLabel(this.branch.getTextBlockPositive(), this.arrowHorizontalAlignment());
            snake.addPoint(x1, y1);
            if (this.isLast() && p1.getX() > p2.getX()) {
                FtileGeometry dimDiamond1 = FtileSwitchWithManyLinks.this.diamond1.calculateDimension(stringBounder);
                snake.addPoint(x1 + 12.0, y1);
                snake.addPoint(x1 + 12.0, y1 + dimDiamond1.getHeight());
                snake.addPoint(x2, y1 + dimDiamond1.getHeight());
            } else {
                snake.addPoint(x2, y1);
            }
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            XPoint2D pt;
            FtileGeometry dimDiamond1 = FtileSwitchWithManyLinks.this.diamond1.calculateDimension(stringBounder);
            if (this.getFtile2() == FtileSwitchWithManyLinks.this.tiles.get(0)) {
                pt = dimDiamond1.getPointD();
            } else if (this.isLast()) {
                pt = dimDiamond1.getPointB();
            } else {
                throw new IllegalStateException();
            }
            return FtileSwitchWithManyLinks.this.getTranslateDiamond1(stringBounder).getTranslated(pt);
        }

        private boolean isLast() {
            return this.getFtile2() == FtileSwitchWithManyLinks.this.tiles.get(FtileSwitchWithManyLinks.this.tiles.size() - 1);
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            return FtileSwitchWithManyLinks.this.getTranslateOf(this.getFtile2(), stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }
    }

    class ConnectionVerticalTop
    extends AbstractConnection {
        private final Branch branch;

        public ConnectionVerticalTop(Ftile tile, Branch branch) {
            super(FtileSwitchWithManyLinks.this.diamond1, tile);
            this.branch = branch;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry dimDiamond1 = FtileSwitchWithManyLinks.this.diamond1.calculateDimension(stringBounder);
            UTranslate translateDiamond1 = FtileSwitchWithManyLinks.this.getTranslateDiamond1(stringBounder);
            XPoint2D p1b = translateDiamond1.getTranslated(dimDiamond1.getPointB());
            XPoint2D p1c = translateDiamond1.getTranslated(dimDiamond1.getPointC());
            XPoint2D p1d = translateDiamond1.getTranslated(dimDiamond1.getPointD());
            XPoint2D p2 = this.getP2(stringBounder);
            double x2 = p2.getX();
            double y2 = p2.getY();
            Snake snake = Snake.create(FtileSwitchWithManyLinks.this.skinParam(), FtileSwitchWithManyLinks.this.arrowColor, FtileSwitchWithManyLinks.this.skinParam().arrows().asToDown()).withLabel(this.branch.getTextBlockPositive(), VerticalAlignment.CENTER);
            if (x2 < p1d.getX() - 10.0 || x2 > p1b.getX() + 10.0) {
                snake.addPoint(x2, p1d.getY());
                snake.addPoint(x2, y2);
            } else {
                double x1 = p1c.getX();
                double y1 = p1c.getY();
                double ym = (y1 * 2.0 + y2) / 3.0;
                snake.addPoint(x1, y1);
                snake.addPoint(x1, ym);
                snake.addPoint(x2, ym);
                snake.addPoint(x2, y2);
            }
            ug.draw(snake);
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            return FtileSwitchWithManyLinks.this.getTranslateOf(this.getFtile2(), stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }
    }

    class ConnectionVerticalThenHorizontal
    extends AbstractConnection {
        private final TextBlock outLabel;

        public ConnectionVerticalThenHorizontal(Ftile tile, TextBlock outLabel) {
            super(tile, FtileSwitchWithManyLinks.this.diamond2);
            this.outLabel = outLabel;
        }

        @Override
        public void drawU(UGraphic ug) {
            Direction direction;
            UPolygon arrow;
            XPoint2D p2;
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry geo = this.getFtile1().calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return;
            }
            XPoint2D p1 = this.getP1(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            FtileGeometry dimDiamond2 = FtileSwitchWithManyLinks.this.diamond2.calculateDimension(stringBounder);
            XPoint2D ptA = FtileSwitchWithManyLinks.this.getTranslateDiamond2(stringBounder).getTranslated(dimDiamond2.getPointA());
            XPoint2D ptB = FtileSwitchWithManyLinks.this.getTranslateDiamond2(stringBounder).getTranslated(dimDiamond2.getPointB());
            XPoint2D ptD = FtileSwitchWithManyLinks.this.getTranslateDiamond2(stringBounder).getTranslated(dimDiamond2.getPointD());
            if (x1 < ptD.getX()) {
                p2 = ptD;
                arrow = FtileSwitchWithManyLinks.this.skinParam().arrows().asToRight();
                direction = Direction.RIGHT;
            } else if (x1 > ptB.getX()) {
                p2 = ptB;
                arrow = FtileSwitchWithManyLinks.this.skinParam().arrows().asToLeft();
                direction = Direction.LEFT;
            } else {
                p2 = ptA;
                arrow = FtileSwitchWithManyLinks.this.skinParam().arrows().asToDown();
                direction = Direction.DOWN;
            }
            double x2 = p2.getX();
            double y2 = p2.getY();
            Snake snake = Snake.create(FtileSwitchWithManyLinks.this.skinParam(), FtileSwitchWithManyLinks.this.arrowColor, arrow).withLabel(this.outLabel, VerticalAlignment.CENTER);
            snake.addPoint(x1, y1);
            if (direction == Direction.LEFT && x2 > x1 - 10.0) {
                snake.addPoint(x1, y2 - 8.0);
                snake.addPoint(x1 + 12.0, y2 - 8.0);
                snake.addPoint(x1 + 12.0, y2);
            } else {
                snake.addPoint(x1, y2);
            }
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            return FtileSwitchWithManyLinks.this.getTranslateOf(this.getFtile1(), stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }
    }

    class ConnectionVerticalBottom
    extends AbstractConnection {
        private final TextBlock outLabel;

        public ConnectionVerticalBottom(Ftile tile, TextBlock textBlock) {
            super(tile, FtileSwitchWithManyLinks.this.diamond2);
            this.outLabel = textBlock;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            FtileGeometry dimDiamond2 = FtileSwitchWithManyLinks.this.diamond2.calculateDimension(stringBounder);
            UTranslate translateDiamond2 = FtileSwitchWithManyLinks.this.getTranslateDiamond2(stringBounder);
            XPoint2D p2a = translateDiamond2.getTranslated(dimDiamond2.getPointA());
            XPoint2D p2b = translateDiamond2.getTranslated(dimDiamond2.getPointB());
            XPoint2D p2d = translateDiamond2.getTranslated(dimDiamond2.getPointD());
            FtileGeometry dimDiamond1 = FtileSwitchWithManyLinks.this.diamond1.calculateDimension(stringBounder);
            UTranslate translateDiamond1 = FtileSwitchWithManyLinks.this.getTranslateDiamond1(stringBounder);
            XPoint2D p1b = translateDiamond1.getTranslated(dimDiamond1.getPointB());
            XPoint2D p1c = translateDiamond1.getTranslated(dimDiamond1.getPointC());
            XPoint2D p1d = translateDiamond1.getTranslated(dimDiamond1.getPointD());
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2a.getX();
            double y2 = p2a.getY();
            double ym = (y1 + y2) / 2.0;
            Snake snake = Snake.create(FtileSwitchWithManyLinks.this.skinParam(), FtileSwitchWithManyLinks.this.arrowColor, FtileSwitchWithManyLinks.this.skinParam().arrows().asToDown()).withLabel(this.outLabel, VerticalAlignment.CENTER);
            if (x1 < p1d.getX() - 10.0 || x1 > p1b.getX() + 10.0) {
                snake.addPoint(x1, y1);
                snake.addPoint(x1, p2d.getY());
            } else {
                snake.addPoint(x1, y1);
                snake.addPoint(x1, ym);
                snake.addPoint(x2, ym);
                snake.addPoint(x2, y2);
            }
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            return FtileSwitchWithManyLinks.this.getTranslateOf(this.getFtile1(), stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }
    }
}

