/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.baraye;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.baraye.CucaDiagram;
import net.sourceforge.plantuml.baraye.EntityFactory;
import net.sourceforge.plantuml.baraye.EntityUtils;
import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.baraye.IGroup;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.CucaNote;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositioned;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereostyles;
import net.sourceforge.plantuml.cucadiagram.Stereotag;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.Neighborhood;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.USymbols;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Kal;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.SingleStrategy;
import net.sourceforge.plantuml.svek.image.EntityImageStateCommon;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public final class EntityImp
implements ILeaf,
IGroup {
    private final EntityFactory entityFactory;
    private Code code;
    private Ident ident;
    private Url url;
    private final Bodier bodier;
    private final String uid;
    private Display display = Display.empty();
    private DisplayPositioned legend = null;
    private LeafType leafType;
    private Stereotype stereotype;
    private Stereostyles stereostyles = Stereostyles.NONE;
    private String generic;
    private IGroup parentContainer;
    private Code namespace;
    private GroupType groupType;
    private Margins margins = Margins.NONE;
    private final Collection<String> portShortNames = new HashSet<String>();
    private int xposition;
    private IEntityImage svekImage;
    private USymbol symbol;
    private final int rawLayout;
    private char concurrentSeparator;
    private LineLocation codeLine;
    private Set<Stereotag> tags = new LinkedHashSet<Stereotag>();
    private final List<CucaNote> notesTop = new ArrayList<CucaNote>();
    private final List<CucaNote> notesBottom = new ArrayList<CucaNote>();
    private Neighborhood neighborhood;
    private final Map<String, Display> tips = new LinkedHashMap<String, Display>();
    private Colors colors = Colors.empty();
    private VisibilityModifier visibility;
    private boolean intricated;
    private IGroup originalGroup;
    private boolean together;
    private final Map<Direction, List<Kal>> kals = new EnumMap<Direction, List<Kal>>(Direction.class);
    private boolean isStatic;

    @Override
    public void addNote(Display note, Position position, Colors colors) {
        if (position == Position.TOP) {
            this.notesTop.add(CucaNote.build(note, position, colors));
        } else if (position == Position.BOTTOM) {
            this.notesBottom.add(CucaNote.build(note, position, colors));
        }
    }

    @Override
    public List<CucaNote> getNotes(Position position) {
        if (position == Position.TOP) {
            return Collections.unmodifiableList(this.notesTop);
        }
        if (position == Position.BOTTOM) {
            return Collections.unmodifiableList(this.notesBottom);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void addStereotag(Stereotag tag) {
        this.tags.add(tag);
    }

    @Override
    public Set<Stereotag> stereotags() {
        return Collections.unmodifiableSet(this.tags);
    }

    private EntityImp(Ident ident, EntityFactory entityFactory, Code code, Bodier bodier, IGroup parentContainer, String namespaceSeparator, int rawLayout) {
        this.ident = Objects.requireNonNull(ident);
        this.uid = StringUtils.getUid("cl", entityFactory.getDiagram().getUniqueSequence());
        if (entityFactory.namespaceSeparator.V1972()) {
            code = ident;
        }
        this.code = Objects.requireNonNull(code);
        this.entityFactory = entityFactory;
        this.bodier = bodier;
        this.parentContainer = parentContainer;
        this.rawLayout = rawLayout;
    }

    public EntityImp(Ident ident, Code code, EntityFactory entityFactory, Bodier bodier, IGroup parentContainer, LeafType leafType, String namespaceSeparator, int rawLayout) {
        this(Objects.requireNonNull(ident), entityFactory, code, bodier, parentContainer, namespaceSeparator, rawLayout);
        this.leafType = leafType;
    }

    public EntityImp(Ident ident, Code code, EntityFactory entityFactory, Bodier bodier, IGroup parentContainer, GroupType groupType, Code namespace, String namespaceSeparator, int rawLayout) {
        this(Objects.requireNonNull(ident), entityFactory, code, bodier, parentContainer, namespaceSeparator, rawLayout);
        ident.checkSameAs(code, namespaceSeparator, entityFactory.namespaceSeparator);
        this.groupType = groupType;
        this.namespace = namespace;
    }

    @Override
    public void setContainer(IGroup container) {
        this.checkNotGroup();
        this.parentContainer = Objects.requireNonNull(container);
    }

    @Override
    public LeafType getLeafType() {
        return this.leafType;
    }

    @Override
    public boolean muteToType(LeafType newType, USymbol newSymbol) {
        this.checkNotGroup();
        Objects.requireNonNull(newType);
        if (this.leafType != LeafType.STILL_UNKNOWN) {
            if (newType == this.leafType) {
                return true;
            }
            if (this.leafType != LeafType.ANNOTATION && this.leafType != LeafType.ABSTRACT_CLASS && this.leafType != LeafType.CLASS && this.leafType != LeafType.ENUM && this.leafType != LeafType.INTERFACE) {
                return false;
            }
            if (newType != LeafType.ANNOTATION && newType != LeafType.ABSTRACT_CLASS && newType != LeafType.CLASS && newType != LeafType.ENUM && newType != LeafType.INTERFACE && newType != LeafType.OBJECT) {
                return false;
            }
        }
        if (this.leafType == LeafType.CLASS && newType == LeafType.OBJECT) {
            this.bodier.muteClassToObject();
        }
        this.leafType = newType;
        this.symbol = newSymbol;
        return true;
    }

    @Override
    public Code getCode() {
        return this.code;
    }

    @Override
    public String getCodeGetName() {
        return this.getCode().getName();
    }

    @Override
    public Ident getIdent() {
        return this.ident;
    }

    @Override
    public Display getDisplay() {
        if (this.intricated) {
            return this.entityFactory.getIntricatedDisplay(this.ident);
        }
        return this.display;
    }

    @Override
    public void setDisplay(Display display) {
        this.display = display;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public Stereotype getStereotype() {
        return this.stereotype;
    }

    @Override
    public final void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    @Override
    public final IGroup getParentContainer() {
        return this.entityFactory.getParentContainer(this.ident, this.parentContainer);
    }

    public String toString() {
        if (this.entityFactory.namespaceSeparator.V1972()) {
            return this.getUid() + " " + this.ident + " " + this.display + "(" + this.leafType + ")[" + this.groupType + "]";
        }
        return "EntityImpl " + this.code + this.ident + " " + this.display + "(" + this.leafType + ")[" + this.groupType + "] " + this.getUid();
    }

    @Override
    public final Url getUrl99() {
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        if (!Display.isNull(this.display) && this.display.hasUrl()) {
            return true;
        }
        if (this.bodier.hasUrl()) {
            return true;
        }
        return this.url != null;
    }

    @Override
    public final void addUrl(Url url) {
        this.url = url;
    }

    @Override
    public final Margins getMargins() {
        this.checkNotGroup();
        return this.margins;
    }

    public final void ensureMargins(Margins newMargins) {
        this.margins = this.margins.merge(newMargins);
    }

    @Override
    public int getXposition() {
        this.checkNotGroup();
        return this.xposition;
    }

    @Override
    public void setXposition(int pos) {
        this.checkNotGroup();
        this.xposition = pos;
    }

    @Override
    public final IEntityImage getSvekImage() {
        this.checkNotGroup();
        return this.svekImage;
    }

    @Override
    public final void setSvekImage(IEntityImage svekImage) {
        this.checkNotGroup();
        this.svekImage = svekImage;
    }

    @Override
    public final void setGeneric(String generic) {
        this.checkNotGroup();
        this.generic = generic;
    }

    @Override
    public final String getGeneric() {
        this.checkNotGroup();
        return this.generic;
    }

    @Override
    public Bodier getBodier() {
        return this.bodier;
    }

    @Override
    public EntityPosition getEntityPosition() {
        if (this.leafType == LeafType.PORTIN) {
            return EntityPosition.PORTIN;
        }
        if (this.leafType == LeafType.PORTOUT) {
            return EntityPosition.PORTOUT;
        }
        if (this.leafType != LeafType.STATE) {
            return EntityPosition.NORMAL;
        }
        if (this.getParentContainer() instanceof GroupRoot) {
            return EntityPosition.NORMAL;
        }
        Stereotype stereotype = this.getStereotype();
        if (stereotype == null) {
            return EntityPosition.NORMAL;
        }
        return EntityPosition.fromStereotype(stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR));
    }

    private void checkGroup() {
        if (!this.isGroup()) {
            throw new UnsupportedOperationException();
        }
    }

    private void checkNotGroup() {
        if (this.isGroup()) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean containsLeafRecurse(ILeaf leaf) {
        if (Objects.requireNonNull(leaf).isGroup()) {
            throw new IllegalArgumentException();
        }
        this.checkGroup();
        if (leaf.getParentContainer() == this) {
            return true;
        }
        for (IGroup child : this.getChildren()) {
            if (!child.containsLeafRecurse(leaf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ILeaf> getLeafsDirect() {
        this.checkGroup();
        ArrayList<ILeaf> result = new ArrayList<ILeaf>();
        for (ILeaf ent : this.entityFactory.leafs()) {
            if (ent.isGroup()) {
                throw new IllegalStateException();
            }
            if (ent.getParentContainer() != this) continue;
            result.add(ent);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Collection<IGroup> getChildren() {
        this.checkGroup();
        ArrayList<IGroup> result = new ArrayList<IGroup>();
        for (IGroup g : this.entityFactory.groups()) {
            if (g == this || g.getParentContainer() != this) continue;
            result.add(g);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public void moveEntitiesTo(IGroup dest) {
        if (this.entityFactory.namespaceSeparator.V1972()) {
            this.moveEntitiesTo1972(dest);
            return;
        }
        this.checkGroup();
        if (!dest.isGroup()) {
            throw new UnsupportedOperationException();
        }
        for (ILeaf ent : this.getLeafsDirect()) {
            ((EntityImp)ent).parentContainer = dest;
        }
        Iterator<IEntity> iterator = dest.getChildren().iterator();
        if (iterator.hasNext()) {
            IGroup g = (IGroup)iterator.next();
            throw new IllegalStateException();
        }
        for (IGroup g : this.getChildren()) {
            if (g == dest) continue;
            ((EntityImp)g).parentContainer = dest;
        }
    }

    private void moveEntitiesTo1972(IGroup dest) {
        Ident ident;
        this.checkGroup();
        if (!dest.isGroup()) {
            throw new UnsupportedOperationException();
        }
        Ident firstIdent = this.getIdent();
        Ident destIdent = dest.getIdent();
        if (!destIdent.startsWith(firstIdent)) {
            throw new UnsupportedOperationException();
        }
        for (ILeaf iLeaf : new ArrayList<ILeaf>(this.entityFactory.leafs2())) {
            ident = iLeaf.getIdent();
            if (ident.equals(firstIdent) || !ident.startsWith(firstIdent) || ident.startsWith(destIdent)) continue;
            this.entityFactory.leafs2.remove(ident);
            ((EntityImp)iLeaf).ident = ident = ident.move(firstIdent, destIdent);
            ((EntityImp)iLeaf).code = ident;
            this.entityFactory.leafs2.put(ident, iLeaf);
        }
        for (IGroup iGroup : new ArrayList<IGroup>(this.entityFactory.groups2())) {
            ident = iGroup.getIdent();
            if (ident.equals(firstIdent) || !ident.startsWith(firstIdent) || ident.startsWith(destIdent)) continue;
            this.entityFactory.groups2.remove(ident);
            ((EntityImp)iGroup).ident = ident = ident.move(firstIdent, destIdent);
            ((EntityImp)iGroup).code = ident;
            this.entityFactory.groups2.put(ident, iGroup);
        }
    }

    @Override
    public int size() {
        this.checkGroup();
        return this.getLeafsDirect().size();
    }

    @Override
    public GroupType getGroupType() {
        this.checkGroup();
        return this.groupType;
    }

    @Override
    public Code getNamespace() {
        this.checkGroup();
        return this.namespace;
    }

    @Override
    public PackageStyle getPackageStyle() {
        this.checkGroup();
        if (this.stereotype == null) {
            return null;
        }
        return this.stereotype.getPackageStyle();
    }

    @Override
    public boolean isGroup() {
        if (this.groupType != null && this.leafType != null) {
            throw new IllegalStateException();
        }
        assert (this.groupType == null || this.leafType == null);
        if (this.groupType != null) {
            return true;
        }
        if (this.leafType != null) {
            return false;
        }
        throw new IllegalStateException();
    }

    @Override
    public void overrideImage(IEntityImage img, LeafType leafType) {
        this.checkGroup();
        this.svekImage = img;
        this.url = null;
        for (Link link : new ArrayList<Link>(this.entityFactory.getLinks())) {
            if (!EntityUtils.isPureInnerLink12(this, link)) continue;
            this.entityFactory.removeLink(link);
        }
        if (this.entityFactory.namespaceSeparator.V1972()) {
            this.entityFactory.removeGroup(this.getIdent());
            for (ILeaf ent : new ArrayList<ILeaf>(this.entityFactory.leafs())) {
                if (this == ent || !this.getIdent().equals(ent.getIdent().parent())) continue;
                this.entityFactory.removeLeaf(ent.getIdent());
            }
        } else {
            this.entityFactory.removeGroup(this.getCodeGetName());
            for (ILeaf ent : new ArrayList<ILeaf>(this.entityFactory.leafs())) {
                if (this == ent || this != ent.getParentContainer()) continue;
                this.entityFactory.removeLeaf(ent.getCodeGetName());
            }
        }
        this.entityFactory.addLeaf(this);
        this.groupType = null;
        this.leafType = leafType;
    }

    public void muteToGroup(Code namespaceNew, GroupType groupType, IGroup parentContainer) {
        this.checkNotGroup();
        if (!parentContainer.isGroup()) {
            throw new IllegalArgumentException();
        }
        this.namespace = namespaceNew;
        this.groupType = groupType;
        this.leafType = null;
        this.parentContainer = parentContainer;
    }

    @Override
    public USymbol getUSymbol() {
        if (this.getLeafType() == LeafType.CIRCLE) {
            return USymbols.INTERFACE;
        }
        return this.symbol;
    }

    @Override
    public void setUSymbol(USymbol symbol) {
        this.symbol = symbol;
    }

    @Override
    public SingleStrategy getSingleStrategy() {
        return SingleStrategy.SQUARE;
    }

    @Override
    public boolean isHidden() {
        if (this.parentContainer != null && this.parentContainer.isHidden()) {
            return true;
        }
        return this.isHiddenInternal();
    }

    private boolean isHiddenInternal() {
        if (this.isGroup()) {
            if (this.entityFactory.isHidden(this)) {
                return true;
            }
            if (this.getLeafsDirect().size() == 0) {
                return false;
            }
            for (ILeaf leaf : this.getLeafsDirect()) {
                if (((EntityImp)leaf).isHiddenInternal()) continue;
                return false;
            }
            for (IGroup g : this.getChildren()) {
                if (((EntityImp)g).isHiddenInternal()) continue;
                return false;
            }
            return true;
        }
        return this.entityFactory.isHidden(this);
    }

    @Override
    public boolean isRemoved() {
        if (this.parentContainer != null && this.parentContainer.isRemoved()) {
            return true;
        }
        return this.isRemovedInternal();
    }

    private boolean isRemovedInternal() {
        if (this.isGroup()) {
            if (this.entityFactory.isRemoved(this)) {
                return true;
            }
            if (this.getLeafsDirect().size() == 0 && this.getChildren().size() == 0) {
                return false;
            }
            for (ILeaf leaf : this.getLeafsDirect()) {
                if (((EntityImp)leaf).isRemovedInternal()) continue;
                return false;
            }
            for (IGroup g : this.getChildren()) {
                if (((EntityImp)g).isRemovedInternal()) continue;
                return false;
            }
            return true;
        }
        return this.entityFactory.isRemoved(this);
    }

    @Override
    public boolean isAloneAndUnlinked() {
        if (this.isGroup()) {
            return false;
        }
        for (Link link : this.entityFactory.getLinks()) {
            ILeaf other;
            boolean removed;
            if (!link.contains(this) || (removed = this.entityFactory.isRemovedIgnoreUnlinked(other = (ILeaf)link.getOther(this))) || link.getType().isInvisible()) continue;
            return false;
        }
        return true;
    }

    private FontParam getTitleFontParam() {
        return this.getGroupType() == GroupType.STATE ? FontParam.STATE : FontParam.PACKAGE;
    }

    @Override
    public FontConfiguration getFontConfigurationForTitle(ISkinParam skinParam) {
        FontParam fontParam = this.getTitleFontParam();
        HColor fontHtmlColor = skinParam.getFontHtmlColor(this.getStereotype(), fontParam, FontParam.PACKAGE);
        UFont font = skinParam.getFont(this.getStereotype(), true, fontParam, FontParam.PACKAGE);
        FontConfiguration fontConfiguration = FontConfiguration.create(font, fontHtmlColor, skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink(), skinParam.getTabSize());
        return fontConfiguration;
    }

    @Override
    public final int getRawLayout() {
        return this.rawLayout;
    }

    @Override
    public char getConcurrentSeparator() {
        return this.concurrentSeparator;
    }

    @Override
    public void setConcurrentSeparator(char separator) {
        this.concurrentSeparator = separator;
    }

    @Override
    public void setNeighborhood(Neighborhood neighborhood) {
        this.neighborhood = neighborhood;
    }

    @Override
    public Neighborhood getNeighborhood() {
        return this.neighborhood;
    }

    @Override
    public void putTip(String member, Display display) {
        this.tips.put(member, display);
    }

    @Override
    public Map<String, Display> getTips() {
        return Collections.unmodifiableMap(this.tips);
    }

    @Override
    public Colors getColors() {
        return this.colors;
    }

    @Override
    public void setColors(Colors colors) {
        this.colors = colors;
    }

    @Override
    public void setSpecificColorTOBEREMOVED(ColorType type, HColor color) {
        if (color != null) {
            this.colors = this.colors.add(type, color);
        }
    }

    @Override
    public Collection<String> getPortShortNames() {
        this.checkNotGroup();
        return Collections.unmodifiableCollection(this.portShortNames);
    }

    @Override
    public void addPortShortName(String portShortName) {
        this.portShortNames.add(portShortName);
    }

    @Override
    public void setVisibilityModifier(VisibilityModifier visibility) {
        this.visibility = visibility;
    }

    @Override
    public VisibilityModifier getVisibilityModifier() {
        return this.visibility;
    }

    @Override
    public void setLegend(DisplayPositioned legend) {
        this.checkGroup();
        this.legend = legend;
    }

    @Override
    public DisplayPositioned getLegend() {
        return this.legend;
    }

    public void setIntricated(boolean intricated) {
        this.intricated = intricated;
    }

    public void setOriginalGroup(IGroup originalGroup) {
        this.originalGroup = originalGroup;
        this.legend = originalGroup.getLegend();
    }

    public IGroup getOriginalGroup() {
        return this.originalGroup;
    }

    @Override
    public void setThisIsTogether() {
        this.together = true;
    }

    @Override
    public String getCodeLine() {
        if (this.codeLine == null) {
            return null;
        }
        return "" + this.codeLine.getPosition();
    }

    @Override
    public void setCodeLine(LineLocation codeLine) {
        this.codeLine = codeLine;
    }

    @Override
    public void setStereostyle(String stereo) {
        this.stereostyles = Stereostyles.build(stereo);
    }

    @Override
    public Stereostyles getStereostyles() {
        return this.stereostyles;
    }

    public void addKal(Kal kal) {
        Direction position = kal.getPosition();
        List<Kal> list = this.kals.get((Object)position);
        if (list == null) {
            list = new ArrayList<Kal>();
            this.kals.put(position, list);
        }
        list.add(kal);
    }

    public List<Kal> getKals(Direction position) {
        List<Kal> result = this.kals.get((Object)position);
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    public CucaDiagram getDiagram() {
        return this.entityFactory.getDiagram();
    }

    @Override
    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public TextBlock getStateHeader(ISkinParam skinParam) {
        this.checkGroup();
        Style style = EntityImageStateCommon.getStyleStateHeader(this, skinParam);
        List<CharSequence> details = this.getBodier().getRawBody();
        if (details.size() == 0) {
            return new TextBlockEmpty();
        }
        if (style == null) {
            throw new IllegalArgumentException();
        }
        FontConfiguration fontConfiguration = FontConfiguration.create(skinParam, style);
        Display display = null;
        for (CharSequence s : details) {
            if (display == null) {
                display = Display.getWithNewlines(s.toString());
                continue;
            }
            display = display.addAll(Display.getWithNewlines(s.toString()));
        }
        return display.create(fontConfiguration, HorizontalAlignment.LEFT, skinParam);
    }
}

