/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.UrlMode;
import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArg;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotag;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public final class CommandFactoryTipOnEntity
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private final IRegex partialPattern;
    private final String key;

    public CommandFactoryTipOnEntity(String key, IRegex partialPattern) {
        this.partialPattern = partialPattern;
        this.key = key;
    }

    private RegexConcat getRegexConcatMultiLine(IRegex partialPattern, boolean withBracket) {
        if (withBracket) {
            return RegexConcat.build(CommandFactoryTipOnEntity.class.getName() + this.key + withBracket, RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("of"), RegexLeaf.spaceOneOrMore(), partialPattern, RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
        }
        return RegexConcat.build(CommandFactoryTipOnEntity.class.getName() + this.key + withBracket, RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("of"), RegexLeaf.spaceOneOrMore(), partialPattern, RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public Command<AbstractEntityDiagram> createSingleLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Command<AbstractEntityDiagram> createMultiLine(final boolean withBracket) {
        return new CommandMultilines2<AbstractEntityDiagram>((IRegex)this.getRegexConcatMultiLine(this.partialPattern, withBracket), MultilinesStrategy.KEEP_STARTING_QUOTE, Trim.BOTH){

            @Override
            public String getPatternEnd() {
                if (withBracket) {
                    return "^(\\})$";
                }
                return "^[%s]*(end[%s]?note)$";
            }

            @Override
            protected CommandExecutionResult executeNow(AbstractEntityDiagram system, BlocLines lines) throws NoSuchColorException {
                RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                Url url = null;
                if (line0.get("URL", 0) != null) {
                    UrlBuilder urlBuilder = new UrlBuilder(system.getSkinParam().getValue("topurl"), UrlMode.STRICT);
                    url = urlBuilder.getUrl(line0.get("URL", 0));
                }
                return CommandFactoryTipOnEntity.this.executeInternal(line0, system, url, lines);
            }
        };
    }

    private CommandExecutionResult executeInternal(RegexResult line0, AbstractEntityDiagram diagram, Url url, BlocLines lines) throws NoSuchColorException {
        String pos = line0.get("POSITION", 0);
        String idShort = line0.get("ENTITY", 0);
        Ident identShort = diagram.buildLeafIdent(idShort);
        Ident codeShort = diagram.V1972() ? identShort : diagram.buildCode(idShort);
        String member = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(line0.get("ENTITY", 1));
        if (codeShort == null) {
            assert (false);
            return CommandExecutionResult.error("Nothing to note to");
        }
        IEntity cl1 = diagram.getOrCreateLeaf(identShort, codeShort, null, null);
        Position position = Position.valueOf(StringUtils.goUpperCase(pos)).withRankdir(diagram.getSkinParam().getRankdir());
        Ident identTip = diagram.buildLeafIdent(idShort + "$$$" + position.name());
        IEntity tips = diagram.getLeafStrict(identTip);
        if (tips == null) {
            tips = diagram.getOrCreateLeaf(identTip, identTip.toCode(diagram), LeafType.TIPS, null);
            LinkType type = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getInvisible();
            Link link = position == Position.RIGHT ? new Link(diagram.getIEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), cl1, tips, type, LinkArg.noDisplay(1)) : new Link(diagram.getIEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), tips, cl1, type, LinkArg.noDisplay(1));
            diagram.addLink(link);
        }
        tips.putTip(member, lines.toDisplay());
        Colors colors = CommandFactoryTipOnEntity.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
        String stereotypeString = line0.get("STEREO", 0);
        Stereotype stereotype = null;
        if (stereotypeString != null) {
            stereotype = Stereotype.build(stereotypeString);
            colors = colors.applyStereotypeForNote(stereotype, diagram.getSkinParam(), ColorParam.noteBackground, ColorParam.noteBorder);
        }
        if (stereotypeString != null) {
            tips.setStereotype(stereotype);
        }
        tips.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

