/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.atom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.creole.Position;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class AtomTable
extends AbstractAtom
implements Atom {
    private final List<Line> lines = new ArrayList<Line>();
    private final Map<Atom, Position> positions = new HashMap<Atom, Position>();
    private final HColor lineColor;

    public AtomTable(HColor lineColor) {
        this.lineColor = lineColor;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        this.initMap(stringBounder);
        double width = this.getEndingX(this.getNbCols() - 1);
        double height = this.getEndingY(this.getNbLines() - 1);
        return new XDimension2D(width, height);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        this.initMap(ug.getStringBounder());
        for (int i = 0; i < this.getNbLines(); ++i) {
            double x2;
            double x1;
            Line line = this.lines.get(i);
            if (line.lineBackColor != null) {
                double y1 = this.getStartingY(i);
                double y2 = this.getStartingY(i + 1);
                x1 = this.getStartingX(0);
                x2 = this.getStartingX(this.getNbCols());
                ug.apply(HColors.none()).apply(line.lineBackColor.bg()).apply(new UTranslate(x1, y1)).draw(new URectangle(x2 - x1, y2 - y1));
            }
            for (int j = 0; j < this.getNbCols(); ++j) {
                if (j >= line.cells.size()) continue;
                Atom cell = (Atom)line.cells.get(j);
                HorizontalAlignment align = HorizontalAlignment.LEFT;
                if (cell instanceof SheetBlock1) {
                    align = ((SheetBlock1)cell).getCellAlignment();
                }
                HColor cellBackColor = (HColor)line.cellsBackColor.get(j);
                x1 = this.getStartingX(j);
                x2 = this.getStartingX(j + 1);
                double cellWidth = x2 - x1;
                if (cellBackColor != null) {
                    double y1 = this.getStartingY(i);
                    double y2 = this.getStartingY(i + 1);
                    ug.apply(HColors.none()).apply(cellBackColor.bg()).apply(new UTranslate(x1, y1)).draw(new URectangle(x2 - x1, y2 - y1));
                }
                Position pos = this.positions.get(cell);
                XDimension2D dimCell = cell.calculateDimension(ug.getStringBounder());
                double dx = align == HorizontalAlignment.RIGHT ? cellWidth - dimCell.getWidth() : 0.0;
                if (cellBackColor == null) {
                    cell.drawU(ug.apply(pos.getTranslate().compose(UTranslate.dx(dx))));
                    continue;
                }
                cell.drawU(ug.apply(cellBackColor.bg()).apply(pos.getTranslate().compose(UTranslate.dx(dx))));
            }
        }
        ug = ug.apply(this.lineColor);
        ULine hline = ULine.hline(this.getEndingX(this.getNbCols() - 1));
        for (int i = 0; i <= this.getNbLines(); ++i) {
            ug.apply(UTranslate.dy(this.getStartingY(i))).draw(hline);
        }
        ULine vline = ULine.vline(this.getEndingY(this.getNbLines() - 1));
        for (int i = 0; i <= this.getNbCols(); ++i) {
            ug.apply(UTranslate.dx(this.getStartingX(i))).draw(vline);
        }
    }

    private void initMap(StringBounder stringBounder) {
        if (this.positions.size() > 0) {
            return;
        }
        for (Line line : this.lines) {
            for (Atom cell : line.cells) {
                XDimension2D dim = cell.calculateDimension(stringBounder);
                Position pos = new Position(0.0, 0.0, dim);
                this.positions.put(cell, pos);
            }
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            for (int j = 0; j < this.lines.get(i).size(); ++j) {
                Atom cell = (Atom)this.lines.get(i).cells.get(j);
                XDimension2D dim = cell.calculateDimension(stringBounder);
                double x = this.getStartingX(j);
                double y = this.getStartingY(i);
                Position pos = new Position(x, y, dim);
                this.positions.put(cell, pos);
            }
        }
    }

    private double getStartingX(int col) {
        double result = 0.0;
        for (int i = 0; i < col; ++i) {
            result += this.getColWidth(i);
        }
        return result;
    }

    private double getEndingX(int col) {
        double result = 0.0;
        for (int i = 0; i <= col; ++i) {
            result += this.getColWidth(i);
        }
        return result;
    }

    private double getStartingY(int line) {
        double result = 0.0;
        for (int i = 0; i < line; ++i) {
            result += this.getLineHeight(i);
        }
        return result;
    }

    private double getEndingY(int line) {
        double result = 0.0;
        for (int i = 0; i <= line; ++i) {
            result += this.getLineHeight(i);
        }
        return result;
    }

    private double getColWidth(int col) {
        double result = 0.0;
        for (int i = 0; i < this.getNbLines(); ++i) {
            Position position = this.getPosition(i, col);
            if (position == null) continue;
            double width = position.getWidth();
            result = Math.max(result, width);
        }
        return result;
    }

    private double getLineHeight(int line) {
        double result = 0.0;
        for (int i = 0; i < this.getNbCols(); ++i) {
            Position position = this.getPosition(line, i);
            if (position == null) continue;
            double height = position.getHeight();
            result = Math.max(result, height);
        }
        return result;
    }

    private Position getPosition(int line, int col) {
        if (line >= this.lines.size()) {
            return null;
        }
        Line l = this.lines.get(line);
        if (col >= l.cells.size()) {
            return null;
        }
        Atom atom = (Atom)l.cells.get(col);
        return this.positions.get(atom);
    }

    private int getNbCols() {
        return this.lines.get(0).size();
    }

    private int getNbLines() {
        return this.lines.size();
    }

    private Line lastLine() {
        return this.lines.get(this.lines.size() - 1);
    }

    public void addCell(Atom cell, HColor cellBackColor) {
        this.lastLine().add(cell, cellBackColor);
        this.positions.clear();
    }

    public void newLine(HColor lineBackColor) {
        this.lines.add(new Line(lineBackColor));
    }

    class Line {
        private final List<Atom> cells = new ArrayList<Atom>();
        private final List<HColor> cellsBackColor = new ArrayList<HColor>();
        private final HColor lineBackColor;

        private Line(HColor lineBackColor) {
            this.lineBackColor = lineBackColor;
        }

        public void add(Atom cell, HColor cellBackColor) {
            this.cells.add(cell);
            this.cellsBackColor.add(cellBackColor);
        }

        public int size() {
            return this.cells.size();
        }

        public String toString() {
            return super.toString() + " " + this.cells.size();
        }
    }
}

