/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.command.regex.RegexComposed;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColors;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class StereotypeDecoration {
    private static final RegexComposed circleChar = new RegexConcat(new RegexLeaf("\\<\\<"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\(?"), new RegexLeaf("CHAR", "(\\S)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("COLOR", "(#[0-9a-fA-F]{6}|\\w+)"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("LABEL", "[),](.*?)")), new RegexLeaf("\\>\\>"));
    private static final RegexComposed circleSprite = new RegexConcat(new RegexLeaf("\\<\\<"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\(?\\$"), new RegexLeaf("NAME", "([-\\p{L}0-9_/]+)"), new RegexLeaf("SCALE", "((?:\\{scale=|\\*)([0-9.]+)\\}?)?"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("COLOR", "(#[0-9a-fA-F]{6}|\\w+)"))), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("LABEL", "[),](.*?)")), new RegexLeaf("\\>\\>"));
    public static final String PREFIX = "%";
    final String label;
    final HColor htmlColor;
    final char character;
    final String spriteName;
    final double spriteScale;

    public String toString() {
        return "label='" + this.label + "' spriteName='" + this.spriteName + "'";
    }

    public List<String> getStyleNames() {
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        for (String s : StereotypeDecoration.cutLabels(this.label, Guillemet.NONE)) {
            result.add((CallSite)((Object)(PREFIX + s)));
        }
        if (this.spriteName == null) {
            return Collections.unmodifiableList(result);
        }
        int idx = this.spriteName.lastIndexOf(47);
        if (idx != -1) {
            result.add((CallSite)((Object)(PREFIX + this.spriteName.substring(idx + 1))));
        }
        return Collections.unmodifiableList(result);
    }

    private StereotypeDecoration(String label, HColor htmlColor, char character, String spriteName, double spriteScale) {
        this.label = label;
        this.htmlColor = htmlColor;
        this.character = character;
        this.spriteName = spriteName;
        this.spriteScale = spriteScale;
    }

    static StereotypeDecoration buildSimple(String name) {
        double spriteScale;
        String spriteName;
        if (name.startsWith("<<$") && name.endsWith(">>")) {
            RegexResult mCircleSprite = circleSprite.matcher(name);
            spriteName = mCircleSprite.get("NAME", 0);
            spriteScale = Parser.getScale(mCircleSprite.get("SCALE", 0), 1.0);
        } else {
            spriteName = null;
            spriteScale = 0.0;
        }
        return new StereotypeDecoration(name, null, '\u0000', spriteName, spriteScale);
    }

    /*
     * WARNING - void declaration
     */
    public static StereotypeDecoration buildComplex(String full, HColorSet htmlColorSet) throws NoSuchColorException {
        Object label = "";
        HColor htmlColor = null;
        char character = '\u0000';
        String spriteName = null;
        double spriteScale = 0.0;
        List<String> list = StereotypeDecoration.cutLabels(full, Guillemet.DOUBLE_COMPARATOR);
        for (String string : list) {
            void var10_9;
            String colName;
            RegexResult mCircleChar = circleChar.matcher(string);
            RegexResult mCircleSprite = circleSprite.matcher(string);
            if (mCircleSprite != null) {
                if (StringUtils.isNotEmpty(mCircleSprite.get("LABEL", 0))) {
                    String string2 = "<<" + mCircleSprite.get("LABEL", 0) + ">>";
                } else {
                    String string3 = "";
                }
                colName = mCircleSprite.get("COLOR", 0);
                HColor col = colName == null ? null : htmlColorSet.getColorLEGACY(colName);
                htmlColor = col == null ? HColors.BLACK : col;
                character = '\u0000';
                spriteName = mCircleSprite.get("NAME", 0);
                spriteScale = Parser.getScale(mCircleSprite.get("SCALE", 0), 1.0);
            } else if (mCircleChar != null) {
                if (StringUtils.isNotEmpty(mCircleChar.get("LABEL", 0))) {
                    String string4 = "<<" + mCircleChar.get("LABEL", 0) + ">>";
                } else {
                    String string5 = "";
                }
                colName = mCircleChar.get("COLOR", 0);
                htmlColor = colName == null ? null : htmlColorSet.getColorLEGACY(colName);
                character = mCircleChar.get("CHAR", 0).charAt(0);
            }
            label = (String)label + (String)var10_9;
        }
        return new StereotypeDecoration((String)label, htmlColor, character, spriteName, spriteScale);
    }

    static List<String> cutLabels(String label, Guillemet guillemet) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern2 p = MyPattern.cmpile("\\<{2,3}.*?\\>{2,3}");
        Matcher2 m = p.matcher(label);
        while (m.find()) {
            String group = m.group();
            if (group.startsWith("<<<")) continue;
            result.add(guillemet.manageGuillemetStrict(group));
        }
        return Collections.unmodifiableList(result);
    }
}

