/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.baraye.EntityUtils;
import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.baraye.IGroup;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.InnerActivity;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public final class GroupPngMakerActivity {
    private final ICucaDiagram diagram;
    private final IGroup group;
    private final StringBounder stringBounder;
    private final Rose rose = new Rose();

    public GroupPngMakerActivity(ICucaDiagram diagram, IGroup group, StringBounder stringBounder) {
        this.diagram = diagram;
        this.group = group;
        this.stringBounder = stringBounder;
    }

    private List<Link> getPureInnerLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            IEntity e1 = link.getEntity1();
            IEntity e2 = link.getEntity2();
            if (e1.getParentContainer() != this.group || e1.isGroup() || e2.getParentContainer() != this.group || e2.isGroup()) continue;
            result.add(link);
        }
        return result;
    }

    public final StyleSignatureBasic getDefaultStyleDefinitionGroup() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.group);
    }

    public IEntityImage getImage() throws IOException, InterruptedException {
        if (this.group.size() == 0) {
            return new EntityImageState(this.group, this.diagram.getSkinParam());
        }
        List<Link> links = this.getPureInnerLinks();
        ISkinParam skinParam = this.diagram.getSkinParam();
        DotData dotData = new DotData(this.group, links, this.group.getLeafsDirect(), this.diagram.getUmlDiagramType(), skinParam, new InnerGroupHierarchy(), this.diagram.getEntityFactory(), false, DotMode.NORMAL, this.diagram.getNamespaceSeparator(), this.diagram.getPragma());
        GeneralImageBuilder svek2 = new GeneralImageBuilder(false, dotData, this.diagram.getEntityFactory(), this.diagram.getSource(), this.diagram.getPragma(), this.stringBounder, SName.activityDiagram);
        if (this.group.getGroupType() == GroupType.INNER_ACTIVITY) {
            Stereotype stereo = this.group.getStereotype();
            HColor borderColor = this.getColor(ColorParam.activityBorder, stereo);
            HColor backColor = this.group.getColors().getColor(ColorType.BACK) == null ? this.getColor(ColorParam.background, stereo) : this.group.getColors().getColor(ColorType.BACK);
            Style style = this.getDefaultStyleDefinitionGroup().getMergedStyle(skinParam.getCurrentStyleBuilder());
            double shadowing = style.value(PName.Shadowing).asDouble();
            return new InnerActivity(svek2.buildImage(null, new String[0]), borderColor, backColor, shadowing);
        }
        throw new UnsupportedOperationException(this.group.getGroupType().toString());
    }

    protected final HColor getColor(ColorParam colorParam, Stereotype stereo) {
        ISkinParam skinParam = this.diagram.getSkinParam();
        return this.rose.getHtmlColor(skinParam, stereo, colorParam);
    }

    class InnerGroupHierarchy
    implements GroupHierarchy {
        InnerGroupHierarchy() {
        }

        @Override
        public IGroup getRootGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<IGroup> getChildrenGroups(IGroup parent) {
            if (EntityUtils.groupRoot(parent)) {
                return GroupPngMakerActivity.this.diagram.getChildrenGroups(GroupPngMakerActivity.this.group);
            }
            return GroupPngMakerActivity.this.diagram.getChildrenGroups(parent);
        }

        @Override
        public boolean isEmpty(IGroup g) {
            return GroupPngMakerActivity.this.diagram.isEmpty(g);
        }
    }
}

