/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPattern;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShapeSized;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

public class DriverRectangleG2d
extends DriverShadowedG2d
implements UDriver<URectangle, Graphics2D> {
    private final double dpiFactor;
    private final EnsureVisible visible;

    public DriverRectangleG2d(double dpiFactor, EnsureVisible visible) {
        this.dpiFactor = dpiFactor;
        this.visible = visible;
    }

    @Override
    public void draw(URectangle rect, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        HColor color;
        g2d.setStroke(new BasicStroke((float)param.getStroke().getThickness()));
        double rx = rect.getRx();
        double ry = rect.getRy();
        RectangularShape shape = rx == 0.0 && ry == 0.0 ? new Rectangle2D.Double(x, y, rect.getWidth(), rect.getHeight()) : new RoundRectangle2D.Double(x, y, rect.getWidth(), rect.getHeight(), rx, ry);
        this.visible.ensureVisible(x, y);
        this.visible.ensureVisible(x + rect.getWidth(), y + rect.getHeight());
        HColor back = param.getBackcolor();
        if (rect.getDeltaShadow() != 0.0) {
            if (back.isTransparent()) {
                this.drawOnlyLineShadowSpecial(g2d, shape, rect.getDeltaShadow(), this.dpiFactor);
            } else {
                this.drawShadow(g2d, shape, rect.getDeltaShadow(), this.dpiFactor);
            }
        }
        if ((color = param.getColor()) == null) {
            param.getColor();
        }
        if (back instanceof HColorGradient) {
            GradientPaint paint = DriverRectangleG2d.getPaintGradient(x, y, mapper, rect.getWidth(), rect.getHeight(), back);
            g2d.setPaint(paint);
            g2d.fill(shape);
            DriverRectangleG2d.drawBorder(param, color, mapper, rect, shape, g2d, x, y);
        } else {
            if (!param.getBackcolor().isTransparent()) {
                g2d.setColor(param.getBackcolor().toColor(mapper));
                DriverLineG2d.manageStroke(param, g2d);
                DriverRectangleG2d.managePattern(param, g2d);
                g2d.fill(shape);
            }
            if (!color.equals(param.getBackcolor())) {
                DriverRectangleG2d.drawBorder(param, color, mapper, rect, shape, g2d, x, y);
            }
        }
    }

    public static void drawBorder(UParam param, HColor color, ColorMapper mapper, UShapeSized sized, Shape shape, Graphics2D g2d, double x, double y) {
        if (color.isTransparent()) {
            return;
        }
        if (color instanceof HColorGradient) {
            GradientPaint paint = DriverRectangleG2d.getPaintGradient(x, y, mapper, sized.getWidth(), sized.getHeight(), color);
            g2d.setPaint(paint);
        } else {
            g2d.setColor(color.toColor(mapper));
        }
        DriverLineG2d.manageStroke(param, g2d);
        g2d.draw(shape);
    }

    public static GradientPaint getPaintGradient(double x, double y, ColorMapper mapper, double width, double height, HColor back) {
        HColorGradient gr = (HColorGradient)back;
        char policy = gr.getPolicy();
        GradientPaint paint = policy == '|' ? new GradientPaint((float)x, (float)(y + height) / 2.0f, gr.getColor1().toColor(mapper), (float)(x + width), (float)(y + height) / 2.0f, gr.getColor2().toColor(mapper)) : (policy == '\\' ? new GradientPaint((float)x, (float)(y + height), gr.getColor1().toColor(mapper), (float)(x + width), (float)y, gr.getColor2().toColor(mapper)) : (policy == '-' ? new GradientPaint((float)(x + width) / 2.0f, (float)y, gr.getColor1().toColor(mapper), (float)(x + width) / 2.0f, (float)(y + height), gr.getColor2().toColor(mapper)) : new GradientPaint((float)x, (float)y, gr.getColor1().toColor(mapper), (float)(x + width), (float)(y + height), gr.getColor2().toColor(mapper))));
        return paint;
    }

    public static void managePattern(UParam param, Graphics2D g2d) {
        UPattern pattern = param.getPattern();
        if (pattern == UPattern.VERTICAL_STRIPE) {
            BufferedImage bi = new BufferedImage(4, 4, 2);
            Rectangle r = new Rectangle(0, 0, 4, 4);
            int rgb = ((HColorSimple)param.getBackcolor()).getAwtColor().getRGB();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (i != 0 && i != 1) continue;
                    bi.setRGB(i, j, rgb);
                }
            }
            g2d.setPaint(new TexturePaint(bi, r));
        } else if (pattern == UPattern.HORIZONTAL_STRIPE) {
            BufferedImage bi = new BufferedImage(4, 4, 2);
            Rectangle r = new Rectangle(0, 0, 4, 4);
            int rgb = ((HColorSimple)param.getBackcolor()).getAwtColor().getRGB();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (j != 0 && j != 1) continue;
                    bi.setRGB(i, j, rgb);
                }
            }
            g2d.setPaint(new TexturePaint(bi, r));
        } else if (pattern == UPattern.SMALL_CIRCLE) {
            BufferedImage bi = new BufferedImage(4, 4, 2);
            Rectangle r = new Rectangle(0, 0, 4, 4);
            int rgb = ((HColorSimple)param.getBackcolor()).getAwtColor().getRGB();
            bi.setRGB(0, 1, rgb);
            bi.setRGB(1, 0, rgb);
            bi.setRGB(1, 1, rgb);
            bi.setRGB(1, 2, rgb);
            bi.setRGB(2, 1, rgb);
            g2d.setPaint(new TexturePaint(bi, r));
        }
    }
}

