/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.SignatureUtils;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.LicenseInfo;
import net.sourceforge.plantuml.version.PLSSignature;
import net.sourceforge.plantuml.version.Version;

public class PSystemKeycheck
extends PlainDiagram {
    private final String key;
    private final String sig;

    public PSystemKeycheck(UmlSource source, String sig, String key) {
        super(source);
        this.sig = sig;
        this.key = key;
    }

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                try {
                    PSystemKeycheck.this.drawInternal(ug);
                }
                catch (Exception e) {
                    Logme.error(e);
                }
            }
        };
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Key)");
    }

    private void drawInternal(UGraphic ug) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        ArrayList<String> strings = this.header();
        try {
            LicenseInfo info = PLSSignature.retrieveNamed(this.sig, this.key, false);
            strings.add("<u>Provided license information</u>:");
            License.addLicenseInfo(strings, info);
            strings.add(" ");
        }
        catch (Exception e) {
            Logme.error(e);
            strings.add("<i>Error:</i> " + e);
        }
        TextBlockBackcolored disp = GraphicStrings.createBlackOnWhite(strings);
        disp.drawU(ug);
    }

    private ArrayList<String> header() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("<b>PlantUML version " + Version.versionString() + "</b> (" + Version.compileTimeString() + ")");
        strings.add("(" + License.getCurrent() + " source distribution)");
        strings.add(" ");
        return strings;
    }

    private void drawFlash(UGraphic ug, LicenseInfo info) throws IOException {
        ArrayList<String> strings = this.header();
        strings.add("To get your <i>Professional Edition License</i>,");
        strings.add("please send this qrcode to <b>plantuml@gmail.com</b> :");
        TextBlockBackcolored disp = GraphicStrings.createBlackOnWhite(strings);
        disp.drawU(ug);
        ug = ug.apply(UTranslate.dy(disp.calculateDimension(ug.getStringBounder()).getHeight()));
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        BufferedImage im = utils.exportFlashcode(Version.versionString() + "\n" + SignatureUtils.toHexString(PLSSignature.signature()), Color.BLACK, Color.WHITE);
        if (im != null) {
            UImage flash = new UImage(new PixelImage(im, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(4.0);
            ug.draw(flash);
            ug = ug.apply(UTranslate.dy(flash.getHeight()));
        }
        if (!info.isNone()) {
            strings.clear();
            strings.add("<u>Installed license</u>:");
            License.addLicenseInfo(strings, info);
            strings.add(" ");
            disp = GraphicStrings.createBlackOnWhite(strings);
            disp.drawU(ug);
        }
    }
}

