/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import java.io.File;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.configuration.Configuration;
import nl.talsmasoftware.umldoclet.uml.Diagram;

public class PackageDiagram
extends Diagram {
    final String moduleName;
    final String packageName;
    private File pumlFile = null;

    public PackageDiagram(Configuration config, String packageName, String moduleName) {
        super(config);
        this.packageName = Objects.requireNonNull(packageName, "Package name is <null>.");
        this.moduleName = moduleName;
    }

    @Override
    protected File getPlantUmlFile() {
        if (this.pumlFile == null) {
            StringBuilder result = new StringBuilder(this.getConfiguration().destinationDirectory());
            if (result.length() > 0 && result.charAt(result.length() - 1) != '/') {
                result.append('/');
            }
            if (this.moduleName != null) {
                result.append(this.moduleName).append('/');
            }
            result.append(this.packageName.replace('.', '/'));
            result.append("/package.puml");
            this.pumlFile = new File(result.toString());
        }
        return this.pumlFile;
    }
}

