/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.util;

public enum KeyUsage {
    DIGITAL_SIGNATURE(0),
    NON_REPUDIATION(1),
    KEY_ENCIPHERMENT(2),
    DATA_ENCIPHERMENT(3),
    KEY_AGREEMENT(4),
    KEY_CERT_SIGN(5),
    CRL_SIGN(6),
    ENCIPHER_ONLY(7),
    DECIPHER_ONLY(8);

    private final int bit;

    public static KeyUsage of(int bit) {
        for (KeyUsage keyUsage : KeyUsage.values()) {
            if (keyUsage.bit != bit) continue;
            return keyUsage;
        }
        throw new IllegalArgumentException(String.format("Bit '%s' is not known.", bit));
    }

    private KeyUsage(int bit) {
        this.bit = bit;
    }

    public int getBit() {
        return this.bit;
    }
}

