package no.tornado.databinding.support.jxdatepicker;

import no.tornado.databinding.converter.ConversionException;
import no.tornado.databinding.uibridge.DocumentChangeListener;
import no.tornado.databinding.uibridge.UIBridge;
import org.jdesktop.swingx.JXDatePicker;

import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import java.util.Date;

public class JXDatePickerBridge implements UIBridge<JXDatePicker, DocumentListener, Date> {
    static JXDatePickerBridge INSTANCE = new JXDatePickerBridge();
    private JXDatePickerBridge() { }

    public Class<JXDatePicker> getUIClass() {
        return JXDatePicker.class;
    }

    public Class<? extends Date> getUIValueType() {
        return Date.class;
    }

    public void setUIValue(JXDatePicker component, Date value) throws ConversionException {
        component.setDate(value);
    }

    public Date getUIValue(JXDatePicker component) throws ConversionException {
        return component.getDate();
    }

    public DocumentListener addValueChangeListener(JXDatePicker component, ChangeListener listener) {
        DocumentListener documentListener = new DocumentChangeListener(listener);
        component.getEditor().getDocument().addDocumentListener(documentListener);
        return documentListener;
    }

    public void removeValueChangelistener(JXDatePicker component, DocumentListener listener) {
        component.getEditor().getDocument().removeDocumentListener(listener);
    }
}
