/*
 *  Copyright 2010 johan.
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  under the License.
 */
package nu.zoom.ui;

import javax.swing.ImageIcon;

/**
 * Hide the platform to get resources. This is mainly to prepare for moving from
 * zoom-desktop to OSGI & Netbeans.
 * 
 * @author "Johan Maasing" &lt;johan@zoom.nu&gt;
 */
public interface Resources {

	/**
	 * Get a localized string.
	 * 
	 * @param key
	 *            The name of the resource string to get.
	 * @return The resource string.
	 * @throws nu.zoom.catonine.ui.Resources.ResourceNotFoundException
	 *             If the resource can not be found.
	 */
	public String getMessage(final String key) throws ResourceNotFoundException;

	/**
	 * Get a localized string template and insert values.
	 * 
	 * @param key
	 *            The name of the resource string to get.
	 * @param args
	 *            The parametrs that are to be inserted into the string
	 *            template.
	 * @return The string template with values inserted.
	 * @throws nu.zoom.catonine.ui.Resources.ResourceNotFoundException
	 *             If the resource can not be found.
	 */
	public String format(final String key, final Object... args) throws ResourceNotFoundException;

	/**
	 * Get a localized image.
	 * 
	 * @param key
	 *            The resouce name that points to the image name.
	 * @return The image.
	 * @throws nu.zoom.catonine.ui.Resources.ResourceNotFoundException
	 *             If the resource or the image can not be found.
	 */
	public ImageIcon getIcon(final String key) throws ResourceNotFoundException;

	/**
	 * Indicates that a requested resource can not be found.
	 */
	public static class ResourceNotFoundException extends Exception {
		private static final long serialVersionUID = 1L;

		public ResourceNotFoundException(Throwable cause) {
			super(cause);
		}

		public ResourceNotFoundException(String message, Throwable cause) {
			super(message, cause);
		}

		public ResourceNotFoundException(String message) {
			super(message);
		}
	}
}
