/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.signature.AbstractSignableXMLObject;
import org.opensaml.xml.validation.ValidatingXMLObject;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidatingSignableXMLObject
extends AbstractSignableXMLObject
implements ValidatingXMLObject {
    private final Logger log = LoggerFactory.getLogger(AbstractValidatingSignableXMLObject.class);
    private List<Validator> validators = new LinkedList<Validator>();

    protected AbstractValidatingSignableXMLObject(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    public List<Validator> getValidators() {
        if (this.validators.size() > 0) {
            return Collections.unmodifiableList(this.validators);
        }
        return null;
    }

    @Override
    public void registerValidator(Validator validator) {
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    @Override
    public void deregisterValidator(Validator validator) {
        this.validators.remove(validator);
    }

    @Override
    public void validate(boolean validateDescendants) throws ValidationException {
        for (Validator validator : this.validators) {
            this.log.debug("Validating {} using Validator class {}", (Object)this.getElementQName(), (Object)validator.getClass().getName());
            validator.validate(this);
        }
        if (validateDescendants) {
            this.log.debug("Validating descendants of {}", (Object)this.getElementQName());
            this.validateChildren(this);
        }
    }

    protected void validateChildren(XMLObject xmlObject) throws ValidationException {
        for (XMLObject childObject : xmlObject.getOrderedChildren()) {
            if (childObject == null) continue;
            if (childObject instanceof ValidatingXMLObject) {
                ((ValidatingXMLObject)childObject).validate(false);
            } else {
                this.log.debug("{} does not implement ValidatingXMLObject, ignoring it.", (Object)childObject.getElementQName());
            }
            if (!childObject.hasChildren()) continue;
            this.validateChildren(childObject);
        }
    }
}

