/*
 * Decompiled with CFR 0.152.
 */
package org.compass.spring.device;

import org.compass.core.spi.InternalCompass;
import org.compass.core.transaction.TransactionFactory;
import org.compass.core.util.Assert;
import org.compass.gps.CompassGpsDevice;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.AbstractGpsDeviceWrapper;
import org.compass.gps.spi.CompassGpsInterfaceDevice;
import org.compass.spring.transaction.SpringSyncTransactionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringSyncTransactionGpsDeviceWrapper
extends AbstractGpsDeviceWrapper
implements InitializingBean {
    private PlatformTransactionManager transactionManager;
    private boolean allowNoTransactionManager = true;

    public SpringSyncTransactionGpsDeviceWrapper() {
    }

    public SpringSyncTransactionGpsDeviceWrapper(CompassGpsDevice device) {
        this.setGpsDevice(device);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.gpsDevice, (String)"Must set wrapped gpsDevice");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void index() throws CompassGpsException {
        TransactionFactory transactionFactory;
        if (this.transactionManager == null && (transactionFactory = ((InternalCompass)((CompassGpsInterfaceDevice)this.gpsDevice.getGps()).getIndexCompass()).getTransactionFactory()) instanceof SpringSyncTransactionFactory) {
            SpringSyncTransactionFactory springSyncTransactionFactory = (SpringSyncTransactionFactory)transactionFactory;
            this.transactionManager = springSyncTransactionFactory.getTransactionManager();
        }
        if (this.transactionManager == null) {
            if (!this.allowNoTransactionManager) throw new CompassGpsException("No transaction manager is found, and it is not allowed");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No transaction manager found, will not execute the index operation within its own transaction");
            }
            this.gpsDevice.index();
            return;
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Startin a new Spring transaction for device [" + this.gpsDevice.getName() + "] index operation"));
            }
            TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
            transactionTemplate.setPropagationBehavior(3);
            transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    SpringSyncTransactionGpsDeviceWrapper.this.gpsDevice.index();
                }
            });
        }
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setAllowNoTransactionManager(boolean allowNoTransactionManager) {
        this.allowNoTransactionManager = allowNoTransactionManager;
    }
}

