/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork;

import com.opensymphony.xwork.ValidationAware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ValidationAwareSupport
implements ValidationAware {
    private Collection actionErrors;
    private Map fieldErrors;

    public synchronized void setActionErrors(Collection errorMessages) {
        this.actionErrors = errorMessages;
    }

    public synchronized Collection getActionErrors() {
        return new ArrayList(this.internalGetActionErrors());
    }

    public synchronized void setFieldErrors(Map errorMap) {
        this.fieldErrors = errorMap;
    }

    public synchronized Map getFieldErrors() {
        return new HashMap(this.internalGetFieldErrors());
    }

    public synchronized void addActionError(String anErrorMessage) {
        this.internalGetActionErrors().add(anErrorMessage);
    }

    public synchronized void addFieldError(String fieldName, String errorMessage) {
        Map errors = this.internalGetFieldErrors();
        ArrayList<String> thisFieldErrors = (ArrayList<String>)errors.get(fieldName);
        if (thisFieldErrors == null) {
            thisFieldErrors = new ArrayList<String>();
            errors.put(fieldName, thisFieldErrors);
        }
        thisFieldErrors.add(errorMessage);
    }

    public synchronized boolean hasActionErrors() {
        return this.actionErrors != null && !this.actionErrors.isEmpty();
    }

    public synchronized boolean hasErrors() {
        return this.hasActionErrors() || this.hasFieldErrors();
    }

    public synchronized boolean hasFieldErrors() {
        return this.fieldErrors != null && !this.fieldErrors.isEmpty();
    }

    private Collection internalGetActionErrors() {
        if (this.actionErrors == null) {
            this.actionErrors = new ArrayList();
        }
        return this.actionErrors;
    }

    private Map internalGetFieldErrors() {
        if (this.fieldErrors == null) {
            this.fieldErrors = new HashMap();
        }
        return this.fieldErrors;
    }
}

