/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config;

import com.opensymphony.util.FileManager;
import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationProvider;
import com.opensymphony.xwork.config.impl.DefaultConfiguration;
import com.opensymphony.xwork.config.providers.XmlConfigurationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationManager {
    protected static final Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$xwork$config$ConfigurationManager == null ? (class$com$opensymphony$xwork$config$ConfigurationManager = ConfigurationManager.class$("com.opensymphony.xwork.config.ConfigurationManager")) : class$com$opensymphony$xwork$config$ConfigurationManager));
    protected static Configuration configurationInstance;
    private static List configurationProviders;
    static /* synthetic */ Class class$com$opensymphony$xwork$config$ConfigurationManager;

    private ConfigurationManager() {
    }

    public static void setConfiguration(Configuration configuration) {
        configurationInstance = configuration;
    }

    public static Configuration getConfiguration() {
        if (configurationInstance == null) {
            configurationInstance = new DefaultConfiguration();
            configurationInstance.reload();
        } else {
            ConfigurationManager.conditionalReload();
        }
        return configurationInstance;
    }

    public static List getConfigurationProviders() {
        if (configurationProviders.size() == 0) {
            configurationProviders.add(new XmlConfigurationProvider());
        }
        return configurationProviders;
    }

    public static void addConfigurationProvider(ConfigurationProvider provider) {
        if (!configurationProviders.contains(provider)) {
            configurationProviders.add(provider);
        }
    }

    public static synchronized void clearConfigurationProviders() {
        Iterator iterator = configurationProviders.iterator();
        while (iterator.hasNext()) {
            ConfigurationProvider provider = (ConfigurationProvider)iterator.next();
            provider.destroy();
        }
        configurationProviders.clear();
    }

    public static void destroyConfiguration() {
        configurationProviders = Collections.synchronizedList(new ArrayList());
        configurationInstance = null;
    }

    private static void conditionalReload() {
        if (FileManager.isReloadingConfigs()) {
            LOG.debug((Object)"Checking ConfigurationProviders for reload.");
            boolean reload = false;
            Iterator iterator = ConfigurationManager.getConfigurationProviders().iterator();
            while (iterator.hasNext()) {
                ConfigurationProvider provider = (ConfigurationProvider)iterator.next();
                if (!provider.needsReload()) continue;
                reload = true;
                break;
            }
            if (reload) {
                configurationInstance.reload();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ConfigurationManager.destroyConfiguration();
    }
}

