/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config.entities;

import com.opensymphony.xwork.config.entities.ExternalReference;
import com.opensymphony.xwork.config.entities.InterceptorListHolder;
import com.opensymphony.xwork.config.entities.Parameterizable;
import com.opensymphony.xwork.config.entities.ResultConfig;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionConfig
implements InterceptorListHolder,
Parameterizable,
Serializable {
    protected List interceptors;
    protected List externalRefs;
    protected Map params;
    protected Map results;
    protected Method method;
    protected String methodName;
    protected String packageName;
    private Class clazz;

    public ActionConfig() {
        this.params = new HashMap();
        this.results = new HashMap();
        this.interceptors = new ArrayList();
        this.externalRefs = new ArrayList();
    }

    public ActionConfig(String methodName, Class clazz, Map parameters, Map results, List interceptors) {
        this(methodName, clazz, parameters, results, interceptors, Collections.EMPTY_LIST, new String());
    }

    public ActionConfig(String methodName, Class clazz, Map parameters, Map results, List interceptors, List externalRefs, String packageName) {
        this.methodName = methodName;
        this.interceptors = interceptors;
        this.params = parameters;
        this.results = results;
        this.clazz = clazz;
        this.externalRefs = externalRefs;
        this.packageName = packageName;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public List getInterceptors() {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList();
        }
        return this.interceptors;
    }

    public Method getMethod() throws NoSuchMethodException {
        if (this.method != null) {
            return this.method;
        }
        this.method = this.methodName != null ? this.clazz.getMethod(this.methodName, new Class[0]) : this.clazz.getMethod("execute", new Class[0]);
        return this.method;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public Map getParams() {
        if (this.params == null) {
            this.params = new HashMap();
        }
        return this.params;
    }

    public void setResults(Map results) {
        this.results = results;
    }

    public Map getResults() {
        if (this.results == null) {
            this.results = new HashMap();
        }
        return this.results;
    }

    public void addInterceptor(Interceptor interceptor) {
        this.getInterceptors().add(interceptor);
    }

    public void addInterceptors(List interceptors) {
        this.getInterceptors().addAll(interceptors);
    }

    public void addParam(String name, Object value) {
        this.getParams().put(name, value);
    }

    public void addResultConfig(ResultConfig resultConfig) {
        this.getResults().put(resultConfig.getName(), resultConfig);
    }

    public void addExternalRef(ExternalReference reference) {
        this.getExternalRefs().add(reference);
    }

    public void addExternalRefs(List externalRefs) {
        this.getExternalRefs().addAll(externalRefs);
    }

    public List getExternalRefs() {
        return this.externalRefs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionConfig)) {
            return false;
        }
        ActionConfig actionConfig = (ActionConfig)o;
        if (this.clazz != null ? !this.clazz.equals(actionConfig.clazz) : actionConfig.clazz != null) {
            return false;
        }
        if (this.interceptors != null ? !((Object)this.interceptors).equals(actionConfig.interceptors) : actionConfig.interceptors != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(actionConfig.method) : actionConfig.method != null) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(actionConfig.methodName) : actionConfig.methodName != null) {
            return false;
        }
        if (this.params != null ? !((Object)this.params).equals(actionConfig.params) : actionConfig.params != null) {
            return false;
        }
        return !(this.results != null ? !((Object)this.results).equals(actionConfig.results) : actionConfig.results != null);
    }

    public int hashCode() {
        int result = this.interceptors != null ? ((Object)this.interceptors).hashCode() : 0;
        result = 29 * result + (this.params != null ? ((Object)this.params).hashCode() : 0);
        result = 29 * result + (this.results != null ? ((Object)this.results).hashCode() : 0);
        result = 29 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 29 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        result = 29 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
        return result;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String toString() {
        return "{ActionConfig " + this.clazz.getName() + (this.methodName != null ? "." + this.methodName + "()" : "") + "}";
    }
}

