/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config.providers;

import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.entities.InterceptorConfig;
import com.opensymphony.xwork.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.util.OgnlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InterceptorBuilder {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$xwork$config$providers$InterceptorBuilder == null ? (class$com$opensymphony$xwork$config$providers$InterceptorBuilder = InterceptorBuilder.class$("com.opensymphony.xwork.config.providers.InterceptorBuilder")) : class$com$opensymphony$xwork$config$providers$InterceptorBuilder));
    static /* synthetic */ Class class$com$opensymphony$xwork$config$providers$InterceptorBuilder;

    /*
     * WARNING - void declaration
     */
    public static Interceptor buildInterceptor(Class interceptorClass, Map params) throws ConfigurationException {
        void var2_7;
        String message;
        try {
            Interceptor interceptor = (Interceptor)interceptorClass.newInstance();
            OgnlUtil.setProperties(params, interceptor);
            interceptor.init();
            return interceptor;
        }
        catch (InstantiationException e) {
            message = "Unable to instantiate an instance of Interceptor class [" + interceptorClass.getName() + "].";
        }
        catch (IllegalAccessException e) {
            message = "IllegalAccessException while attempting to instantiate an instance of Interceptor class [" + interceptorClass.getName() + "].";
        }
        catch (ClassCastException e) {
            message = "Class [" + interceptorClass.getName() + "] does not implement com.opensymphony.xwork.interceptor.Interceptor";
        }
        catch (Exception e) {
            throw new ConfigurationException("Caught Exception while registering Interceptor class " + interceptorClass.getName(), e);
        }
        throw new ConfigurationException((String)var2_7);
    }

    public static List constructInterceptorReference(PackageConfig packageConfig, String refName, Map refParams) throws ConfigurationException {
        Object referencedConfig = packageConfig.getAllInterceptorConfigs().get(refName);
        ArrayList<Interceptor> result = new ArrayList<Interceptor>();
        if (referencedConfig == null) {
            LOG.error((Object)("Unable to find interceptor class referenced by ref-name " + refName));
        } else if (referencedConfig instanceof InterceptorConfig) {
            InterceptorConfig interceptorConfig = (InterceptorConfig)referencedConfig;
            Map thisInterceptorClassParams = interceptorConfig.getParams();
            HashMap params = thisInterceptorClassParams == null ? new HashMap() : new HashMap(thisInterceptorClassParams);
            params.putAll(refParams);
            result.add(InterceptorBuilder.buildInterceptor(interceptorConfig.getClazz(), params));
        } else if (referencedConfig instanceof InterceptorStackConfig) {
            InterceptorStackConfig stackConfig = (InterceptorStackConfig)referencedConfig;
            if (refParams != null && refParams.size() > 0) {
                LOG.warn((Object)("Interceptor-ref params are being ignored because they are applied to an Interceptor-Stack reference. Ref name = " + refName + ", params = " + refParams));
            }
            result.addAll(stackConfig.getInterceptors());
        } else {
            LOG.error((Object)("Got unexpected type for interceptor " + refName + ". Got " + referencedConfig));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

