/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor.component;

import com.opensymphony.xwork.interceptor.component.ComponentManager;
import com.opensymphony.xwork.interceptor.component.Disposable;
import com.opensymphony.xwork.interceptor.component.Initializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultComponentManager
implements ComponentManager,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$xwork$interceptor$component$DefaultComponentManager == null ? (class$com$opensymphony$xwork$interceptor$component$DefaultComponentManager = DefaultComponentManager.class$("com.opensymphony.xwork.interceptor.component.DefaultComponentManager")) : class$com$opensymphony$xwork$interceptor$component$DefaultComponentManager));
    Map enablers = new HashMap();
    Map enablers2 = new HashMap();
    private DefaultComponentManager fallback;
    private List loadOrder = new ArrayList();
    private Map resourceInstances = new HashMap();
    private Set alreadyLoaded = new HashSet();
    static /* synthetic */ Class class$com$opensymphony$xwork$interceptor$component$DefaultComponentManager;

    public void setFallback(ComponentManager fallback) {
        if (!(fallback instanceof DefaultComponentManager)) {
            throw new RuntimeException("Fallback must be an instance of DefaultConfigurationManager");
        }
        this.fallback = (DefaultComponentManager)fallback;
    }

    public void addEnabler(Class component, Class enablerType) {
        this.enablers.put(enablerType, component);
        this.enablers2.put(component, enablerType);
    }

    public void dispose() {
        Collections.reverse(this.loadOrder);
        Iterator iterator = this.loadOrder.iterator();
        while (iterator.hasNext()) {
            Object resource = iterator.next();
            if (!(resource instanceof Disposable)) continue;
            Disposable disposable = (Disposable)resource;
            disposable.dispose();
        }
    }

    public void initializeObject(Object obj) {
        this.loadResource(obj, this);
    }

    private Map getResourceDependencies(Class resourceClass) {
        ArrayList interfaces = new ArrayList();
        this.addAllInterfaces(resourceClass, interfaces);
        HashMap<Class, DefaultComponentManager> dependencies = new HashMap<Class, DefaultComponentManager>();
        Iterator iterator = interfaces.iterator();
        block0: while (iterator.hasNext()) {
            Class anInterface = (Class)iterator.next();
            DefaultComponentManager dcm = this;
            while (dcm != null) {
                Class possibleResource = (Class)dcm.enablers.get(anInterface);
                if (possibleResource != null) {
                    dependencies.put(possibleResource, dcm);
                    continue block0;
                }
                dcm = dcm.fallback;
            }
        }
        return dependencies;
    }

    private void addAllInterfaces(Class clazz, List allInterfaces) {
        if (clazz == null) {
            return;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        allInterfaces.addAll(Arrays.asList(interfaces));
        this.addAllInterfaces(clazz.getSuperclass(), allInterfaces);
    }

    private Class loadResource(Object resource, DefaultComponentManager dcm) {
        boolean resourceNotLoaded;
        boolean bl = resourceNotLoaded = !dcm.loadOrder.contains(resource);
        if (resourceNotLoaded) {
            Map resources = this.getResourceDependencies(resource.getClass());
            Iterator iterator = resources.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry mapEntry = iterator.next();
                Class depResource = (Class)mapEntry.getKey();
                DefaultComponentManager newDcm = (DefaultComponentManager)mapEntry.getValue();
                try {
                    Object newResource = newDcm.resourceInstances.get(depResource);
                    if (newResource == null) {
                        newResource = depResource.newInstance();
                    }
                    Class enabler = this.loadResource(newResource, newDcm);
                    this.setupResource(resource, enabler, newResource);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Error loading or setting up resource: " + resources.getClass().getName()), (Throwable)e);
                }
            }
            dcm.alreadyLoaded.add(resource.getClass());
            if (resource instanceof Initializable) {
                Initializable initializable = (Initializable)resource;
                initializable.init();
            }
            dcm.resourceInstances.put(resource.getClass(), resource);
            dcm.loadOrder.add(resource);
        }
        Class enabler = (Class)dcm.enablers2.get(resource.getClass());
        return enabler;
    }

    private void setupResource(Object resource, Class enabler, Object newResource) {
        block3: {
            if (enabler == null) {
                return;
            }
            try {
                enabler.getMethods()[0].invoke(resource, newResource);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Error invoking method for resource: " + resource.getClass().getName()), (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

