/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalizedTextUtil {
    private static final List DEFAULT_RESOURCE_BUNDLES = Collections.synchronizedList(new ArrayList());
    private static final Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$xwork$util$LocalizedTextUtil == null ? (class$com$opensymphony$xwork$util$LocalizedTextUtil = LocalizedTextUtil.class$("com.opensymphony.xwork.util.LocalizedTextUtil")) : class$com$opensymphony$xwork$util$LocalizedTextUtil));
    static /* synthetic */ Class class$com$opensymphony$xwork$util$LocalizedTextUtil;
    static /* synthetic */ Class class$java$lang$Object;

    public static void addDefaultResourceBundle(String resourceBundleName) {
        DEFAULT_RESOURCE_BUNDLES.remove(resourceBundleName);
        DEFAULT_RESOURCE_BUNDLES.add(0, resourceBundleName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added default resource bundle " + resourceBundleName + ", default resource bundles = " + DEFAULT_RESOURCE_BUNDLES));
        }
    }

    public static String findDefaultText(String aTextName, Locale locale) throws MissingResourceException {
        MissingResourceException e = null;
        ArrayList localList = new ArrayList(DEFAULT_RESOURCE_BUNDLES);
        Iterator iterator = localList.iterator();
        while (iterator.hasNext()) {
            String bundleName = (String)iterator.next();
            try {
                ResourceBundle bundle = LocalizedTextUtil.findResourceBundle(bundleName, locale);
                return bundle.getString(aTextName);
            }
            catch (MissingResourceException ex) {
                e = ex;
            }
        }
        if (e == null) {
            e = new MissingResourceException("Unable to find text for key " + aTextName, (class$com$opensymphony$xwork$util$LocalizedTextUtil == null ? (class$com$opensymphony$xwork$util$LocalizedTextUtil = LocalizedTextUtil.class$("com.opensymphony.xwork.util.LocalizedTextUtil")) : class$com$opensymphony$xwork$util$LocalizedTextUtil).getName(), aTextName);
        }
        throw e;
    }

    public static String findDefaultText(String aTextName, Locale locale, Object[] params) throws MissingResourceException {
        return MessageFormat.format(LocalizedTextUtil.findDefaultText(aTextName, locale), params);
    }

    public static ResourceBundle findResourceBundle(String aBundleName, Locale locale) {
        return ResourceBundle.getBundle(aBundleName, locale, Thread.currentThread().getContextClassLoader());
    }

    public static String findText(Class aClass, String aTextName, Locale locale) {
        return LocalizedTextUtil.findText(aClass, aTextName, locale, aTextName, new Object[0]);
    }

    public static String findText(ResourceBundle bundle, String aTextName, Locale locale) {
        return LocalizedTextUtil.findText(bundle, aTextName, locale, aTextName, new Object[0]);
    }

    public static String findText(Class aClass, String aTextName, Locale locale, String defaultMessage, Object[] args) {
        OgnlValueStack valueStack = ActionContext.getContext().getValueStack();
        while (true) {
            try {
                ResourceBundle bundle = LocalizedTextUtil.findResourceBundle(aClass.getName(), locale);
                String message = TextParseUtil.translateVariables(bundle.getString(aTextName), valueStack);
                return MessageFormat.format(message, args);
            }
            catch (MissingResourceException ex) {
                if (!(aClass = aClass.getSuperclass()).equals(class$java$lang$Object == null ? LocalizedTextUtil.class$("java.lang.Object") : class$java$lang$Object)) continue;
                return LocalizedTextUtil.getDefaultText(aTextName, locale, valueStack, args, defaultMessage);
            }
            break;
        }
    }

    public static String findText(ResourceBundle bundle, String aTextName, Locale locale, String defaultMessage, Object[] args) {
        OgnlValueStack valueStack = ActionContext.getContext().getValueStack();
        try {
            String message = TextParseUtil.translateVariables(bundle.getString(aTextName), valueStack);
            return MessageFormat.format(message, args);
        }
        catch (MissingResourceException ex) {
            return LocalizedTextUtil.getDefaultText(aTextName, locale, valueStack, args, defaultMessage);
        }
    }

    private static String getDefaultText(String aTextName, Locale locale, OgnlValueStack valueStack, Object[] args, String defaultMessage) {
        try {
            String message = TextParseUtil.translateVariables(LocalizedTextUtil.findDefaultText(aTextName, locale), valueStack);
            return MessageFormat.format(message, args);
        }
        catch (MissingResourceException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unable to find text for key " + aTextName));
            }
            return MessageFormat.format(TextParseUtil.translateVariables(defaultMessage, valueStack), args);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_RESOURCE_BUNDLES.add("com/opensymphony/xwork/xwork-messages");
    }
}

