/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.xwork.util.XWorkConverter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import ognl.TypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OgnlUtil {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$xwork$util$OgnlUtil == null ? (class$com$opensymphony$xwork$util$OgnlUtil = OgnlUtil.class$("com.opensymphony.xwork.util.OgnlUtil")) : class$com$opensymphony$xwork$util$OgnlUtil));
    private static HashMap expressions = new HashMap();
    static /* synthetic */ Class class$com$opensymphony$xwork$util$OgnlUtil;
    static /* synthetic */ Class class$java$lang$Object;

    public static void setProperties(Map props, Object o, Map context) {
        OgnlUtil.setProperties(props, o, context, false);
    }

    public static void setProperties(Map props, Object o, Map context, boolean throwPropertyExceptions) {
        if (props == null) {
            return;
        }
        Ognl.setTypeConverter((Map)context, (TypeConverter)XWorkConverter.getInstance());
        Object oldRoot = Ognl.getRoot((Map)context);
        Ognl.setRoot((Map)context, (Object)o);
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String expression = (String)entry.getKey();
            OgnlUtil.internalSetProperty(expression, entry.getValue(), o, context, throwPropertyExceptions);
        }
        Ognl.setRoot((Map)context, (Object)oldRoot);
    }

    public static void setProperties(Map properties, Object o) {
        OgnlUtil.setProperties(properties, o, false);
    }

    public static void setProperties(Map properties, Object o, boolean throwPropertyExceptions) {
        Map context = Ognl.createDefaultContext((Object)o);
        OgnlUtil.setProperties(properties, o, context, throwPropertyExceptions);
    }

    public static void setProperty(String name, Object value, Object o, Map context) {
        OgnlUtil.setProperty(name, value, o, context, false);
    }

    public static void setProperty(String name, Object value, Object o, Map context, boolean throwPropertyExceptions) {
        Ognl.setTypeConverter((Map)context, (TypeConverter)XWorkConverter.getInstance());
        Object oldRoot = Ognl.getRoot((Map)context);
        Ognl.setRoot((Map)context, (Object)o);
        OgnlUtil.internalSetProperty(name, value, o, context, throwPropertyExceptions);
        Ognl.setRoot((Map)context, (Object)oldRoot);
    }

    public static Object compile(String expression) throws OgnlException {
        Object o = null;
        o = expressions.get(expression);
        if (o == null) {
            o = Ognl.parseExpression((String)expression);
            expressions.put(expression, o);
        }
        return o;
    }

    public static void copy(Object from, Object to, Map context) {
        Map contextFrom = Ognl.createDefaultContext((Object)from);
        Ognl.setTypeConverter((Map)contextFrom, (TypeConverter)XWorkConverter.getInstance());
        Map contextTo = Ognl.createDefaultContext((Object)to);
        Ognl.setTypeConverter((Map)contextTo, (TypeConverter)XWorkConverter.getInstance());
        BeanInfo beanInfoFrom = null;
        try {
            beanInfoFrom = Introspector.getBeanInfo(from.getClass(), class$java$lang$Object == null ? (class$java$lang$Object = OgnlUtil.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (IntrospectionException e) {
            log.error((Object)"An error occured", (Throwable)e);
            return;
        }
        PropertyDescriptor[] pds = beanInfoFrom.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            try {
                Object expr = OgnlUtil.compile(pd.getName());
                Object value = Ognl.getValue((Object)expr, (Map)contextFrom, (Object)from);
                Ognl.setValue((Object)expr, (Map)contextTo, (Object)to, (Object)value);
                continue;
            }
            catch (OgnlException e) {
                // empty catch block
            }
        }
    }

    static void internalSetProperty(String name, Object value, Object o, Map context, boolean throwPropertyExceptions) {
        try {
            Ognl.setValue((Object)OgnlUtil.compile(name), (Map)context, (Object)o, (Object)value);
        }
        catch (OgnlException e) {
            Throwable exception;
            Throwable reason = e.getReason();
            String msg = "Caught OgnlException while setting property '" + name + "' on type '" + o.getClass().getName() + "'.";
            Throwable throwable = exception = reason == null ? e : reason;
            if (throwPropertyExceptions) {
                log.error((Object)msg, exception);
                throw new RuntimeException(msg);
            }
            log.warn((Object)msg, exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

