/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.util.FileManager;
import com.opensymphony.xwork.util.CompoundRoot;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.XWorkBasicConverter;
import java.io.InputStream;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import ognl.DefaultTypeConverter;
import ognl.Evaluation;
import ognl.OgnlContext;
import ognl.TypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XWorkConverter
extends DefaultTypeConverter {
    private static XWorkConverter instance;
    private static final Log LOG;
    public static final String REPORT_CONVERSION_ERRORS = "report.conversion.errors";
    public static final String CONVERSION_PROPERTY_FULLNAME = "conversion.property.fullName";
    HashMap defaultMappings = new HashMap();
    HashSet unknownMappings = new HashSet();
    HashMap mappings = new HashMap();
    HashSet noMapping = new HashSet();
    TypeConverter defaultTypeConverter = new XWorkBasicConverter();
    static /* synthetic */ Class class$com$opensymphony$xwork$util$XWorkConverter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$com$opensymphony$xwork$util$CompoundRoot;

    private XWorkConverter() {
        try {
            this.loadConversionProps("xwork-default-conversion.properties");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.loadConversionProps("xwork-conversion.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getConversionErrorMessage(String propertyName, OgnlValueStack stack) {
        String defaultMessage = "Invalid field value for field \"" + propertyName + "\".";
        String getTextExpression = "getText('invalid.fieldvalue." + propertyName + "','" + defaultMessage + "')";
        String message = (String)stack.findValue(getTextExpression);
        if (message == null) {
            message = defaultMessage;
        }
        return message;
    }

    public static XWorkConverter getInstance() {
        if (instance == null) {
            instance = new XWorkConverter();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    public void setDefaultConverter(TypeConverter defaultTypeConverter) {
        this.defaultTypeConverter = defaultTypeConverter;
    }

    public Object convertValue(Map context, Object target, Member member, String property, Object value, Class toClass) {
        TypeConverter tc = null;
        if (target != null) {
            Class clazz = null;
            clazz = target.getClass();
            Object[] classProp = null;
            if (target instanceof CompoundRoot && context != null) {
                classProp = this.getClassProperty(context);
            }
            if (classProp != null) {
                clazz = (Class)classProp[0];
                property = (String)classProp[1];
            }
            if (!this.noMapping.contains(clazz)) {
                try {
                    Map mapping = (Map)this.mappings.get(clazz);
                    mapping = mapping == null ? this.buildConverterMapping(clazz) : this.conditionalReload(clazz, mapping);
                    tc = (TypeConverter)mapping.get(property);
                }
                catch (Throwable t) {
                    this.noMapping.add(clazz);
                }
            }
        }
        if (tc == null) {
            tc = toClass.equals(class$java$lang$String == null ? (class$java$lang$String = XWorkConverter.class$("java.lang.String")) : class$java$lang$String) && value != null && !value.getClass().equals(class$java$lang$String == null ? (class$java$lang$String = XWorkConverter.class$("java.lang.String")) : class$java$lang$String) && !value.getClass().equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = XWorkConverter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) ? this.lookup(value.getClass()) : this.lookup(toClass);
        }
        if (tc != null) {
            try {
                return tc.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                this.handleConversionException(context, property, value, target);
                return this.acceptableErrorValue(toClass);
            }
        }
        if (this.defaultTypeConverter != null) {
            try {
                return this.defaultTypeConverter.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                this.handleConversionException(context, property, value, target);
                return this.acceptableErrorValue(toClass);
            }
        }
        try {
            return super.convertValue(context, target, member, property, value, toClass);
        }
        catch (Exception e) {
            this.handleConversionException(context, property, value, target);
            return this.acceptableErrorValue(toClass);
        }
    }

    private Object[] getClassProperty(Map context) {
        Object[] classProp = null;
        OgnlContext ognlContext = (OgnlContext)context;
        Evaluation eval = ognlContext.getCurrentEvaluation();
        if (eval == null) {
            eval = ognlContext.getLastEvaluation();
        }
        if (eval != null && eval.getLastChild() != null) {
            classProp = new Object[2];
            classProp[0] = eval.getLastChild().getLastChild() != null && eval.getLastChild().getLastChild().getSource() != null && eval.getLastChild().getLastChild().getSource().getClass() != (class$com$opensymphony$xwork$util$CompoundRoot == null ? (class$com$opensymphony$xwork$util$CompoundRoot = XWorkConverter.class$("com.opensymphony.xwork.util.CompoundRoot")) : class$com$opensymphony$xwork$util$CompoundRoot) ? eval.getLastChild().getLastChild().getSource().getClass() : eval.getLastChild().getSource().getClass();
            String property = eval.getNode().jjtGetChild(eval.getNode().jjtGetNumChildren() - 1).toString();
            if (property.startsWith("\"") && property.endsWith("\"")) {
                property = property.substring(1, property.length() - 1);
            }
            classProp[1] = property;
        }
        return classProp;
    }

    public TypeConverter lookup(String className) {
        if (this.unknownMappings.contains(className)) {
            return null;
        }
        TypeConverter result = (TypeConverter)this.defaultMappings.get(className);
        if (result == null) {
            Class<?> clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            result = this.lookupSuper(clazz);
            if (result != null) {
                this.registerConverter(className, result);
            } else {
                this.registerConverterNotFound(className);
            }
        }
        return result;
    }

    public TypeConverter lookup(Class clazz) {
        return this.lookup(clazz.getName());
    }

    protected synchronized void registerConverter(String className, TypeConverter converter) {
        this.defaultMappings.put(className, converter);
    }

    protected synchronized void registerConverterNotFound(String className) {
        this.unknownMappings.add(className);
    }

    protected void handleConversionException(Map context, String property, Object value, Object object) {
        if (context.get(REPORT_CONVERSION_ERRORS) == Boolean.TRUE) {
            HashMap<String, Object> conversionErrors;
            String realProperty = property;
            String fullName = (String)context.get(CONVERSION_PROPERTY_FULLNAME);
            if (fullName != null) {
                realProperty = fullName;
            }
            if ((conversionErrors = (HashMap<String, Object>)context.get("com.opensymphony.xwork.ActionContext.conversionErrors")) == null) {
                conversionErrors = new HashMap<String, Object>();
                context.put("com.opensymphony.xwork.ActionContext.conversionErrors", conversionErrors);
            }
            conversionErrors.put(realProperty, value);
        }
    }

    private Object acceptableErrorValue(Class toClass) {
        if (!toClass.isPrimitive()) {
            return null;
        }
        if (toClass == Integer.TYPE) {
            return new Integer(0);
        }
        if (toClass == Double.TYPE) {
            return new Double(0.0);
        }
        if (toClass == Long.TYPE) {
            return new Long(0L);
        }
        if (toClass == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (toClass == Short.TYPE) {
            return new Short(0);
        }
        if (toClass == Float.TYPE) {
            return new Float(0.0f);
        }
        if (toClass == Byte.TYPE) {
            return new Byte(0);
        }
        if (toClass == Character.TYPE) {
            return new Character('\u0000');
        }
        return null;
    }

    public static String buildConverterFilename(Class clazz) {
        String className = clazz.getName();
        String resource = className.replace('.', '/') + "-conversion.properties";
        return resource;
    }

    private Map buildConverterMapping(Class clazz) throws Exception {
        HashMap<Object, Object> mapping = new HashMap<Object, Object>();
        String resource = XWorkConverter.buildConverterFilename(clazz);
        InputStream is = FileManager.loadFile((String)resource, (Class)clazz);
        if (is != null) {
            Properties props = new Properties();
            props.load(is);
            mapping.putAll(props);
            Iterator iterator = mapping.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String propName = (String)entry.getKey();
                String className = (String)entry.getValue();
                if (propName.startsWith("Collection_")) continue;
                entry.setValue(this.createTypeConverter(className));
            }
            this.mappings.put(clazz, mapping);
        } else {
            this.noMapping.add(clazz);
        }
        return mapping;
    }

    private Map conditionalReload(Class clazz, Map oldValues) throws Exception {
        Map mapping = oldValues;
        if (FileManager.isReloadingConfigs() && FileManager.fileNeedsReloading((String)XWorkConverter.buildConverterFilename(clazz))) {
            mapping = this.buildConverterMapping(clazz);
        }
        return mapping;
    }

    private TypeConverter createTypeConverter(String className) throws Exception, InstantiationException {
        Class<?> conversionClass = Thread.currentThread().getContextClassLoader().loadClass(className);
        return (TypeConverter)conversionClass.newInstance();
    }

    private void loadConversionProps(String propsName) throws Exception {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propsName);
        Properties props = new Properties();
        props.load(is);
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            try {
                this.defaultMappings.put(key, this.createTypeConverter((String)entry.getValue()));
            }
            catch (Exception e) {
                LOG.error((Object)"Conversion registration error", (Throwable)e);
            }
        }
    }

    private TypeConverter lookupSuper(Class clazz) {
        TypeConverter result = null;
        if (clazz != null && (result = (TypeConverter)this.defaultMappings.get(clazz.getName())) == null) {
            int i = 0;
            Class<?>[] interfaces = clazz.getInterfaces();
            if (i < interfaces.length && this.defaultMappings.containsKey(interfaces[i].getName())) {
                result = (TypeConverter)this.defaultMappings.get(interfaces[i].getName());
            }
            if (result == null) {
                result = this.lookupSuper(clazz.getSuperclass());
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOG = LogFactory.getLog((Class)(class$com$opensymphony$xwork$util$XWorkConverter == null ? (class$com$opensymphony$xwork$util$XWorkConverter = XWorkConverter.class$("com.opensymphony.xwork.util.XWorkConverter")) : class$com$opensymphony$xwork$util$XWorkConverter));
    }
}

