/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.xwork.validator.Validator;
import com.opensymphony.xwork.validator.ValidatorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidatorFileParser {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$xwork$validator$ValidatorFileParser == null ? (class$com$opensymphony$xwork$validator$ValidatorFileParser = ValidatorFileParser.class$("com.opensymphony.xwork.validator.ValidatorFileParser")) : class$com$opensymphony$xwork$validator$ValidatorFileParser));
    static /* synthetic */ Class class$com$opensymphony$xwork$validator$ValidatorFileParser;

    public static List parseActionValidators(InputStream is) {
        ArrayList validators = new ArrayList();
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(true);
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if ("-//OpenSymphony Group//XWork Validator 1.0//EN".equals(publicId)) {
                        ClassLoader loader = Thread.currentThread().getContextClassLoader();
                        return new InputSource(loader.getResourceAsStream("xwork-validator-1.0.dtd"));
                    }
                    return null;
                }
            });
            builder.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) throws SAXException {
                    log.warn((Object)(exception.getMessage() + " at (" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ")"));
                }

                public void error(SAXParseException exception) throws SAXException {
                    log.error((Object)(exception.getMessage() + " at (" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ")"));
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    log.fatal((Object)(exception.getMessage() + " at (" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ")"));
                }
            });
            doc = builder.parse(is);
        }
        catch (Exception e) {
            log.fatal((Object)"Caught exception while attempting to load validation configuration file.", (Throwable)e);
        }
        if (doc != null) {
            NodeList fieldNodes = doc.getElementsByTagName("field");
            for (int i = 0; i < fieldNodes.getLength(); ++i) {
                Element fieldElement = (Element)fieldNodes.item(i);
                String fieldName = fieldElement.getAttribute("name");
                HashMap<String, String> extraParams = new HashMap<String, String>();
                extraParams.put("fieldName", fieldName);
                NodeList validatorNodes = fieldElement.getElementsByTagName("field-validator");
                ValidatorFileParser.addValidators(validatorNodes, extraParams, validators);
            }
            NodeList validatorNodes = doc.getElementsByTagName("validator");
            ValidatorFileParser.addValidators(validatorNodes, new HashMap(), validators);
        }
        return validators;
    }

    public static void parseValidatorDefinitions(InputStream is) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(is);
            NodeList nodes = doc.getElementsByTagName("validator");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element validatorElement = (Element)nodes.item(i);
                String name = validatorElement.getAttribute("name");
                String className = validatorElement.getAttribute("class");
                Class clazz = null;
                try {
                    clazz = ClassLoaderUtil.loadClass((String)className, (Class)(class$com$opensymphony$xwork$validator$ValidatorFileParser == null ? ValidatorFileParser.class$("com.opensymphony.xwork.validator.ValidatorFileParser") : class$com$opensymphony$xwork$validator$ValidatorFileParser));
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)"Unable to load validator class");
                }
                if (clazz == null) continue;
                ValidatorFactory.registerValidator(name, clazz);
            }
        }
        catch (Exception e) {
            log.error((Object)"Caught exception while parsing validator definitions.");
        }
    }

    private static void addValidators(NodeList validatorNodes, Map extraParams, List validators) {
        for (int j = 0; j < validatorNodes.getLength(); ++j) {
            Node defaultMessageNode;
            Element validatorElement = (Element)validatorNodes.item(j);
            String validatorType = validatorElement.getAttribute("type");
            HashMap<String, String> params = new HashMap<String, String>(extraParams);
            NodeList paramNodes = validatorElement.getElementsByTagName("param");
            for (int k = 0; k < paramNodes.getLength(); ++k) {
                Element paramElement = (Element)paramNodes.item(k);
                String paramName = paramElement.getAttribute("name");
                String paramValue = paramElement.getFirstChild().getNodeValue();
                params.put(paramName, paramValue);
            }
            Validator validator = ValidatorFactory.getValidator(validatorType, params);
            NodeList messageNodes = validatorElement.getElementsByTagName("message");
            Element messageElement = (Element)messageNodes.item(0);
            String key = messageElement.getAttribute("key");
            if (key != null && key.trim().length() > 0) {
                validator.setMessageKey(key);
            }
            String defaultMessage = (defaultMessageNode = messageElement.getFirstChild()) == null ? "" : defaultMessageNode.getNodeValue();
            validator.setDefaultMessage(defaultMessage);
            validators.add(validator);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

