/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.configuration.resolver;

import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import com.google.inject.util.Providers;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Provider;
import org.nnsoft.guice.rocoto.configuration.resolver.VariableResolverProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesResolverProvider
implements Provider<String> {
    private static final String VAR_BEGIN = "$";
    private static final String PIPE_SEPARATOR = "|";
    private final List<Provider<String>> fragments = new ArrayList<Provider<String>>();
    private final List<VariableResolverProvider> resolvers = new ArrayList<VariableResolverProvider>();

    public PropertiesResolverProvider(String pattern) {
        int pos;
        int prev = 0;
        while ((pos = pattern.indexOf(VAR_BEGIN, prev)) >= 0) {
            if (pos > 0) {
                this.fragments.add((Provider<String>)Providers.of((Object)pattern.substring(prev, pos)));
            }
            if (pos == pattern.length() - 1) {
                this.fragments.add((Provider<String>)Providers.of((Object)VAR_BEGIN));
                prev = pos + 1;
                continue;
            }
            if (pattern.charAt(pos + 1) != '{') {
                if (pattern.charAt(pos + 1) == '$') {
                    this.fragments.add((Provider<String>)Providers.of((Object)VAR_BEGIN));
                    prev = pos + 2;
                    continue;
                }
                this.fragments.add((Provider<String>)Providers.of((Object)pattern.substring(pos, pos + 2)));
                prev = pos + 2;
                continue;
            }
            int endName = pattern.indexOf(125, pos);
            if (endName < 0) {
                throw new ProvisionException("Syntax error in property: " + pattern);
            }
            StringTokenizer keyTokenizer = new StringTokenizer(pattern.substring(pos + 2, endName), PIPE_SEPARATOR);
            String key = keyTokenizer.nextToken().trim();
            String defaultValue = null;
            if (keyTokenizer.hasMoreTokens()) {
                defaultValue = keyTokenizer.nextToken().trim();
            }
            VariableResolverProvider variableResolver = new VariableResolverProvider(key, defaultValue);
            this.fragments.add((Provider<String>)variableResolver);
            this.resolvers.add(variableResolver);
            prev = endName + 1;
        }
        if (prev < pattern.length()) {
            this.fragments.add((Provider<String>)Providers.of((Object)pattern.substring(prev)));
        }
    }

    public boolean containsKeys() {
        return !this.resolvers.isEmpty();
    }

    @Inject
    public void setInjector(Injector injector) {
        for (VariableResolverProvider variableResolver : this.resolvers) {
            variableResolver.setInjector(injector);
        }
    }

    public String get() {
        StringBuilder buffer = new StringBuilder();
        for (Provider<String> appender : this.fragments) {
            buffer.append((String)appender.get());
        }
        return buffer.toString();
    }

    public String toString() {
        return this.fragments.toString();
    }
}

