/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.configuration.resolver;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VariableResolverProvider
implements Provider<String> {
    private static final String KEY_PREFIX = "${";
    private final String variableName;
    private final String defaultValue;
    private Injector injector;

    public VariableResolverProvider(String variableName, String defaultValue) {
        this.variableName = variableName;
        this.defaultValue = defaultValue;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public String get() {
        try {
            return (String)this.injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)this.variableName)));
        }
        catch (Throwable e) {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            return KEY_PREFIX + this.variableName + '}';
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(KEY_PREFIX).append(this.variableName);
        if (this.defaultValue != null) {
            builder.append('|').append(this.defaultValue);
        }
        builder.append('}');
        return builder.toString();
    }
}

