/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.variables;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.nnsoft.guice.rocoto.variables.AntStyleParser;
import org.nnsoft.guice.rocoto.variables.Parser;
import org.nnsoft.guice.rocoto.variables.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VariablesMap
implements Map<String, String> {
    private Parser parser;
    private final Map<String, VariableValue> resolvers = new HashMap<String, VariableValue>();
    private final Map<String, String> snapshot = new HashMap<String, String>();

    public VariablesMap(Parser parser) {
        this.setParser(parser);
    }

    public VariablesMap() {
        this(new AntStyleParser());
    }

    @Override
    public void clear() {
        this.resolvers.clear();
        this.snapshot.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.snapshot.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.snapshot.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.snapshot.entrySet();
    }

    @Override
    public String get(Object key) {
        return this.snapshot.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.snapshot.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.snapshot.keySet();
    }

    @Override
    public String put(String key, String value) {
        this.putValue(key, value);
        this.resolveVariables();
        return this.snapshot.get(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> t) {
        for (Map.Entry<? extends String, ? extends String> entry : t.entrySet()) {
            this.putValue(entry.getKey(), entry.getValue());
        }
        this.resolveVariables();
    }

    public void putAll(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.putValue(entry.getKey().toString(), entry.getValue().toString());
        }
        this.resolveVariables();
    }

    private void putValue(String key, String value) {
        this.snapshot.put(key, value);
        this.resolvers.put(key, new VariableValue(value, this.parser.parse(value)));
    }

    private void resolveVariables() {
        for (Map.Entry<String, VariableValue> entry : this.resolvers.entrySet()) {
            if (!entry.getValue().needsResolving()) continue;
            this.snapshot.put(entry.getKey(), entry.getValue().resolve(this.snapshot));
        }
    }

    @Override
    public String remove(Object key) {
        String value = null;
        if (this.containsKey(key)) {
            value = this.snapshot.remove(key);
            this.resolvers.remove(key);
            this.resolveVariables();
        }
        return value;
    }

    @Override
    public int size() {
        return this.snapshot.size();
    }

    @Override
    public Collection<String> values() {
        return this.snapshot.values();
    }

    public String toString() {
        return this.snapshot.toString();
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser == null ? new AntStyleParser() : parser;
        this.applyParser();
    }

    private void applyParser() {
        this.snapshot.clear();
        HashMap<String, String> originals = new HashMap<String, String>(this.resolvers.size());
        for (Map.Entry<String, VariableValue> resolver : this.resolvers.entrySet()) {
            originals.put(resolver.getKey(), resolver.getValue().getOriginal());
        }
        this.putAll((Map<? extends String, ? extends String>)originals);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VariableValue
    implements Resolver {
        private final String original;
        private final Resolver resolver;

        private VariableValue(String original, Resolver resolver) {
            this.original = original;
            this.resolver = resolver;
        }

        public String toString() {
            return MessageFormat.format("VariableValue[original=''{0}'',resolver=''{1}'']", this.original, this.resolver);
        }

        public String getOriginal() {
            return this.original;
        }

        @Override
        public String resolve(Map<String, String> data) {
            return this.resolver.resolve(data);
        }

        @Override
        public boolean needsResolving() {
            return this.resolver.needsResolving();
        }
    }
}

