/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.jaas;

import java.io.IOException;
import java.security.Principal;
import java.security.Security;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.acegisecurity.AcegiSecurityException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.providers.AuthenticationProvider;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.jaas.AuthorityGranter;
import org.acegisecurity.providers.jaas.DefaultLoginExceptionResolver;
import org.acegisecurity.providers.jaas.JaasAuthenticationCallbackHandler;
import org.acegisecurity.providers.jaas.JaasAuthenticationToken;
import org.acegisecurity.providers.jaas.JaasGrantedAuthority;
import org.acegisecurity.providers.jaas.LoginExceptionResolver;
import org.acegisecurity.providers.jaas.event.JaasAuthenticationFailedEvent;
import org.acegisecurity.providers.jaas.event.JaasAuthenticationSuccessEvent;
import org.acegisecurity.ui.session.HttpSessionDestroyedEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class JaasAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
ApplicationContextAware,
ApplicationListener,
Ordered {
    protected static final Log log = LogFactory.getLog((Class)(class$org$acegisecurity$providers$jaas$JaasAuthenticationProvider == null ? (class$org$acegisecurity$providers$jaas$JaasAuthenticationProvider = JaasAuthenticationProvider.class$("org.acegisecurity.providers.jaas.JaasAuthenticationProvider")) : class$org$acegisecurity$providers$jaas$JaasAuthenticationProvider));
    private ApplicationContext context;
    private LoginExceptionResolver loginExceptionResolver = new DefaultLoginExceptionResolver();
    private Resource loginConfig;
    private String loginContextName = "ACEGI";
    private AuthorityGranter[] authorityGranters;
    private JaasAuthenticationCallbackHandler[] callbackHandlers;
    private int order = -1;
    static /* synthetic */ Class class$org$acegisecurity$providers$jaas$JaasAuthenticationProvider;
    static /* synthetic */ Class class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.loginConfig, (String)("loginConfig must be set on " + this.getClass()));
        Assert.hasLength((String)this.loginContextName, (String)("loginContextName must be set on " + this.getClass()));
        this.configureJaas(this.loginConfig);
        Assert.notNull((Object)Configuration.getConfiguration(), (String)"As per http://java.sun.com/j2se/1.5.0/docs/api/javax/security/auth/login/Configuration.html \"If a Configuration object was set via the Configuration.setConfiguration method, then that object is returned. Otherwise, a default Configuration object is returned\". Your JRE returned null to Configuration.getConfiguration().");
    }

    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        if (auth instanceof UsernamePasswordAuthenticationToken) {
            UsernamePasswordAuthenticationToken request = (UsernamePasswordAuthenticationToken)auth;
            try {
                LoginContext loginContext = new LoginContext(this.loginContextName, new InternalCallbackHandler(auth));
                loginContext.login();
                HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
                if (request.getAuthorities() != null) {
                    authorities.addAll(Arrays.asList(request.getAuthorities()));
                }
                Set<Principal> principals = loginContext.getSubject().getPrincipals();
                Iterator<Principal> iterator = principals.iterator();
                while (iterator.hasNext()) {
                    Principal principal = iterator.next();
                    for (int i = 0; i < this.authorityGranters.length; ++i) {
                        AuthorityGranter granter = this.authorityGranters[i];
                        Set roles = granter.grant(principal);
                        if (roles == null || roles.isEmpty()) continue;
                        Iterator roleIterator = roles.iterator();
                        while (roleIterator.hasNext()) {
                            String role = roleIterator.next().toString();
                            authorities.add(new JaasGrantedAuthority(role, principal));
                        }
                    }
                }
                JaasAuthenticationToken result = new JaasAuthenticationToken(request.getPrincipal(), request.getCredentials(), authorities.toArray(new GrantedAuthority[authorities.size()]), loginContext);
                this.publishSuccessEvent(result);
                return result;
            }
            catch (LoginException loginException) {
                AcegiSecurityException ase = this.loginExceptionResolver.resolveException(loginException);
                this.publishFailureEvent(request, ase);
                throw ase;
            }
        }
        return null;
    }

    protected void configureJaas(Resource loginConfig) throws IOException {
        this.configureJaasUsingLoop();
    }

    private void configureJaasUsingLoop() throws IOException {
        String loginConfigUrl = this.loginConfig.getURL().toString();
        boolean alreadySet = false;
        int n = 1;
        String prefix = "login.config.url.";
        String existing = null;
        while ((existing = Security.getProperty(prefix + n)) != null && !(alreadySet = existing.equals(loginConfigUrl))) {
            ++n;
        }
        if (!alreadySet) {
            String key = prefix + n;
            log.debug((Object)("Setting security property [" + key + "] to: " + loginConfigUrl));
            Security.setProperty(key, loginConfigUrl);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    public AuthorityGranter[] getAuthorityGranters() {
        return this.authorityGranters;
    }

    public JaasAuthenticationCallbackHandler[] getCallbackHandlers() {
        return this.callbackHandlers;
    }

    public Resource getLoginConfig() {
        return this.loginConfig;
    }

    public String getLoginContextName() {
        return this.loginContextName;
    }

    public LoginExceptionResolver getLoginExceptionResolver() {
        return this.loginExceptionResolver;
    }

    protected void handleLogout(HttpSessionDestroyedEvent event) {
        SecurityContext context = (SecurityContext)event.getSession().getAttribute("ACEGI_SECURITY_CONTEXT");
        if (context == null) {
            log.debug((Object)"The destroyed session has no SecurityContext");
            return;
        }
        Authentication auth = context.getAuthentication();
        if (auth != null && auth instanceof JaasAuthenticationToken) {
            JaasAuthenticationToken token = (JaasAuthenticationToken)auth;
            try {
                LoginContext loginContext = token.getLoginContext();
                if (loginContext != null) {
                    log.debug((Object)("Logging principal: [" + token.getPrincipal() + "] out of LoginContext"));
                    loginContext.logout();
                } else {
                    log.debug((Object)("Cannot logout principal: [" + token.getPrincipal() + "] from LoginContext. " + "The LoginContext is unavailable"));
                }
            }
            catch (LoginException e) {
                log.warn((Object)"Error error logging out of LoginContext", (Throwable)e);
            }
        }
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof HttpSessionDestroyedEvent) {
            HttpSessionDestroyedEvent event = (HttpSessionDestroyedEvent)applicationEvent;
            this.handleLogout(event);
        }
    }

    protected void publishFailureEvent(UsernamePasswordAuthenticationToken token, AcegiSecurityException ase) {
        this.getApplicationContext().publishEvent((ApplicationEvent)new JaasAuthenticationFailedEvent(token, (Exception)((Object)ase)));
    }

    protected void publishSuccessEvent(UsernamePasswordAuthenticationToken token) {
        this.getApplicationContext().publishEvent((ApplicationEvent)new JaasAuthenticationSuccessEvent(token));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void setAuthorityGranters(AuthorityGranter[] authorityGranters) {
        this.authorityGranters = authorityGranters;
    }

    public void setCallbackHandlers(JaasAuthenticationCallbackHandler[] callbackHandlers) {
        this.callbackHandlers = callbackHandlers;
    }

    public void setLoginConfig(Resource loginConfig) {
        this.loginConfig = loginConfig;
    }

    public void setLoginContextName(String loginContextName) {
        this.loginContextName = loginContextName;
    }

    public void setLoginExceptionResolver(LoginExceptionResolver loginExceptionResolver) {
        this.loginExceptionResolver = loginExceptionResolver;
    }

    public boolean supports(Class aClass) {
        return (class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken = JaasAuthenticationProvider.class$("org.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken).isAssignableFrom(aClass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InternalCallbackHandler
    implements CallbackHandler {
        private Authentication authentication;

        public InternalCallbackHandler(Authentication authentication) {
            this.authentication = authentication;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < JaasAuthenticationProvider.this.callbackHandlers.length; ++i) {
                JaasAuthenticationCallbackHandler handler = JaasAuthenticationProvider.this.callbackHandlers[i];
                for (int j = 0; j < callbacks.length; ++j) {
                    Callback callback = callbacks[j];
                    handler.handle(callback, this.authentication);
                }
            }
        }
    }
}

