/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator.delegate.event.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.activiti.crystalball.simulator.CrystalballException;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.delegate.event.impl.EventLog2SimulationEventFunction;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.event.EventLogEntry;

public class EventLogUserTaskCompleteTransformer
extends EventLog2SimulationEventFunction {
    public static final String PROCESS_INSTANCE_ID = "processInstanceId";
    public static final String TASK_DEFINITION_KEY = "taskDefinitionKey";
    public static final String TASK_VARIABLES = "taskVariables";
    public static final String VARIABLES_LOCAL_SCOPE = "variablesLocalScope";

    public EventLogUserTaskCompleteTransformer(String simulationEventType) {
        super(simulationEventType);
    }

    @Override
    public SimulationEvent apply(EventLogEntry event) {
        if (ActivitiEventType.TASK_COMPLETED.toString().equals(event.getType())) {
            Map data;
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                data = (Map)objectMapper.readValue(event.getData(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            }
            catch (IOException e) {
                throw new CrystalballException("unable to parse JSON string.", e);
            }
            String taskIdValue = (String)data.get("activityId");
            boolean localScope = false;
            Map variableMap = null;
            if (data.get("variables") != null) {
                variableMap = (Map)data.get("variables");
            } else {
                variableMap = (Map)data.get("localVariables");
                localScope = true;
            }
            String taskDefinitionKeyValue = (String)data.get(TASK_DEFINITION_KEY);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("taskId", taskIdValue);
            properties.put(TASK_DEFINITION_KEY, taskDefinitionKeyValue);
            properties.put(PROCESS_INSTANCE_ID, event.getProcessInstanceId());
            if (variableMap != null) {
                properties.put(TASK_VARIABLES, variableMap);
                properties.put(VARIABLES_LOCAL_SCOPE, localScope);
            }
            return new SimulationEvent.Builder(this.simulationEventType).priority((int)event.getLogNumber()).properties(properties).build();
        }
        return null;
    }
}

